/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GLBufferChecks;

public final class ATIElementArray {
    public static final int GL_ELEMENT_ARRAY_ATI = 34664;
    public static final int GL_ELEMENT_ARRAY_TYPE_ATI = 34665;
    public static final int GL_ELEMENT_ARRAY_POINTER_ATI = 34666;

    private ATIElementArray() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glElementPointerATI(ByteBuffer pPointer) {
        BufferChecks.checkDirect(pPointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        ATIElementArray.nglElementPointerATI(5121, pPointer, pPointer.position());
    }

    public static void glElementPointerATI(ShortBuffer pPointer) {
        BufferChecks.checkDirect(pPointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        ATIElementArray.nglElementPointerATI(5123, pPointer, pPointer.position() << 1);
    }

    public static void glElementPointerATI(IntBuffer pPointer) {
        BufferChecks.checkDirect(pPointer);
        GLBufferChecks.ensureArrayVBOdisabled();
        ATIElementArray.nglElementPointerATI(5125, pPointer, pPointer.position() << 2);
    }

    private static native void nglElementPointerATI(int var0, Buffer var1, int var2);

    public static void glElementPointerATI(int type, int buffer_offset) {
        GLBufferChecks.ensureArrayVBOenabled();
        ATIElementArray.nglElementPointerATIVBO(type, buffer_offset);
    }

    private static native void nglElementPointerATIVBO(int var0, int var1);

    public static native void glDrawElementArrayATI(int var0, int var1);

    public static native void glDrawRangeElementArrayATI(int var0, int var1, int var2, int var3);
}

