/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;

public final class ARBShaderObjects {
    public static final int GL_PROGRAM_OBJECT_ARB = 35648;
    public static final int GL_OBJECT_TYPE_ARB = 35662;
    public static final int GL_OBJECT_SUBTYPE_ARB = 35663;
    public static final int GL_OBJECT_DELETE_STATUS_ARB = 35712;
    public static final int GL_OBJECT_COMPILE_STATUS_ARB = 35713;
    public static final int GL_OBJECT_LINK_STATUS_ARB = 35714;
    public static final int GL_OBJECT_VALIDATE_STATUS_ARB = 35715;
    public static final int GL_OBJECT_INFO_LOG_LENGTH_ARB = 35716;
    public static final int GL_OBJECT_ATTACHED_OBJECTS_ARB = 35717;
    public static final int GL_OBJECT_ACTIVE_UNIFORMS_ARB = 35718;
    public static final int GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 35719;
    public static final int GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 35720;
    public static final int GL_SHADER_OBJECT_ARB = 35656;
    public static final int GL_FLOAT = 5126;
    public static final int GL_FLOAT_VEC2_ARB = 35664;
    public static final int GL_FLOAT_VEC3_ARB = 35665;
    public static final int GL_FLOAT_VEC4_ARB = 35666;
    public static final int GL_INT = 5124;
    public static final int GL_INT_VEC2_ARB = 35667;
    public static final int GL_INT_VEC3_ARB = 35668;
    public static final int GL_INT_VEC4_ARB = 35669;
    public static final int GL_BOOL_ARB = 35670;
    public static final int GL_BOOL_VEC2_ARB = 35671;
    public static final int GL_BOOL_VEC3_ARB = 35672;
    public static final int GL_BOOL_VEC4_ARB = 35673;
    public static final int GL_FLOAT_MAT2_ARB = 35674;
    public static final int GL_FLOAT_MAT3_ARB = 35675;
    public static final int GL_FLOAT_MAT4_ARB = 35676;
    public static final int GL_SAMPLER_1D_ARB = 35677;
    public static final int GL_SAMPLER_2D_ARB = 35678;
    public static final int GL_SAMPLER_3D_ARB = 35679;
    public static final int GL_SAMPLER_CUBE_ARB = 35680;
    public static final int GL_SAMPLER_1D_SHADOW_ARB = 35681;
    public static final int GL_SAMPLER_2D_SHADOW_ARB = 35682;
    public static final int GL_SAMPLER_2D_RECT_ARB = 35683;
    public static final int GL_SAMPLER_2D_RECT_SHADOW_ARB = 35684;

    private ARBShaderObjects() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static native void glDeleteObjectARB(int var0);

    public static native int glGetHandleARB(int var0);

    public static native void glDetachObjectARB(int var0, int var1);

    public static native int glCreateShaderObjectARB(int var0);

    public static void glShaderSourceARB(int shaderObj, ByteBuffer string) {
        BufferChecks.checkDirect(string);
        ARBShaderObjects.initShaderSource(1);
        ARBShaderObjects.setShaderString(0, string, string.position(), string.remaining());
        ARBShaderObjects.nglShaderSourceARB(shaderObj);
    }

    public static void glShaderSourceARB(int shaderObj, ByteBuffer[] strings) {
        if (strings == null || strings.length == 0) {
            throw new IllegalArgumentException("Invalid shader string array.");
        }
        ARBShaderObjects.initShaderSource(strings.length);
        int i = 0;
        while (i < strings.length) {
            BufferChecks.checkDirect(strings[i]);
            ARBShaderObjects.setShaderString(i, strings[i], strings[i].position(), strings[i].remaining());
            ++i;
        }
        ARBShaderObjects.nglShaderSourceARB(shaderObj);
    }

    private static native void initShaderSource(int var0);

    private static native void setShaderString(int var0, ByteBuffer var1, int var2, int var3);

    private static native void nglShaderSourceARB(int var0);

    public static native void glCompileShaderARB(int var0);

    public static native int glCreateProgramObjectARB();

    public static native void glAttachObjectARB(int var0, int var1);

    public static native void glLinkProgramARB(int var0);

    public static native void glUseProgramObjectARB(int var0);

    public static native void glValidateProgramARB(int var0);

    public static native void glUniform1fARB(int var0, float var1);

    public static native void glUniform2fARB(int var0, float var1, float var2);

    public static native void glUniform3fARB(int var0, float var1, float var2, float var3);

    public static native void glUniform4fARB(int var0, float var1, float var2, float var3, float var4);

    public static native void glUniform1iARB(int var0, int var1);

    public static native void glUniform2iARB(int var0, int var1, int var2);

    public static native void glUniform3iARB(int var0, int var1, int var2, int var3);

    public static native void glUniform4iARB(int var0, int var1, int var2, int var3, int var4);

    public static void glUniform1ARB(int location, FloatBuffer values) {
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform1fvARB(location, values.remaining(), values, values.position());
    }

    private static native void nglUniform1fvARB(int var0, int var1, FloatBuffer var2, int var3);

    public static void glUniform2ARB(int location, FloatBuffer values) {
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform2fvARB(location, values.remaining() >> 1, values, values.position());
    }

    private static native void nglUniform2fvARB(int var0, int var1, FloatBuffer var2, int var3);

    public static void glUniform3ARB(int location, FloatBuffer values) {
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform3fvARB(location, values.remaining() / 3, values, values.position());
    }

    private static native void nglUniform3fvARB(int var0, int var1, FloatBuffer var2, int var3);

    public static void glUniform4ARB(int location, FloatBuffer values) {
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform4fvARB(location, values.remaining() >> 2, values, values.position());
    }

    private static native void nglUniform4fvARB(int var0, int var1, FloatBuffer var2, int var3);

    public static void glUniform1ARB(int location, IntBuffer values) {
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform1ivARB(location, values.remaining(), values, values.position());
    }

    private static native void nglUniform1ivARB(int var0, int var1, IntBuffer var2, int var3);

    public static void glUniform2ARB(int location, IntBuffer values) {
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform2ivARB(location, values.remaining() >> 1, values, values.position());
    }

    private static native void nglUniform2ivARB(int var0, int var1, IntBuffer var2, int var3);

    public static void glUniform3ARB(int location, IntBuffer values) {
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform3ivARB(location, values.remaining() / 3, values, values.position());
    }

    private static native void nglUniform3ivARB(int var0, int var1, IntBuffer var2, int var3);

    public static void glUniform4ARB(int location, IntBuffer values) {
        BufferChecks.checkDirect(values);
        ARBShaderObjects.nglUniform4ivARB(location, values.remaining() >> 2, values, values.position());
    }

    private static native void nglUniform4ivARB(int var0, int var1, IntBuffer var2, int var3);

    public static void glUniformMatrix2ARB(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        ARBShaderObjects.nglUniformMatrix2fvARB(location, matrices.remaining() >> 2, transpose, matrices, matrices.position());
    }

    private static native void nglUniformMatrix2fvARB(int var0, int var1, boolean var2, FloatBuffer var3, int var4);

    public static void glUniformMatrix3ARB(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        ARBShaderObjects.nglUniformMatrix3fvARB(location, matrices.remaining() / 9, transpose, matrices, matrices.position());
    }

    private static native void nglUniformMatrix3fvARB(int var0, int var1, boolean var2, FloatBuffer var3, int var4);

    public static void glUniformMatrix4ARB(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        ARBShaderObjects.nglUniformMatrix4fvARB(location, matrices.remaining() >> 4, transpose, matrices, matrices.position());
    }

    private static native void nglUniformMatrix4fvARB(int var0, int var1, boolean var2, FloatBuffer var3, int var4);

    public static void glGetObjectParameterARB(int obj, int pname, FloatBuffer params) {
        BufferChecks.checkDirect(params);
        ARBShaderObjects.nglGetObjectParameterfvARB(obj, pname, params, params.position());
    }

    private static native void nglGetObjectParameterfvARB(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetObjectParameterARB(int obj, int pname, IntBuffer params) {
        BufferChecks.checkDirect(params);
        ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, params, params.position());
    }

    private static native void nglGetObjectParameterivARB(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetInfoLogARB(int obj, IntBuffer length, ByteBuffer infoLog) {
        BufferChecks.checkDirect(infoLog);
        if (length == null) {
            ARBShaderObjects.nglGetInfoLogARB(obj, infoLog.remaining(), null, -1, infoLog, infoLog.position());
        } else {
            BufferChecks.checkBuffer(length, 1);
            ARBShaderObjects.nglGetInfoLogARB(obj, infoLog.remaining(), length, length.position(), infoLog, infoLog.position());
        }
    }

    private static native void nglGetInfoLogARB(int var0, int var1, IntBuffer var2, int var3, ByteBuffer var4, int var5);

    public static void glGetAttachedObjectsARB(int containerObj, IntBuffer count, IntBuffer obj) {
        if (count == null) {
            ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, obj.remaining(), null, -1, obj, obj.position());
        } else {
            if (count.remaining() == 0) {
                throw new BufferOverflowException();
            }
            ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, obj.remaining(), count, count.position(), obj, obj.position());
        }
    }

    private static native void nglGetAttachedObjectsARB(int var0, int var1, IntBuffer var2, int var3, IntBuffer var4, int var5);

    public static int glGetUniformLocationARB(int programObj, ByteBuffer name) {
        return ARBShaderObjects.nglGetUniformLocationARB(programObj, name, name.position());
    }

    private static native int nglGetUniformLocationARB(int var0, ByteBuffer var1, int var2);

    public static void glGetActiveUniformARB(int programObj, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (size.remaining() == 0) {
            throw new BufferOverflowException();
        }
        if (type.remaining() == 0) {
            throw new BufferOverflowException();
        }
        if (length == null) {
            ARBShaderObjects.nglGetActiveUniformARB(programObj, index, name.remaining(), null, -1, size, size.position(), type, type.position(), name, name.position());
        } else {
            if (length.remaining() == 0) {
                throw new BufferOverflowException();
            }
            ARBShaderObjects.nglGetActiveUniformARB(programObj, index, name.remaining(), length, length.position(), size, size.position(), type, type.position(), name, name.position());
        }
    }

    private static native void nglGetActiveUniformARB(int var0, int var1, int var2, IntBuffer var3, int var4, IntBuffer var5, int var6, IntBuffer var7, int var8, ByteBuffer var9, int var10);

    public static void glGetUniformARB(int programObj, int location, FloatBuffer params) {
        ARBShaderObjects.nglGetUniformfvARB(programObj, location, params, params.position());
    }

    private static native void nglGetUniformfvARB(int var0, int var1, FloatBuffer var2, int var3);

    public static void glGetUniformARB(int programObj, int location, IntBuffer params) {
        ARBShaderObjects.nglGetUniformivARB(programObj, location, params, params.position());
    }

    private static native void nglGetUniformivARB(int var0, int var1, IntBuffer var2, int var3);

    public static void glGetShaderSourceARB(int obj, IntBuffer length, ByteBuffer source) {
        if (length == null) {
            ARBShaderObjects.nglGetShaderSourceARB(obj, source.remaining(), null, -1, source, source.position());
        } else {
            ARBShaderObjects.nglGetShaderSourceARB(obj, source.remaining(), length, length.position(), source, source.position());
        }
    }

    private static native void nglGetShaderSourceARB(int var0, int var1, IntBuffer var2, int var3, ByteBuffer var4, int var5);
}

