/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.lwjgl.SysImplementation;
import org.lwjgl.input.Mouse;

public final class Sys {
    public static final String VERSION = "0.94";
    private static final String LIBRARY_NAME = "lwjgl";
    private static final String PLATFORM;
    public static final boolean DEBUG;
    private static final SysImplementation implementation;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        DEBUG = Boolean.getBoolean("org.lwjgl.Sys.debug");
        System.loadLibrary(LIBRARY_NAME);
        implementation = Sys.createImplementation();
        String native_version = implementation.getNativeLibraryVersion();
        if (!native_version.equals(VERSION)) {
            throw new LinkageError("Version mismatch: jar version is '0.94', native libary version is '" + native_version + "'");
        }
        implementation.setDebug(DEBUG);
        PLATFORM = System.getProperty("org.lwjgl.Sys.platform", "org.lwjgl.SwingAdapter");
    }

    /*
     * WARNING - void declaration
     */
    private static SysImplementation createImplementation() {
        String class_name;
        String os_name = System.getProperty("os.name");
        if (os_name.startsWith("Linux")) {
            class_name = "org.lwjgl.LinuxSysImplementation";
        } else if (os_name.startsWith("Windows")) {
            class_name = "org.lwjgl.Win32SysImplementation";
        } else if (os_name.startsWith("Mac")) {
            class_name = "org.lwjgl.MacOSXSysImplementation";
        } else {
            throw new IllegalStateException("The platform " + os_name + " is not supported");
        }
        try {
            void var0_1;
            Class<?> impl_class = Class.forName((String)var0_1);
            return (SysImplementation)impl_class.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Sys() {
    }

    public static void log(String msg) {
        if (DEBUG) {
            System.err.println(msg);
        }
    }

    public static void initialize() {
    }

    public static long getTimerResolution() {
        return implementation.getTimerResolution();
    }

    public static long getTime() {
        return implementation.getTime() & Long.MAX_VALUE;
    }

    public static void alert(String title, String message) {
        boolean grabbed = Mouse.isGrabbed();
        if (grabbed) {
            Mouse.setGrabbed(false);
        }
        if (title == null) {
            title = "";
        }
        if (message == null) {
            message = "";
        }
        String osName = System.getProperty("os.name");
        implementation.alert(title, message);
        if (grabbed) {
            Mouse.setGrabbed(true);
        }
    }

    public static boolean openURL(String url) {
        try {
            Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method lookupMethod = serviceManagerClass.getMethod("lookup", classArray);
            Object basicService = lookupMethod.invoke(serviceManagerClass, "javax.jnlp.BasicService");
            Class<?> basicServiceClass = Class.forName("javax.jnlp.BasicService");
            Class[] classArray2 = new Class[1];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.net.URL");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz2;
            Method showDocumentMethod = basicServiceClass.getMethod("showDocument", classArray2);
            try {
                Boolean ret = (Boolean)showDocumentMethod.invoke(basicService, new URL(url));
                return ret;
            }
            catch (MalformedURLException e) {
                e.printStackTrace(System.err);
                return false;
            }
        }
        catch (Exception ue) {
            return implementation.openURL(url);
        }
    }

    public static String getClipboard() {
        return implementation.getClipboard();
    }
}

