/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class BufferUtils {
    public static ByteBuffer createByteBuffer(int size) {
        return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
    }

    public static ShortBuffer createShortBuffer(int size) {
        return BufferUtils.createByteBuffer(size << 1).asShortBuffer();
    }

    public static IntBuffer createIntBuffer(int size) {
        return BufferUtils.createByteBuffer(size << 2).asIntBuffer();
    }

    public static FloatBuffer createFloatBuffer(int size) {
        return BufferUtils.createByteBuffer(size << 2).asFloatBuffer();
    }

    public static DoubleBuffer createDoubleBuffer(int size) {
        return BufferUtils.createByteBuffer(size << 3).asDoubleBuffer();
    }

    public static int getOffset(Buffer buffer) {
        if (buffer instanceof FloatBuffer || buffer instanceof IntBuffer) {
            return buffer.position() << 2;
        }
        if (buffer instanceof ShortBuffer || buffer instanceof CharBuffer) {
            return buffer.position() << 1;
        }
        if (buffer instanceof DoubleBuffer || buffer instanceof LongBuffer) {
            return buffer.position() << 3;
        }
        return buffer.position();
    }
}

