-- Main Menu Screen
DebugOut("scripts/zenmenu2.lua")

require("scripts/style.lua")

StartLevel = 1;

kButtonY = 200;
kButtonSpacing = 60;

ZenMenuNewButton=
{
	"controls/menu-btn-zen-new-up",
	"controls/menu-btn-zen-new-down",
	"controls/menu-btn-zen-new-over"
};

ZenMenuContButton=
{
	"controls/menu-btn-zen-cont-up",
	"controls/menu-btn-zen-cont-down",
	"controls/menu-btn-zen-cont-over"
};

SetZenMode(true);

local currentZenLevel = GetCurrentZenLevel();
local displayContinue = (currentZenLevel ~= 0);

local backgroundImage = "backgrounds/mainmenu";
local continueInvisibleOffset = 3000;

if displayContinue then
	continueInvisibleOffset = 0;
end

MakeDialog
{
	Bitmap	-- Background bitmap
	{
		image=backgroundImage,
		name="backgroundImage",
		SetStyle(ButtonStyle),

		ZenMenuWindow
		{
			x=0,y=0,w=kMax,h=kMax,

			Bitmap
			{
				x = 292, y = 260,
				--scale = 1.15,
				image = "backgrounds/zenmenu-1",
			},
			
			Button
			{
				x=403 - 70, y=156 - 36,-- x=327,y=96,
				graphics = ZenMenuNewButton,--MainMenuButtonGraphics,
				command=
					function()
						CurrentLevel = StartLevel;
						return SwapToModal("scripts/zen.lua");
					end
			},

			Button
			{
				x=403 - 70+continueInvisibleOffset ,y=448 - 108,--x=191+continueInvisibleOffset,y=230,
				graphics = ZenMenuContButton,--MainMenuButtonGraphics,
				command=
					function()
						CurrentLevel = GetCurrentZenLevel();
						return SwapToModal("scripts/zen.lua");
					end
			},

			--[[Button
			{
				x=458,y=230,
				graphics = MainMenuButtonGraphics,
				command=
					function()
						return SwapToModal("scripts/zenmenu.lua");
					end
			},--]]
			
			Button
			{
				font = LableFontMetamapWhite,
				x=663,y=549;
				name="MainMenu",
				Label "MainMenu",
				flags = kHAlignCenter + kVAlignCenter,
				--graphics = MetamapMMGraphics,
				close=true;
			},

			--[[Bitmap
			{
				x=330,y=140;
				image="buttons/zen-new";
			};

			Bitmap
			{
				x=194+continueInvisibleOffset ,y=270;
				image="buttons/zen-continue-up";
			};

			Bitmap
			{
				x=462,y=270;
				image="buttons/zen-return-up";
			};--]]

		}
	}
}

