-- Global style definitions

proportionalFont = "fonts/palai.mvec";
standardFont = "fonts/palabi.mvec";
arialFont = "fonts/palabi.mvec";
arialblackFont = "fonts/palabi.mvec";
palaFont = "fonts/pala.mvec";
palaiFont = "fonts/palai.mvec";
palabFont = "fonts/palab.mvec";
palabiFont = "fonts/palabi.mvec";


NormalButtonGraphics=
{
	"controls/normal_btn_up",
	"controls/normal_btn_down",
	"controls/normal_btn_over"
};

MainMenuButtonGraphics=
{
	"controls/menu_btn_up",
	"controls/menu_btn_down",
	"controls/menu_btn_over"
};

MainMenuSmallButtonGraphics=
{
	"controls/menu_s_btn_up",
	"controls/menu_s_btn_down",
	"controls/menu_s_btn_over"
};

StandardButtonGraphics=
{
	"buttons/button_down",
	"buttons/button_up",
	"buttons/button_up"
};

MainMenuSelectPlayerGraphics=
{
	"controls/changename_btn_up",
	"controls/changename_btn_down",
	"controls/changename_btn_over"
};

CheckboxButtonGraphics = {
	"controls/off_btn",
	"controls/on_btn",
	"controls/off_btn",
	"controls/on_btn"
};

TitleFontBlack =
{
	proportionalFont,
	35,
	Color(0,0,20,255)
};

LabelFontBlack = 
{
	palaiFont,
	25,
	Color(0,0,20,255)
};


PropFontBlack = 
{
	proportionalFont,
	20,
	Color(255,255,255,255)
};


kDefaultButtonSound="music/button_click.ogg";

DefaultStyle = 
{
	font=PropFontBlack,
	flags=kHAlignCenter + kVAlignCenter,
	sound = kDefaultButtonSound,
};

SetDefaultStyle(DefaultStyle);

ButtonStyle =
{
	parent=DefaultStyle,
	type = kPush,
	graphics = NormalButtonGraphics,
	x=kCenter, 
	flags=kHAlignCenter + kVAlignCenter
};

MainMenuButtonStyle =
{
	parent=DefaultStyle,
	type = kPush,
	graphics = MainMenuButtonGraphics,
	x=kCenter, 
	flags=kHAlignCenter + kVAlignCenter
};


BottomRowButton =
{
	parent=ButtonStyle,
	y=kMax-110
};

BottomRowRightButton = 
{
	parent=DefaultStyle,
	type = kPush,
	graphics = NormalButtonGraphics,
	y=kMax-70,
	x=600,
	flags=kHAlignCenter + kVAlignCenter
};

kIllegalNameChars = "!@#$%^&*()><\\\"\'[]{}|?/+=~`.,;:-";

function Label( label, font )
	local x=0 local y=0;
	local w=kMax - 4
	local h=kMax - 4
	return Group( 
	{ 
		SelectLayer(0), 
		Text{ x=x, y=y, w=w, h=h, label=label , font=font}, 
		SelectLayer(1), 
		Text{ x=x+2, y=y+2, w=w, h=h, label=label, font=font }, 
		SelectLayer(2), 
		Text{ x=x, y=y, w=w, h=h, label=label, font=font }, 
	} 
	) 
end

function LabelEx( label, style )
	local x=-2; local y=-2;
	local w=kMax - 4
	local h=kMax - 4
	return Group( 
	{ 
		SetStyle(stye),
		SelectLayer(0), 
		Text{ x=x, y=y, w=w, h=h, label=label }, 
		SelectLayer(1), 
		Text{ x=x+2, y=y+2, w=w, h=h, label=label}, 
		SelectLayer(2), 
		Text{ x=x, y=y, w=w, h=h, label=label}, 
	} 
	) 
end


