-- Pause Menu

DebugOut("scripts/pause.lua")

require("scripts/style.lua")

PauseButtonGraphics=
{
	"controls/menu_btn_up",
	"controls/menu_btn_down",
	"controls/menu_btn_over"
};

PropFontWhite = 
{
	palaiFont,
	22,
	Color(255,255,255,255)
};

LabelFontPause_Level = 
{
	palaFont,
	24,
	Color(0,0,0,255)
};



MakeDialog
{
	Bitmap	-- Background bitmap
	{
		image="backgrounds/pause-table",
		x=kCenter,
		y=kCenter,

		x=0,y=0,w=kMax,h=kMax,
		
		PauseWindow
		{
			x=0,y=0,w=kMax,h=kMax,

			Text
			{
				font = LabelFontPause_Level,
				label = "",
				x=300, y=160,
				w=192, h=40,
				name = "LevelText",
				flags = kHAlignCenter + kVAlignCenter
			};
			
			SetStyle(BottomRowButton);
			
			Button
			{
				Label("ReturnGameLabel", PropFontWhite),
				name="returnGame",
				x=350,
				y=200,--kMax-200;
				graphics=PauseButtonGraphics,
				close = true,
				command=
					function()
						ResumeGame();
					end
			},

			Button
			{
				Label("Options",PropFontWhite),
				x=245,--190,
				y=278,--kMax-200;
				graphics=PauseButtonGraphics;
				command=
					function()
						return DoModal("scripts/options.lua");
					end
			},
			
			Button
			{
				Label("Help",PropFontWhite),
				x=455,--190,
				y=278,--kMax-200;
				graphics=PauseButtonGraphics;
				command=
					function()
						if(IsZenMode()) then
							return DoModal("scripts/zenhelp.lua");
						else
							return DoModal("scripts/help.lua");
						end
					end
			},
			
			Button
			{
				Label("Reset",PropFontWhite);
				x=290,
				y=kMax-194;
				graphics=PauseButtonGraphics;
				close = true,
				command=
					function()
						ResumeGame();
						ResetGame();
					end
			},
			
			Button
			{
				Label("Quit", PropFontWhite),
				x=419,
				y=kMax-194;
				graphics=PauseButtonGraphics;
				close = true,
				sound = nil,
				command=
					function()
						if (not IsGameEndScreen()) then
							PlayClickSound();
							PlayMainmenuBackground();
							ResumeGame();
							PopModal();
							PopModal();
							QuitFromGame();
						else
							GameFinish();
						end
					end
			},
			
			SetStyle(BottomRowRightButton);
			
			Button
			{
				Label("PauseLabel",PropFontWhite),
				name="pauseButton",	
				graphics=PauseButtonGraphics,
				x=692,
				y=500,
				command = function()
				end
			}

		}
	}
}

SetCurrentLevelForPause(CurrentLevel, CurrentWorld);
