-- Option Menu

DebugOut("scripts/options.lua")

require("scripts/style.lua")

SliderStyle = 
{
	parent=DefaultStyle,
	railtop = "slider/sliderrailtop",
	railmid = "slider/sliderrailmid",
	railbot = "slider/sliderrailbot",
	sliderimage = "slider/sliderknob",
	sliderrollimage = "slider/sliderknobover",

	yoffset = 1, -- scoot the slider down by one pixel to center it.
};

LabelFontOptionWhite = 
{
	palaiFont,
	22,
	Color(255,255,255,255)
};


MakeDialog
{
	Bitmap	-- Background bitmap
	{
		image="backgrounds/options-table",
		x=kCenter,
		y=kCenter,
	
		OptionWindow
		{
			x=0,y=0,w=kMax,h=kMax,
			--[[Text
			{
				font = TitleFontBlack,
				label = "Options",
				x=159, y=75,
				w=192, h=41,
				flags = kHAlignCenter + kVAlignCenter
			};--]]

			SetStyle(SliderStyle),
			
			
			Slider
			{
				name="musiclevelslider",
				x = 130,
				y = 160,
				w = 270,
				h = 60,
			};

			Slider
			{
				name="sfxlevelslider",
				x = 130,
				y = 220,
				w = 270,
				h = 60,
			};

			Text
			{
				font = LabelFontBlack,
				x=2, y=132,
				w=120,--kMax,
				h=100,
				flags = kHAlignRight + kVAlignCenter,
				label="Music",
			},

			Text
			{
				font = LabelFontBlack,
				x=2, y=192,
				w=120,--kMax,
				h=100,
				flags = kHAlignRight + kVAlignCenter,
				label="SoundFX",
			},

			Text
			{
				font = LabelFontBlack,
				x=35, y=280,
				w=160,
				h=100,
				flags = kHAlignRight + kVAlignCenter,
				label="Fullscreen",

				Button
				{
					name="fullscreen_checkbox",
					graphics = CheckboxButtonGraphics,
					type = kToggle,
					x=0, y=30,
					w=kMax, h=kMax,
					flags = kHAlignLeft + kVAlignCenter,
					
					command=
					function()
						ToggleFullScreen();
					end
				};
			},

			Text
			{
				font = LabelFontBlack,
				x=210, y=280,
				w=142,
				h=100,
				flags = kHAlignRight + kVAlignCenter,
				label="MuteAllSound",

				Button
				{
					name="muteallsound_checkbox",
					graphics = CheckboxButtonGraphics,
					type = kToggle,
					x=0, y=30,
					w=kMax, h=kMax,
					flags = kHAlignLeft + kVAlignCenter,
					
					command=
					function()
						ToggleMuteAllSound();
					end
				};
			},
		},

		SetStyle(BottomRowButton);
		--[[Button
		{
			font = LabelFontOptionWhite,
			Label "Help",
			x=35,
			command=
				function()
					return DoModal("scripts/help.lua");
				end
		},--]]
		Button
		{
			font = LabelFontOptionWhite,
			Label "CreditLabel",
			x=70,
			command=
				function()
					return DoModal("scripts/credit.lua");
				end
		},
		Button
		{
			font = LabelFontOptionWhite,
			Label "OKLabel",
			x=220,
			close = true,
			command=
				function()
					SaveVolumes();
				end
		},
	}
}

