-- High-Scores Menu

DebugOut("scripts/metamap.lua")

require("scripts/style.lua")

CustomCreator("MetamapWindow");

SetZenMode(false);
SetTutorialMode(false);
SetNextToTutorial(false);

MetamapPlayGraphics=
{
	"buttons/buttonup",
	"buttons/buttondown",
	"buttons/buttonrollover"
};

MetamapMMGraphics=
{
	"buttons/buttonup",
	"buttons/buttondown",
	"buttons/buttonrollover"
};

LableFontMetamapBlack_Level=
{
	palaFont,
	24,
	Color(0,0,0,255)
};

LableFontMetamapBlack_Score=
{
	palaiFont,
	18,
	Color(0,0,0,255)
};

LableFontMetamapWhite=
{
	palaiFont,
	20,
	Color(255,255,255,255)
};

MakeDialog
{
	Bitmap	-- Background bitmap
	{
		SetStyle(BottomRowRightButton);

		Button
		{
			name="HiddenUnlockZen",
			command = function()
				DoModal("scripts/unlockzen.lua");
			end
		},

		MetamapWindow
		{
			x=0,y=0,
			w=800,h=600,
			name="metamapWindow"
		},

		Text
		{
			font = LableFontMetamapBlack_Level,
			name = "LevelText",
			x=340, y=140,
			h=48, w=120,
			flags = kHAlignCenter + kVAlignCenter,
			label = ""
		};

		Text
		{
			font = LableFontMetamapBlack_Score,--PropFontBlack,
			name = "BestScores",
			x=340, y=175,
			h=30, w=110,
			flags = kHAlignCenter + kVAlignCenter,
			label = "WelcomeLabel"
		};

		Text
		{
			font = LableFontMetamapBlack_Score,--PropFontBlack,
			name = "JourneyScores",
			x=295, y=195,
			h=30, w=210,
			flags = kHAlignCenter + kVAlignCenter,
			label = "WelcomeLabel"
		};

		Button
		{
			font = LableFontMetamapWhite,
			x=663,y=549;
			name="MainMenu",
			Label "MainMenu",
			flags = kHAlignCenter + kVAlignCenter,
			graphics = MetamapMMGraphics,
			sound = nil,
			close=true;

			command = function()
				-- Because PF SDK has a bug on play sound before SwapToModal call.
				PlayClickSound();
			end
		},

		Button
		{
			font = LableFontMetamapWhite,
			x=344, y=385;
			name="Play",
			Label "Play",
			flags = kHAlignCenter + kVAlignCenter,
			graphics = MetamapPlayGraphics,
			command = function()
				GoToSelectedLevel();
			end
		};

		
	}
}

