-- Main Menu Screen

DebugOut("scripts/mainmenu.lua")

require("scripts/style.lua")

--Adventure mode, Zen mode, 

AdvModeButton=
{
	"controls/menu-btn-journey-up",
	"controls/menu-btn-journey-down",
	"controls/menu-btn-journey-over"
};

ZenModeButton=
{
	"controls/menu-btn-zen-up",
	"controls/menu-btn-zen-down",
	"controls/menu-btn-zen-over"
};

HelpMainButton=
{
	"controls/menu-btn-help-up",
	"controls/menu-btn-help-down",
	"controls/menu-btn-help-over"
};

OptionsMainButton=
{
	"controls/menu-btn-options-up",
	"controls/menu-btn-options-down",
	"controls/menu-btn-options-over"
};

HiscoreMainButton=
{
	"controls/menu-btn-hiscore-up",
	"controls/menu-btn-hiscore-down",
	"controls/menu-btn-hiscore-over"
};

QuitMainButton=
{
	"controls/menu-btn-quit-up",
	"controls/menu-btn-quit-down",
	"controls/menu-btn-quit-over"
};

MoreGamesGraphics=
{
	"buttons/buttonup",
	"buttons/buttondown",
	"buttons/buttonrollover"
};


kButtonY = 200;
kButtonSpacing = 60;

MakeDialog
{
	Bitmap	-- Background bitmap
	{
		image="backgrounds/mainmenu",
		name="backgroundImage",
		SetStyle(MainMenuButtonStyle),

		Button
		{
			name="hiddenCloseButton",
			command= function() 
				DoModal('scripts/loading.lua');
			end
		};

		MainMenuWindow
		{
			x=0,y=0, w=kMax,h=kMax,

			Text
			{
				font = LabelFontBlack,
				name = "welcome",
				x=400-200, y=300-40,
				h=40, w=400,
				flags = kHAlignCenter + kVAlignCenter,
				label = "WelcomeLabel"
			};

			Button
			{
				x=554 - 52,y=232 - 50,
				graphics = OptionsMainButton,--MainMenuSmallButtonGraphics,
				command=
					function()
						return DoModal("scripts/options.lua");
					end
			},
			Button
			{
				x=252 - 52,y=365 - 50,
				graphics = HelpMainButton,--MainMenuSmallButtonGraphics,
				command=
					function()
						return DoModal("scripts/helpmenu.lua");
					end
			},
			Button
			{
				x=252 - 52,y= 232 - 50,
				graphics = HiscoreMainButton,--MainMenuSmallButtonGraphics,
				command=
					function()
						return DoModal("scripts/highscores.lua");
					end
			},	

			Bitmap
			{
				image="controls/menu-btn-zen-lock",
				name="lockZenImage",
				x=403 - 74 ,y=448 - 72,
			},

			Button
			{
				x=403 - 74 ,y=448 - 72,
				graphics = ZenModeButton,--MainMenuButtonGraphics,
				name="zenButton",
				command=
					function()
						if( GetNumUsers() == 0 ) then
							DoModal("scripts/ChoosePlayer.lua");
						end

						if( GetNumUsers() > 0 ) then
							TurnOffDrawing();
							SwapToModal("scripts/zenmenu2.lua");
						end
					end
			},
			Button
			{
				x=403 - 74, y=156 - 72,
				graphics = AdvModeButton,--MainMenuButtonGraphics,
				command= function()
						if( GetNumUsers() == 0 ) then
							DoModal("scripts/ChoosePlayer.lua");
						end

						if( GetNumUsers() > 0 ) then
							return SwapToModal("scripts/metamap.lua");
						end
					end
			},
			Button
			{
				x=554 - 52, y=365 - 50,
				graphics = QuitMainButton,--MainMenuSmallButtonGraphics,
				command=
					function()
						return DoModal("scripts/quit.lua");
					end
			},

			--Bitmap { x=342,y=132; image="buttons/main-advmode"; };
			--Bitmap { x=193,y=203; image="buttons/main-hiscore"; };
			--Bitmap { x=193,y=338; image="buttons/main-help"; };
			--Bitmap { x=497,y=203; image="buttons/main-option"; };
			--Bitmap { x=496,y=338; image="buttons/main-quit"; };
			--Bitmap { x=342,y=420; image="buttons/main-zenmode"; };

			SetStyle(BottomRowButton);

			Button
			{
				--label = "ChangePlayerLabel",
				--flags = kHAlignLeft + kVAlignCenter,
				y=300,
				graphics = MainMenuSelectPlayerGraphics,
				command = function() 
						DoModal("scripts/ChoosePlayer.lua");
					  end
			};


			Button
			{
				font = LableFontMetamapWhite,
				x=683,y=549;
				name="MoreGames",
				Label "MoreGames",
				flags = kHAlignCenter + kVAlignCenter,
				graphics = MoreGamesGraphics,

				command = function()
					DoModal("xsell/xsell.lua");
				end
			},
			

		}
	}
};

