-- Lose (Zen)

DebugOut("scripts/losezen.lua")

require("scripts/style.lua")

LabelFont_ScoreTitle = 
{
	palabFont,
	20,
	Color(0,0,0,255)
};

ScoreFont = 
{
	palaiFont,
	22,
	Color(82,52,13,255)
};

TipsTitleFont = 
{
	palabiFont,
	26,
	Color(82,52,13,255)
};

TipsFont = 
{
	palaiFont,
	22,
	Color(82,52,13,255)
};

LabelFont_LoseButton = 
{
	palaiFont,
	20,
	Color(255,255,255,255)
};

local bottomButtonY = 380;
local textBottomY = 170;

MakeDialog
{
	-- Fade 50% black
	Bitmap
	{
		x=0, y=0, w=800, h=600,
		scale = 2,
		image = "backgrounds/black-2",
	};
	
	Bitmap	-- Background bitmap
	{
		x=190,y=30,
		image="backgrounds/lose",

		SetStyle(ButtonStyle);
		EndLevelTableWindow
		{
			x=0, y=0,
			w=kMax, h=kMax,

			Text
			{
				label = "CurrentLevel",
				name = "CurrentLevelTitle",
				x=40, y=textBottomY-30, w = 150, h=28,
				font = LabelFont_ScoreTitle,
				flags=kHAlignRight + kVAlignCenter;
			};
			
			Text
			{
				label="LevelScore",
				name="CurrentLevel",
				x=70, y=textBottomY, w = 120, h=24,
				font = ScoreFont;
				flags=kHAlignRight + kVAlignCenter;
			};
			
			Text
			{
				label = "LoseTotalScore",
				name = "LevelScoreTitle",
				x=220, y=textBottomY-30, w = 150, h=28,
				font = LabelFont_ScoreTitle,
				flags=kHAlignRight + kVAlignCenter;
			};
			
			Text
			{
				label="TotalScore",
				name="TotalScore",
				x=250, y=textBottomY, w = 120, h=24,
				font = ScoreFont;
				flags=kHAlignRight + kVAlignCenter;
			};

			Text
			{
				label = "LoseGameTip",
				name = "GameTip",
				x=60, y=220, w = 320, h=30,
				font = TipsTitleFont,
				flags=kHAlignCenter + kVAlignCenter;
			};
			
			Text
			{
				label="GameTips",
				name="GameTips",
				x=60, y=250, w = 320, h=200,
				font = TipsFont;
				flags=kHAlignLeft + kVAlignTop
			};

		},

		SetStyle(ButtonStyle);

		Button
		{
			font = LabelFont_LoseButton,
			x=80, y=bottomButtonY,
			Label "Quit",
			graphics = MainMenuButtonGraphics,
			close=true,
			command=
				function()
					PopModal();
					QuitFromGame();
				end
		};
		
		--[[Button
		{
			x=130, y=bottomButtonY,
			label="ViewHighScores",
			command=
				function()
					return DoModal("scripts/highscores.lua");
				end
		};

		Button
		{
			x=230, y=bottomButtonY,
			label="BackMain",
			command=
				function()
					PopModal();
					SwapToModal("scripts/zenmenu.lua");
				end
		};--]]

		Button
		{
			font = LabelFont_LoseButton,
			x=230, y=bottomButtonY,
			Label "Reset",
			graphics = MainMenuButtonGraphics,
			close = true,
			command=
				function()
					ResetGame();
				end
		}
	}
}

