require( "scripts/style.lua" )

HeaderFont = {
  standardFont,
  32,
  BlackColor
};

TableInfoFont = {
  standardFont,
  30,
 BlackColor
};

ErrorFont = {
  standardFont,
  24,
 BlackColor
};

AccountFont = {
  standardFont,
  24,
  BlackColor
};

ScoreFont = {
  standardFont,
  14,
  BlackColor
};
SmallerFont = {
	proportionalFont,
	17,
	Color(255,255,255,255)
};

kPlayerNameY = 150;
kScoreY = 200;
kYourPFAccountY = 250;
kAccountNameY = 275;
kPasswordY = 310;
kRememberY = 355;


MakeDialog
{
	
	Bitmap
	{ 
		image="backgrounds/longdialog",	
		x=kCenter,
		y=kCenter,

		Text
		{
			font = HeaderFont,
			name = "header",
			x=0,y=40,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "submitglobal"
		};
		
		Text
		{
			font = HeaderFont,
			name = "headerMedal",
			x=0,y=40,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "submitmedals"
		};
		
		Text
		{
			font = AccountFont,
			name = "playertext",
			x=0,y=kPlayerNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "playerlabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "yourscore",
			x=0,y=kScoreY,w=142,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "scorelabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "eligiblescore",
			x=205,y=kScoreY,w=100,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = "12345"
		};
		
		Text
		{
			font = ScoreFont,
			name = "yourpfaccount",
			x=145,y=kYourPFAccountY,w=150,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = "yourpfaccount"
		};
		
		Text
		{
			font = AccountFont,
			name = "nametext",
			x=0,y=kAccountNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "namelabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "passtext",
			x=0,y=kPasswordY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "passwordlabel"
		};
		
		Text
		{
			font = TableInfoFont,
			name = "submitconnect",
			x=0,y=0,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "connectingtoserver"
		};
		
		Text
		{
			font = ErrorFont,
			name = "submiterror",
			x=50,y=0,w=300,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "Error Message"
		};


		Bitmap
		{
			name="nameeditbox",
			image="backgrounds/textfield.png",
			x=155,
			y=kPlayerNameY,
			
			TextEdit
			{
				font = AccountFont,
				name = "nameedit",
				x=12,y=3,w=kMax,h=kMax,
				length=12,
				ignore = kIllegalNameChars
				
			};
		};
		
		Bitmap
		{
			name="accounteditbox",
			image="backgrounds/textfield.png",
			x=155,
			y=kAccountNameY,
			
			TextEdit
			{
				font = AccountFont,
				name = "accountedit",
				x=12,y=3,w=kMax,h=kMax,
				length=26,
				ignore = kIllegalNameChars
				
			};
		};
		
		Bitmap
		{
			name="passeditbox",
			image="backgrounds/textfield.png",
			x=155,
			y=kPasswordY,
			
			TextEdit
			{
				font = AccountFont,
				name = "passedit",
				x=12,y=3,w=kMax,h=kMax,
				password = true,
				length=26
				
			};
		};
		
		
		Button
		{
			font = StandardButtonFont,
			graphics = CheckboxButtonGraphics,
			name="remember",
			type = kToggle,
			x=75,
			y=kRememberY,
			w=250,
			scale=0.5,
			rollover = "",
			drop = false,
			Text
			{
				font = StandardButtonFont,
				name = "rememberlabel",
				x=30,
				y=5,
				w=250,
				h=25,
				flags = kHAlignLeft + kVAlignTop,
				label="rememberpfaccount",
			};
		};
		
		Button
		{
			x=20,
			y=400,
			graphics = StandardButtonGraphics,
			name="submittoserver",
			Label( "submitscores", SmallerFont),
			flags=kHAlignCenter + kVAlignCenter,
			type = kPush
		},
	
		Button
		{
			x=140,
			y=400,
			graphics = StandardButtonGraphics,
			name="medaltoserver",
			Label ("submitmedals", SmallerFont),
			flags=kHAlignCenter + kVAlignCenter,
			type = kPush
		},
		
		Button
		{
			x=257,
			y=400,
			graphics = StandardButtonGraphics,
			name="submitcancel",
			Label ("CancelLabel", SmallerFont),
			flags=kHAlignCenter + kVAlignCenter,
			type = kPush
		};
		
		Button
		{
			x=150,
			y=400,
			graphics = StandardButtonGraphics,
			name="submiterrorok",
			Label ("OKLabel", SmallerFont),
			flags=kHAlignCenter + kVAlignCenter,
			type = kPush
		};
	}
}
