require( "scripts/style.lua" );

BlackColor = Color(0,0,0,255);

StandardButtonGraphics = {
	"buttons/buttonup",
	"buttons/buttondown",
	"buttons/buttonrollover"
};

StandardButtonFont = {
  palaiFont,
  18,
  BlackColor
};

HeaderFont = {
  palaiFont,
  30,
  BlackColor
};


GameModeFont = {
  palabiFont,
  30,
  Color(94,32,1,255)
};

TableInfoFont = {
  palaiFont,
  30,
  BlackColor
};

EligibleFont = {
  palaiFont,
  18,
  BlackColor
};

EligibleAsteriskFont = {
  palaiFont,
  18,
  BlackColor
};


ConnectingToServerFont = {
	palaiFont,
	18,
	BlackColor
};

TableHeaderFont = {
  palaFont,
  24,
  BlackColor
};

ScoreInfoFont = {
  palaiFont,
  18,
  BlackColor
};


ScoreFont = {
  palaiFont,
  24,
  BlackColor
};

RankFont = {
  palaiFont,
  26,
  BlackColor
};

ChangeViewFont = {
  palaiFont,
  18,
  Color(255,255,255,255)
};

UpButtonGraphics = {
	"buttons/arrowup_up.png",
	"buttons/arrowup_down.png",
	"buttons/arrowup_over.png"
};

DownButtonGraphics = {
	"buttons/arrowdown_up.png",
	"buttons/arrowdown_down.png",
	"buttons/arrowdown_over.png"
};

LeftButtonGraphics = {
	"buttons/arrowleft_up.png",
	"buttons/arrowleft_down.png",
	"buttons/arrowleft_over.png"
};

RightButtonGraphics = {
	"buttons/arrowright_up.png",
	"buttons/arrowright_down.png",
	"buttons/arrowright_over.png"
};

BlueLeftButtonGraphics = {
	"buttons/bluearrowleft_up.png",
	"buttons/bluearrowleft_down.png",
	"buttons/bluearrowleft_over.png"
};

BlueRightButtonGraphics = {
	"buttons/bluearrowright_up.png",
	"buttons/bluearrowright_down.png",
	"buttons/bluearrowright_over.png"
};

ChangeViewButtonGraphics = {
	"buttons/long_button_up.png",
	"buttons/long_button_down.png",
	"buttons/long_button_over.png"
};


kScoreRowSpace = 27;
kRowY = 80;
kNumberX = 35;
kNameX = 65;
kScoreX = 335;
kP1X = kNumberX + 13;

kListX = 10;

MakeDialog
{
	
	Bitmap
	{ 
		image="backgrounds/highscores",	
		name="hiscorescreen",
		
		HiscoreWindow
		{
			x=0,y=0,h=kMax,w=kMax,
			
			--[[Text
			{
				font = HeaderFont,
				name = "header",
				x=0,y=20,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "highscoreheader"
			};--]]
			
			Text
			{
				font = GameModeFont,
				name = "gamemode",
				x=0,y=105,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "GAMEMODE"
			};
			
			Bitmap
			{
				x = 30,
				y = 150,
				w = 364,
				h = 421,
				image="hiscore/global-hs-bb_large.png",	
				name="leftpanel",
				
				Text
				{
					font = TableHeaderFont,
					name = "local",
					x=0,y=20,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "localhighscores"
				};
				
				
				Text
				{
					font = TableHeaderFont,
					name = "global",
					x=0,y=20,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscores"
				};
				
				Text
				{
					font = TableHeaderFont,
					name = "topplayers",
					x=0,y=20,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "topplayers"
				};
				
				Text
				{
					font = ScoreFont,
					name = "1",
					x=kListX,y=kRowY,w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "1."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_1",
					x=kP1X,y=kRowY
				};
				
				Text
				{
					font = ScoreFont,
					name = "name1",
					x=kNameX,y=kRowY,w=kMax,h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreFont,
					name = "score1",
					x=0,y=kRowY,w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "2",
					x=kListX,y=kRowY+(1*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "2."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_2",
					x=kP1X,y=kRowY+(1*kScoreRowSpace)
				};
				
				
				Text
				{
					font = ScoreFont,
					name = "name2",
					x=kNameX,y=kRowY+(1*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreFont,
					name = "score2",
					x=0,y=kRowY+(1*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "3",
					x=kListX,y=kRowY+(2*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "3."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_3",
					x=kP1X,y=kRowY+(2*kScoreRowSpace)
				};
				
				Text
				{
					font = ScoreFont,
					name = "name3",
					x=kNameX,y=kRowY+(2*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreFont,
					name = "score3",
					x=0,y=kRowY+(2*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "4",
					x=kListX,y=kRowY+(3*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "4."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_4",
					x=kP1X,y=kRowY+(3*kScoreRowSpace)
				};
				
				Text
				{
					font = ScoreFont,
					name = "name4",
					x=kNameX,y=kRowY+(3*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreFont,
					name = "score4",
					x=0,y=kRowY+(3*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "5",
					x=kListX,y=kRowY+(4*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "5."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_5",
					x=kP1X,y=kRowY+(4*kScoreRowSpace)
				};
				
				Text
				{
					font = ScoreFont,
					name = "name5",
					x=kNameX,y=kRowY+(4*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreFont,
					name = "score5",
					x=0,y=kRowY+(4*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "6",
					x=kListX,y=kRowY+(5*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "6."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_6",
					x=kP1X,y=kRowY+(5*kScoreRowSpace)
				};
				
				Text
				{
					font = ScoreFont,
					name = "name6",
					x=kNameX,y=kRowY+(5*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreFont,
					name = "score6",
					x=0,y=kRowY+(5*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "7",
					x=kListX,y=kRowY+(6*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "7."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_7",
					x=kP1X,y=kRowY+(6*kScoreRowSpace)
				};
				
				Text
				{
					font = ScoreFont,
					name = "name7",
					x=kNameX,y=kRowY+(6*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreFont,
					name = "score7",
					x=0,y=kRowY+(6*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "8",
					x=kListX,y=kRowY+(7*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "8."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_8",
					x=kP1X,y=kRowY+(7*kScoreRowSpace)
				};
				
				Text
				{
					font = ScoreFont,
					name = "name8",
					x=kNameX,y=kRowY+(7*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreFont,
					name = "score8",
					x=0,y=kRowY+(7*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "9",
					x=kListX,y=kRowY+(8*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "9."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_9",
					x=kP1X,y=kRowY+(8*kScoreRowSpace)
				};
				
				Text
				{
					font = ScoreFont,
					name = "name9",
					x=kNameX,y=kRowY+(8*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreFont,
					name = "score9",
					x=0,y=kRowY+(8*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
				Text
				{
					font = ScoreFont,
					name = "10",
					x=kListX,y=kRowY+(9*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "10."
				};
				
				Bitmap
				{
					image = "hiscore/p1icon.png",
					name = "p1_10",
					x=kP1X,y=kRowY+(9*kScoreRowSpace)
				};
				
				Text
				{
					font = ScoreFont,
					name = "name10",
					x=kNameX,y=kRowY+(9*kScoreRowSpace),w=kMax,h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label = "name"
				};
				
				Text
				{
					font = ScoreFont,
					name = "score10",
					x=0,y=kRowY+(9*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};
				
			};
			
			-- Global High Scores (Right Panel)
			Bitmap
			{
				x = 435,
				y = 150,
				w = 364,
				h = 421,
				image="hiscore/global-hs-bb_small.png",	
				name="rightpanelsmall",
				
				-- Global High Score Info Text (Right Panel)
				Text
				{
					font = ScoreInfoFont,
					name = "yourrankglobalinfo",
					x=15,y=55,w=kMax-70,h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label = "globalhighscoreinfo"
				};
				
				Text
				{
					font = RankFont,
					name = "yourrank",
					x=15,y=15,w=kMax-70,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "yourrank"
				};
				
				Text
				{
					font = RankFont,
					name = "congratulations",
					x=15,y=50,w=kMax-70,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "congratshighscore"
				};
	
				Text
				{
					font = RankFont,
					name = "congratulationsmedal",
					x=15,y=50,w=kMax-70,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "congratsmedal"
				};
				
				Text
				{
					font = RankFont,
					name = "dnq",
					x=15,y=50,w=kMax-70,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scorednq"
				};
			},
			
			-- Global High Scores (Right Panel)
			Bitmap
			{
				x = 435,
				y = 150,
				w = 364,
				h = 421,
				image="hiscore/local-hs-bb.png",	
				name="rightpanel",
				
				Text
				{
					font = TableHeaderFont,
					name = "globalinfoheader",
					x=0,y=20,w=kMax-55,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "globalhighscores"
				};
				
				Text
				{
					font = ScoreInfoFont,
					name = "info",
					x=15,y=55,w=kMax-70,h=kMax,
					flags = kHAlignLeft + kVAlignTop,
					label = "globalhighscoreinfo"
				};
				
				-- More Info Button
				Button
				{
					x=85,
					y=108,
					font = ChangeViewFont,--StandardButtonFont,
					graphics = StandardButtonGraphics,
					name="moreinfo",
					Label("moreinfo", ChangeViewFont),
					type = kPush,
					flags = kHAlignCenter + kVAlignCenter,
					command =
						function()
							DoModal("scripts/hiscoreinfo.lua");
						end
					
				};
				
				-- Submit Info Text
				Text
				{
					font = EligibleFont,
					name = "eligible",
					x=15,y=190,w=kMax-70,h=60,
					flags = kHAlignLeft + kVAlignTop,
					label = "eligible"
				};
			
				-- Submit Button
				Button
				{
					x=35,
					y=220,
					font = ChangeViewFont,--StandardButtonFont,
					flags = kHAlignCenter + kVAlignCenter,
					graphics = StandardButtonGraphics,
					name="submitscores",
					Label("submitscores", ChangeViewFont),
					type = kPush
				};

				Button
				{
					x=165,
					y=220,
					font = ChangeViewFont,--StandardButtonFont,
					flags = kHAlignCenter + kVAlignCenter,
					graphics = StandardButtonGraphics,
					name="submitmedals",
					Label("submitmedals", ChangeViewFont),
					type = kPush
				};
			};
			
			Text
			{
				font = EligibleAsteriskFont,
				name = "eligibleasterisk",
				x=450,y=440,w=kMax-70,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "eligibleasterisk",
				padding=0
			};
			
			
			
			Text
			{
				font = ConnectingToServerFont,
				name = "server",
				x=485,y=362,w=258,h=130,
				flags = kHAlignCenter + kVAlignCenter,
				label = "connectingtoserver"
			};
			
			Text
			{
				font = ConnectingToServerFont,
				name = "error",
				x=465,y=262,w=258,h=130,
				flags = kHAlignCenter + kVAlignCenter,
				label = "Server error"
			};
			
			
			
			-- Game Mode Left-Arrow Button
			Button
			{
				font = StandardButtonFont,
				flags = kHAlignCenter + kVAlignCenter,
				graphics = LeftButtonGraphics,
				name="gamemodeleft",
				label="",
				type = kPush,
				x=230,
				y=110,
				scale = 0.8
			};
			
			-- Game Mode Right-Arrow Button
			Button
			{
				font = StandardButtonFont,
				flags = kHAlignCenter + kVAlignCenter,
				graphics = RightButtonGraphics,
				name="gamemoderight",
				label="",
				type = kPush,
				x=510,
				y=110,
				scale = 0.8
			};
			
			-- Global High Score - Text (Category)
			Text
			{
				font = ScoreFont,
				name = "category",
				x=115,y=197,w=201,h=40,
				flags = kHAlignCenter + kVAlignTop,
				label = "Category Name"
			};
			
			-- Global High Score - Left-Arrow Button (Category)
			Button
			{
				font = StandardButtonFont,
				flags = kHAlignCenter + kVAlignCenter,
				graphics = BlueLeftButtonGraphics,
				name="categoryleft",
				label="",
				type = kPush,
				x=100,
				y=200,
				scale = 0.8
			};
			
			-- Global High Score - Right-Arrow Button (Category)
			Button
			{
				font = StandardButtonFont,
				flags = kHAlignCenter + kVAlignCenter,
				graphics = BlueRightButtonGraphics,
				name="categoryright",
				label="",
				type = kPush,
				x=290,
				y=200,
				scale = 0.8
			};
			
			
			
			--[[
			Button
			{
				font = StandardButtonFont,
				flags = kHAlignCenter + kVAlignCenter,
				graphics = UpButtonGraphics,
				name="scrollup",
				label="",
				type = kPush,
				x=420,
				y=225,
				scale = 0.8
			};
			
			Button
			{
				font = StandardButtonFont,
				flags = kHAlignCenter + kVAlignCenter,
				graphics = DownButtonGraphics,
				name="scrolldown",
				label="",
				type = kPush,
				x=420,
				y=430,
				scale = 0.8
			};
			--]]
			
			
			-- View Global High Score Button (Left Panel)
			Button
			{
				x=110,
				y=500,
				font = ChangeViewFont,
				flags = kHAlignCenter + kVAlignCenter,
				graphics = ChangeViewButtonGraphics,
				name="view",
				Label( "viewglobal", ChangeViewFont),
				type = kPush
			};
			
			-- View Local High Score Button (Left Panel)
			Button
			{
				x=110,
				y=500,
				font = ChangeViewFont,
				flags = kHAlignCenter + kVAlignCenter,
				graphics = ChangeViewButtonGraphics,
				name="viewlocal",
				Label( "viewlocal", ChangeViewFont),
				type = kPush
			};

	
			Button
			{
				x=1100,
				y=490,
				font = ChangeViewFont,
				flags = kHAlignCenter + kVAlignCenter,
				graphics = ChangeViewButtonGraphics,
				name="ShowPrivacy",
				Label( "viewlocal", ChangeViewFont),
				command=
					function()
						DoModal('scripts/hiscoreprivacy.lua');
					end
			};
			
			Button
			{
				x=600,
				y=560,
				font = ChangeViewFont,--StandardButtonFont,
				graphics = ChangeViewButtonGraphics,
				name="back",
				type = kPush,
				flags = kHAlignCenter + kVAlignCenter,
				Label( "BackToMain", ChangeViewFont),
				command = 
					function()
						PopModal(); -- take off high score menu, restart game loop
					end
			};
			
			Button
			{
				x=350,
				y=160,
				font = ChangeViewFont,
				flags = kHAlignCenter + kVAlignCenter,
				graphics = UpButtonGraphics,
				name="scrollup",
				--label="buttonscrollup",
				type = kPush
			};
			
			Button
			{
				x=350,
				y=500,
				font = ChangeViewFont,
				flags = kHAlignCenter + kVAlignCenter,
				graphics = DownButtonGraphics,
				name="scrolldown",
				--label="buttonscrolldowm",
				type = kPush
			};
			
		}
	}
}
