-- Help Message 

DebugOut("scripts/helpmenu.lua")

require("scripts/style.lua")

local tutorialButtonDeltaY = 43;
local tutorialStartY = 223;
local tutorialStartX = 137;
SetNextToTutorial(false);

HelpCheckboxGraphics = {
	"help/off-btn2",
	"help/over-btn2",
	"help/over-btn2",
	"help/over-btn2"
};

HelpBackToMainGraphics = {
	"buttons/long_button_up",
	"buttons/long_button_down",
	"buttons/long_button_over",
	"buttons/long_button_up"
};

LabelFontHelp_BackButton = 
{
	palaiFont,
	22,
	Color(255,255,255,255)
};

local zenModeHelpOffset = 0;

if( IsZenModeLocked() ) then
	zenModeHelpOffset = 10000;
end

MakeDialog
{
	Bitmap	-- Background bitmap
	{
		image="help/help-menu",

		x=kCenter,
		y=kCenter,

		FadeInWindow
		{
			x=0,y=0,w=kMax,h=kMax,
	
			SetStyle(BottomRowButton);

			Button
			{
				graphics = HelpCheckboxGraphics,
				x=96, y=222,
				w=36, h=36,
				flags = kHAlignCenter + kVAlignCenter,
				command= function()
					CurrentWorld = 1; CurrentLevel = 1; 
					SetTutorialMode(true);
					DoModal('scripts/arcade_main.lua');
				end
			};

			Button
			{
				graphics = HelpCheckboxGraphics,
				x=96, y=264,
				w=36, h=36,
				flags = kHAlignCenter + kVAlignCenter,

				command= function()
					CurrentWorld = 1; CurrentLevel = 2; 
					SetTutorialMode(true);
					DoModal('scripts/arcade_main.lua');
				end
			};

			Button
			{
				graphics = HelpCheckboxGraphics,
				x=96, y=308,
				w=36, h=36,
				flags = kHAlignCenter + kVAlignCenter,

				command= function()
					CurrentWorld = 1; CurrentLevel = 5; 
					SetTutorialMode(true);
					DoModal('scripts/arcade_main.lua');
				end
			};

			Button
			{
				graphics = HelpCheckboxGraphics,
				x=96, y=350,
				w=36, h=36,
				flags = kHAlignCenter + kVAlignCenter,

				command= function()
					CurrentWorld = 11; CurrentLevel = 1; 
					SetTutorialMode(true);
					DoModal('scripts/arcade_main.lua');
				end
			};

			Button
			{
				graphics = HelpCheckboxGraphics,
				x=96, y=392,
				w=36, h=36,
				flags = kHAlignCenter + kVAlignCenter,

				command= function()
					CurrentWorld = 1; CurrentLevel = 3;
					SetTutorialMode(true);
					DoModal('scripts/arcade_main.lua');
				end
			};

			Button
			{
				graphics = HelpCheckboxGraphics,
				x=96, y=434,
				w=36, h=36,
				flags = kHAlignCenter + kVAlignCenter,

				command= function()
					CurrentWorld = 5; CurrentLevel = 3;
					SetTutorialMode(true);
					DoModal('scripts/arcade_main.lua');
				end
			};

			-- Back to Main Button & Text
			Button
			{
				graphics = HelpBackToMainGraphics ;
				x=594,y=534;
				close = true;
				Label "BackToMain",
			};

			Text
			{
				font = LabelFontBlack,
				label="Tutorial1",
				y=tutorialStartY + tutorialButtonDeltaY * 0, x=tutorialStartX ,
				flags = kHAlignLeft + kVAlignCenter,
				h=30, w=150,
			};

			Text
			{
				font = LabelFontBlack,
				label="Tutorial2",
				y=tutorialStartY + tutorialButtonDeltaY * 1, x=tutorialStartX,
				flags = kHAlignLeft + kVAlignCenter,
				h=30, w=150,
			};

			Text
			{
				font = LabelFontBlack,
				label="Tutorial3",
				y=tutorialStartY + tutorialButtonDeltaY * 2, x=tutorialStartX,
				flags = kHAlignLeft + kVAlignCenter,
				h=30, w=150,
			};

			Text
			{
				font = LabelFontBlack,
				label="Tutorial4",
				y=tutorialStartY + tutorialButtonDeltaY * 3, x=tutorialStartX,
				flags = kHAlignLeft + kVAlignCenter,
				h=30, w=150,
			};

			Text
			{
				font = LabelFontBlack,
				label="Tutorial5",
				y=tutorialStartY + tutorialButtonDeltaY * 4, x=tutorialStartX,
				flags = kHAlignLeft + kVAlignCenter,
				h=30, w=150,
			};

			Text
			{
				font = LabelFontBlack,
				label="Tutorial6",
				y=tutorialStartY + tutorialButtonDeltaY * 5, x=tutorialStartX,
				flags = kHAlignLeft + kVAlignCenter,
				h=30, w=150,
			};

			Button
			{
				graphics = HelpCheckboxGraphics,
				x=534, y=396,
				w=36, h=36,
				flags = kHAlignCenter + kVAlignCenter,
				command = function()
						return DoModal("scripts/help.lua");
					end
			};

			Text
			{
				font = LabelFontBlack,
				label="ReadHowToPlay",
				y=400, x=570,
				flags = kHAlignLeft + kVAlignCenter,
				h=30, w=169,
			};


			Button
			{
				graphics = HelpCheckboxGraphics,
				x=534 + zenModeHelpOffset , y=438,
				w=36, h=36,
				flags = kHAlignCenter + kVAlignCenter,
				command = function()
						return DoModal("scripts/zenhelp.lua");
					end
			};

			Text
			{
				font = LabelFontBlack,
				label="ZenHowToPlay",
				x=570 + zenModeHelpOffset, y=442, 
				flags = kHAlignLeft + kVAlignCenter,
				h=30, w=169,
			};

		}
	}
}

