-- Collectable table

DebugOut("collectable_table_zen.lua")

require("scripts/style.lua")

LevelEndFont_Level = 
{
	palabiFont,
	31,
	Color(0,0,0,255)
	--Color(255,255,63,255)
};

LevelEndFont_LevelT = 
{
	palabiFont,
	31,
	Color(0,0,0,255)
	--Color(255,255,63,255)
};

LevelEndFont_Static = 
{
	palabiFont,
	21,
	Color(0,0,0,255)
	--Color(255,255,255,255)
};

LevelEndFont_StaticT = 
{
	palabiFont,
	21,
	Color(0,0,0,255)
	--Color(255,255,255,255)
};

LevelEndFont_Dyna = 
{
	palabiFont,
	21,
	Color(0,0,0,255)
	--Color(255,255,255,255)
};

LevelEndFont_DynaT = 
{
	palabiFont,
	21,
	Color(0,0,0,255)
	--Color(255,255,255,255)
};

LevelEndFont_Total = 
{
	palabiFont,
	31,
	Color(0,0,0,0)
	--Color(255,255,63,255)
};

LevelEndFont_TotalT = 
{
	palabiFont,
	31,
	Color(0,0,0,0)
	--Color(255,255,63,255)
};

QuoteFont = 
{
	palaiFont,--proportionalFont,
	24,
	Color(82,52,13,255)
};

MakeDialog
{
	-- Fade 50% black
	Bitmap
	{
		x=0, y=0, w=800, h=600,
		scale = 2,
		image = "backgrounds/black-2",
		name="blackFade",
	};
	
	Bitmap	-- Background bitmap
	{
		x=0,y=0,w=800,h=600,
		scale = 4,
		image="backgrounds/levelends-table",
		SetStyle(ButtonStyle);

		--Bitmap { name="LevelScoreHL", x=295,y=83; image="sprites/scores-highlight-2"; };
		Bitmap { name="PowerUpBonusHL", x=226,y=372; image="sprites/scores-highlight-2"; };
		Bitmap { name="TimeBonusHL", 	x=226,y=392; image="sprites/scores-highlight-2"; };
		Bitmap { name="BlockerBonusHL", x=226,y=412; image="sprites/scores-highlight-2"; };
		--Bitmap { name="TotalScoreHL", x=270,y=435,scale=1.25; image="sprites/scores-highlight-2"; };

		--Bitmap { name="DestroyedPiecesBg", x=103,y=129; image="buttons/end-destroypieces"; };
		--Bitmap { name="MatchCombosBg", x=238,y=129; image="buttons/end-matchcombos"; };
		--Bitmap { name="ElapsedTimeBg", x=360,y=129; image="buttons/end-timeelapsed"; };
		--Bitmap { name="BlockerBonusBg", x=382,y=203; image="buttons/end-blockers"; };
		--Bitmap { name="LevelScoreBg", 	x=382,y=275; image="buttons/end-levelscore"; };
		--Bitmap { name="PowerUpBonusBg", x=45 ,y=203; image="buttons/end-powerups"; };
		--Bitmap { name="TimeBonusBg", 	x=45 ,y=275; image="buttons/end-time"; };
		--Bitmap { name="TotalScoreBg", 	x=151,y=401; image="buttons/end-total"; };

		Bitmap { name="ExpertScore", x=196,y=243; image="backgrounds/expertscore-1"; };

		-- Level Score Text
		-- Title
		Text
		{
			name = "LevelScoreBg",
			label = "LevelScoreBg",
			x = 250, y = 115, w = 175, h = 35,
			font = LevelEndFont_LevelT;
			flags = kHAlignLeft + kVAlignCenter;
		};
		-- Counts
		Text
		{
			label="LevelScore",
			name="LevelScore",
			x = 390, y = 115, w = 150, h = 35;
			font = LevelEndFont_Level;
			flags = kHAlignRight + kVAlignCenter;
		};

		-- Pieces Matched Text
		-- Title
		Text
		{
			name = "DestroyedPiecesBg",
			label = "DestroyedPiecesBg",
			x = 250, y = 160, w = 150, h = 25,
			font = LevelEndFont_StaticT;
			flags = kHAlignLeft + kVAlignCenter;
		};
		-- Counts
		Text
		{
			label="DestroyedPieces",
			name="DestroyedPieces",
			x = 420, y = 160, w = 120, h = 25,
			font = LevelEndFont_Static;
			flags = kHAlignRight + kVAlignCenter;
		};

		-- Max Combo Text
		-- Title
		Text
		{
			name = "MatchCombosBg",
			label = "MatchCombosBg",
			x = 250, y = 180, w = 150, h = 25,
			font = LevelEndFont_StaticT;
			flags = kHAlignLeft + kVAlignCenter;
		};
		-- Counts
		Text
		{
			label="MatchCombos",
			name="MatchCombos",
			x = 420, y = 180, w = 120, h = 25,
			font = LevelEndFont_Static;
			flags = kHAlignRight + kVAlignCenter;
		};

		-- Total Time Text
		-- Title
		Text
		{
			name = "ElapsedTimeBg",
			label = "ElapsedTimeBg",
			x = 250, y = 200, w = 150, h = 25,
			font = LevelEndFont_StaticT;
			flags = kHAlignLeft + kVAlignCenter;
		};
		-- Counts
		Text
		{
			label="ElapsedTime",
			name="ElapsedTime",
			x = 420, y = 200, w = 120, h = 25,
			font = LevelEndFont_Static;
			flags = kHAlignRight + kVAlignCenter;
		};

		-- Powerup Bonus Text
		-- Title
		Text
		{
			name = "PowerUpBonusBg",
			label = "PowerUpBonusBg",
			x = 250, y = 370, w = 150, h = 25,
			font = LevelEndFont_DynaT;
			flags = kHAlignLeft + kVAlignCenter;
		};
		-- Counts
		Text
		{
			label="PowerUpBonus",
			name="PowerUpBonus",
			x = 420, y = 370, w = 120, h = 25,
			font = LevelEndFont_Dyna;
			flags = kHAlignRight + kVAlignCenter;
		};

		-- Time Bonus Text
		-- Title
		Text
		{
			name = "TimeBonusBg",
			label = "TimeBonusBg",
			x = 250, y = 390, w = 150, h = 25,
			font = LevelEndFont_DynaT;
			flags = kHAlignLeft + kVAlignCenter;
		};
		-- Counts
		Text
		{
			label="TimeBonus",
			name="TimeBonus",
			x = 420, y = 390, w = 120, h = 25;
			font = LevelEndFont_Dyna;
			flags = kHAlignRight + kVAlignCenter;
		};

		-- Blockers Bonus Text
		-- Title
		Text
		{
			name = "BlockerBonusBg",
			label = "BlockerBonusBg",
			x = 250, y = 410, w = 175, h = 25,
			font = LevelEndFont_DynaT;
			flags = kHAlignLeft + kVAlignCenter;
		};
		-- Counts
		Text
		{
			label="BlockerBonus",
			name="BlockerBonus",
			x = 420, y = 410, w = 120, h = 25;
			font = LevelEndFont_Dyna;
			flags =kHAlignRight + kVAlignCenter ;
		};

		-- Total Score Text
		-- Title
		Text
		{
			name = "TotalScoreBg",
			label = "TotalScoreBg",
			x = 250, y = 430, w = 175, h = 35,
			font = LevelEndFont_TotalT;
			flags = kHAlignLeft + kVAlignCenter;
		};
		-- Counts
		Text
		{
			label="TotalScore",
			name="TotalScore",
			x = 390, y = 430, w = 150, h = 35,
			font = LevelEndFont_Total;
			flags = kHAlignRight + kVAlignCenter;
		};

		----------------------------------------------------------------------
		
		CollectableTableWindow
		{
			x=0, y=0,
			w=kMax, h=kMax,
		},

		SetStyle(ButtonStyle);

		Button
		{
			x=230, y=445,
			Label "Quit",
			close=true,
			command=
				function()
					QuitFromGame();
				end
		};

		Button
		{
			x=340, y=445,
			Label "ViewHighScores",
			command=
				function()
					return DoModal("scripts/highscores.lua");
				end
		};

		Button
		{
			x=450, y=445,
			Label "BackMain",
			command=
				function()
					if( not IsShowedEndLevelQuote() ) then
						if(SpeedUpEvents()) then
							PopModal();
							Restart();
						end
					else
						PopModal();
						Restart();
					end
				end
		}
	}
}


