-- Help Message 

DebugOut("scripts/chooseplayer.lua")

require("scripts/style.lua")

NameButtonGraphics = {
	"controls/profile-btn-red",
	"controls/profile-btn-red",
	"controls/profile-btn-red",
	"controls/profile-btn-red"
};	


NameOKGraphics = {
	"controls/profile-btn-ok",
};	

NameFont =
{
	palaFont,
	25,
	Color(0,0,20,255)
};

LabelFontProfileButton =
{
	palaiFont,
	20,
	Color(255,255,255,255)
};

NameStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = NameFont,
	graphics = NameOKGraphics,
	length=12,
};

ButtonX = kCenter;
ButtonY = 105;
ButtonYSpace = 40;

function MakePlayerEntry(idx, entryName)
	return Bitmap
		{
			image="controls/profile-btn-red";
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*idx),
			name = (entryName .. "_bg");

			TextEdit
			{
				name = entryName,
				x=0,y=0,w=kMax,h=kMax,
				length=12,
				ignore = kIllegalNameChars
			};
		};
end

function MakeEntryButton(idx, entryName)
	return Button
		{
			name = (entryName .. "_button");
			x=ButtonX + 170,
			y=ButtonY+(ButtonYSpace*idx) - 2,
			w=kMax,h=kMax,
			command = function()
				CommitPlayerEntry(idx);
				SetWelcomeName();
			end
		};
end



MakeDialog
{
	Bitmap	-- Background bitmap
	{
		image="backgrounds/profilemenu",
		x=kCenter,
		y=kCenter,

		ChoosePlayerWindow
		{
			x=0,y=0,
			w=kMax,h=kMax,

			--[[Text
			{
				font = TitleFontBlack,
				label = "PlayerProfileLabel",
				x=kCenter, y=20,
				w=192, h=41,
				flags = kHAlignCenter + kVAlignCenter
			};--]]

			SetStyle(NameStyle);

			--BeginGroup();
			MakePlayerEntry(0, "name0");MakeEntryButton(0, "name0");
			MakePlayerEntry(1, "name1");MakeEntryButton(1, "name1");
			MakePlayerEntry(2, "name2");MakeEntryButton(2, "name2");
			MakePlayerEntry(3, "name3");MakeEntryButton(3, "name3");
			MakePlayerEntry(4, "name4");MakeEntryButton(4, "name4");
			MakePlayerEntry(5, "name5");MakeEntryButton(5, "name5");
			MakePlayerEntry(6, "name6");MakeEntryButton(6, "name6");
			MakePlayerEntry(7, "name7");MakeEntryButton(7, "name7");
			MakePlayerEntry(8, "name8");MakeEntryButton(8, "name8");
			MakePlayerEntry(9, "name9");MakeEntryButton(9, "name9");

			SetStyle(BottomRowButton);

			Button
			{
				font = LabelFontProfileButton,
				Label "AddLabel",
				x = 100 - 60,
				y = kMax -185,
				command = function() 
						CreateNewUser();
					  end
			};

			Button
			{
				font = LabelFontProfileButton,
				Label "EditLabel",
				x = 215 - 60,
				y = kMax - 185,
				command = function() 
						ChangeCurrentUserName();
					  end
			};

			Button
			{
				font = LabelFontProfileButton,
				Label "DeleteLabel",
				x= 330 - 60,
				y = kMax -185,
				command = function() 
						userNum = GetCurrentSelectedUser();
						DeleteUserEx(userNum);
					  end
			};

			Button
			{
				font = LabelFontProfileButton,
				Label "OKLabel",
				name = "OKButton",
				x= 330 - 60,
				y = kMax -85,
				close = true,
				command = function() 
						ApplyEditing();
						SetWelcomeName();
					  end
			};
		};
	}
}


