require "anim/animtools.lua"
require "anim/backdrops.lua"

local centerPos = {400,300};

Animations =
{
	-- Move 2 background scolling, assume that u use same seamless pic
	backMain('backgrounds/simple/landscape-2','',{400,440});
	
	backMainMove('backgrounds/movables/clouds-l2','backgrounds/movables/clouds-l2a',250000,{-400,300},{400,300});
	backMainMove('backgrounds/movables/clouds-l2','backgrounds/movables/clouds-l2a',250000,{400,300},{1200,300});
	
	Layer('backgrounds/movables/lightning-11')
	{
		Loop(0)
		{
			SetPos(250000,{-200,330},{900,330});
		};
		Loop(0)
		{
			Event(0)
			{
				SetAlpha(100, 0.0, 1.0);
			};
			Event(100)
			{
				SetAlpha(500, 1.0, 1.0);
			};
			Event(600)
			{
				SetAlpha(400, 1.0, 0.0);
			};
			Event(1000)
			{
				SetAlpha(15000, 0.0, 0.0);
			};
		};
	};
	
	backMainMove('backgrounds/movables/clouds-l1','backgrounds/movables/clouds-l1a',150000,{-400,122},{400,122});
	backMainMove('backgrounds/movables/clouds-l1','backgrounds/movables/clouds-l1a',150000,{400,122},{1200,122});
	
	Layer('backgrounds/movables/lightning-12')
	{
		Loop(0)
		{
			SetPos(150000,{-600,228},{950,228});
		};
		Loop(0)
		{
			Event(0)
			{
				SetAlpha(100, 0.0, 1.0);
			};
			Event(100)
			{
				SetAlpha(500, 1.0, 1.0);
			};
			Event(600)
			{
				SetAlpha(400, 1.0, 0.0);
			};
			Event(1000)
			{
				SetAlpha(15000, 0.0, 0.0);
			};
		};
	};
	
	Layer('sprites/jugs/center-shadow','sprites/jugs/center-shadow-2a')
	{
		Pos = centerPos;
		Scale = 2.0;
		Loop(1)
		{
			Event(0)
			{
				SetAlpha(3000, 0.0, 0.0);
			};
			Event(3000)
			{
				SetAlpha(1000, 0.0, 0.75);
			};
			Event(4000)
			{
				Loop(0)
				{
					Event(0)
					{
						SetAlpha(1000, 0.75, 0.75);
					};
				};
			};
		};
	};
	
	-- Drop-Shadow
	Layer('sprites/jugs/center-shadow','sprites/jugs/center-shadow-1a')
	{
		Pos = {400,300};--centerPos;
		Scale = 2.55;
	};
	
	jugJewelAnim01(centerPos,1.075);
	jugJewelAnim02(centerPos,1.075);
	jugJewelAnim03(centerPos,1.075);
	jugJewelAnim04(centerPos,1.075);
	jugJewelAnim05(centerPos,1.075);
	
	timerBarBack('sprites/jugs/timer-center-clockback','sprites/jugs/timer-center-clockback-a',centerPos);
	
	startArrowOut();
	
}

