require "anim/animtools.lua"

function fadeIn()
	return
	Layer('backgrounds/black-1')
	{
		Pos = {400,300};
		Scale = 2.0;
		Loop(1)
		{
			Event(0)
			{
				SetAlpha(1000, 1.0, 0.0);
			};
		};
	};
end
	

function backMain(fileName,fileAlphaName,centerPos)
	return
	Layer(fileName,fileAlphaName)
	{
		Pos = centerPos;
		Loop(0)
		{
			
		};
	};
end

function backMainA(fileName,fileAlphaName,centerPos,inAlpha)
	return
	Layer(fileName,fileAlphaName)
	{
		Pos = centerPos;
		--Alpha = inAlpha;
		Loop(0)
		{
			SetAlpha(1000,inAlpha,inAlpha);
		};
	};
end

function backMainMove(fileName,fileAlphaName,duration,startPos,endPos)
	return
	Layer(fileName,fileAlphaName)
	{
		--Pos = centerPos;
		Loop(0)
		{
			SetPos(duration,startPos,endPos);
		};
	};
end

function backMainMoveA(fileName,fileAlphaName,duration,startPos,endPos,fAlpha)
	return
	Layer(fileName,fileAlphaName)
	{
		--Pos = centerPos;
		Alpha = fAlpha;
		Loop(0)
		{
			SetPos(duration,startPos,endPos);
		};
	};
end

function backMainMoveRotate(fileName,fileAlphaName,duration,startPos,endPos,rotStart,rotEnd)
	return
	Layer(fileName,fileAlphaName)
	{
		Loop(0)
		{
			Event(0)
			{
				SetRotation(duration,rotStart,rotEnd);
				SetPos(duration,startPos,endPos);
			};
		};
	};
end

function startArrowIn()
	return
	Layer('sprites/piece-arrows-in')
	{
		Pos = {400,300};
		Loop(2)
		{
			Event(0)
			{
				SetScale(550,1.75,1.0);
			};
		};
		Loop(2)
		{
			Event(0)
			{
				SetAlpha(275, 0.0, 1.0);
			};
			Event(275)
			{
				SetAlpha(275, 1.0, 0.0);
			};
			Event(550)
			{
				SetAlpha(200, 0, 0);
			};
		};
	};
end

function startArrowOut()
	return
	Layer('sprites/piece-arrows-out')
	{
		Pos = {400,300};
		Loop(2)
		{
			Event(0)
			{
				SetScale(550,0.75,1.5);
			};
		};
		Loop(2)
		{
			Event(0)
			{
				SetAlpha(275, 0.0, 1.0);
			};
			Event(275)
			{
				SetAlpha(275, 1.0, 0.0);
			};
			Event(550)
			{
				SetAlpha(200, 0, 0);
			};
		};
	};
end

function backRing31(fileName,fileAlphaName,rotSpeed,rotFrom,rotTo,centerPos,levelScale)
	return
	Layer(fileName,fileAlphaName)
	{
		Pos = centerPos;
		--Scale = 0.8;
		
		Loop(0)
		{
			Event(0)
			{
				SetRotation(rotSpeed,rotFrom,rotTo);
			};
		};
		
		Loop(0)
		{
			Event(0)
			{
				SetScale(10000, levelScale[1], levelScale[2]);
				SetAlpha(10000, 0.0, 0.8);
			};
			Event(10000)
			{
				SetScale(10000, levelScale[2], levelScale[3]);
				SetAlpha(10000, 0.8, 1.0);
			};
			Event(20000)
			{
				SetScale(10000, levelScale[3], levelScale[4]);
				SetAlpha(10000, 1.0, 0.0);
			};
		};
	};
end

function backRing32(fileName,fileAlphaName,rotSpeed,rotFrom,rotTo,centerPos,levelScale)
	return
	Layer(fileName,fileAlphaName)
	{
		Pos = centerPos;
		--Scale = 0.9;
		
		Loop(0)
		{
			Event(0)
			{
				SetRotation(rotSpeed,rotFrom,rotTo);
			};
		};
		
		Loop(0)
		{
			Event(0)
			{
				SetScale(10000, levelScale[2], levelScale[3]);
				SetAlpha(10000, 0.8, 1.0);
			};
			Event(10000)
			{
				SetScale(10000, levelScale[3], levelScale[4]);
				SetAlpha(10000, 1.0, 0.0);
			};
			Event(20000)
			{
				SetScale(10000, levelScale[1], levelScale[2]);
				SetAlpha(10000, 0.0, 0.8);
			};
		};
	};
end

function backRing33(fileName,fileAlphaName,rotSpeed,rotFrom,rotTo,centerPos,levelScale)
	return	
	Layer(fileName,fileAlphaName)
	{
		Pos = centerPos;
		Scale = 2.0;
		Loop(0)
		{
			Event(0)
			{
				SetRotation(rotSpeed,rotFrom,rotTo);
			};
		};
		
		Loop(0)
		{
			Event(0)
			{
				SetScale(10000, levelScale[3], levelScale[4]);
				SetAlpha(10000, 1.0, 0.0);
			};
			Event(10000)
			{
				SetScale(10000, levelScale[1], levelScale[2]);
				SetAlpha(10000, 0.0, 0.8);
			};
			Event(20000)
			{
				SetScale(10000, levelScale[2], levelScale[3]);
				SetAlpha(10000, 0.8, 1.0);
			};
		}
	};
end

function timerBarBack(fileName,fileAlphaName,centerPos)
	return
	Layer(fileName,fileAlphaName)
	{
		Pos = centerPos;
		Loop(0)
		{
			Event(0)
			{
				--SetScale(100000, 1.1, 1.1)
			};
		};
	};
end

function jugJewelAnim01(centerPos,fScale)
	return
	Layer('sprites/jugs/center-jug-jewel-0-1','sprites/jugs/center-jug-jewel-0-a')
	{
		Pos = centerPos;
		Scale = fScale;
	};
end

function jugJewelAnim02(centerPos,fScale)
	return
	Layer('sprites/jugs/center-jug-jewel-0-2','sprites/jugs/center-jug-jewel-0-a')
	{
		Pos = centerPos;
		Scale = fScale;
		Loop(0)
		{
			Event(0)
			{
				SetAlpha(250,0.0,1.0);
			};
			Event(250)
			{
				SetAlpha(250,1.0,0.0);
			};
			Event(500)
			{
				SetAlpha(2500,0.0,0.0);
			};
		};
	};
end

function jugJewelAnim03(centerPos,fScale)
	return
	Layer('sprites/jugs/center-jug-jewel-0-3','sprites/jugs/center-jug-jewel-0-a')
	{
		Pos = centerPos;
		Scale = fScale;
		Loop(0)
		{
			Event(0)
			{
				SetAlpha(250,0.0,0.0);
			};
			Event(250)
			{
				SetAlpha(250,0.0,1.0);
			};
			Event(500)
			{
				SetAlpha(250,1.0,0.0);
			};
			Event(750)
			{
				SetAlpha(2250,0.0,0.0);
			};
		};
	};
end

function jugJewelAnim04(centerPos,fScale)
	return
	Layer('sprites/jugs/center-jug-jewel-0-4','sprites/jugs/center-jug-jewel-0-a')
	{
		Pos = centerPos;
		Scale = fScale;
		Loop(0)
		{
			Event(0)
			{
				SetAlpha(500,0.0,0.0);
			};
			Event(500)
			{
				SetAlpha(250,0.0,1.0);
			};
			Event(750)
			{
				SetAlpha(250,1.0,0.0);
			};
			Event(1000)
			{
				SetAlpha(2000,0.0,0.0);
			};
		};
	};
end

function jugJewelAnim05(centerPos,fScale)
	return
	Layer('sprites/jugs/center-jug-jewel-0-5','sprites/jugs/center-jug-jewel-0-a')
	{
		Pos = centerPos;
		Scale = fScale;
		Loop(0)
		{
			Event(0)
			{
				SetAlpha(750,0.0,0.0);
			};
			Event(750)
			{
				SetAlpha(250,0.0,1.0);
			};
			Event(1000)
			{
				SetAlpha(250,1.0,0.0);
			};
			Event(1250)
			{
				SetAlpha(1750,0.0,0.0);
			};
		};
	};
end

function jugEneryAnim01(centerPos,fScale)
	return
	Layer('sprites/jugs/center-jug-back-0','sprites/jugs/center-jug-back-a')
	{
		Pos = centerPos;
		Scale = fScale;
		Loop(0)
		{
			Event(0)
			{
				SetRotation(120000,0,360);
			};
		};
	};
end

function jugEneryAnim02(centerPos,fScale)
	return
	Layer('sprites/jugs/center-jug-back-1','sprites/jugs/center-jug-back-a')
	{
		Pos = centerPos;
		Scale = fScale;
		Loop(0)
		{
			Event(0)
			{
				SetRotation(10000,0,360);
			};
		};
		Loop(0)
		{
			Event(0)
			{
				SetAlpha(1500, 0.3, 1.0);
			};
			Event(1500)
			{
				SetAlpha(500, 1.0, 1.0);
			};
			Event(2000)
			{
				SetAlpha(1500, 1.0, 0.3);
			};
		};
	};
end




