/*
 * Decompiled with CFR 0.152.
 */
package com.mct.w6;

import com.mct.util.TinGraphicsUtil;
import com.mct.w6.W6GameState;
import com.mct.w6.W6GameWindow;
import com.mct.w6.W6ScenarioInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class W6ScenarioChooser
extends JDialog
implements ActionListener,
ContentHandler,
FilenameFilter {
    Vector availableScenarios = new Vector();
    Vector availableGroups = new Vector();
    File selectedScenario;
    File scenarioDir;
    Box sch = Box.createHorizontalBox();
    Box scvl = Box.createVerticalBox();
    Box scvc = Box.createVerticalBox();
    Box bh = Box.createHorizontalBox();
    JLabel labelSelectScenario = new JLabel("Select Scenario: ");
    JLabel labelSelectGroup = new JLabel("Select Group: ");
    JComboBox comboSelectScenario = new JComboBox();
    JComboBox comboSelectGroup = new JComboBox();
    JButton cmdStart = new JButton("Start");
    JButton cmdCancel = new JButton("Cancel");
    W6ScenarioInfo sceneInfo;
    int fakeStatus = 0;
    int neutralStatus = 0;
    boolean loadingGameState = false;
    W6GameState scenario;
    TinGraphicsUtil util = new TinGraphicsUtil();

    public W6ScenarioChooser() {
        this.init();
        this.populateScenarioList();
    }

    public void init() {
        ((Component)this).setBounds(0, 0, 500, 225);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridLayout(2, 1));
        this.cmdStart.addActionListener(this);
        this.scvl.add(Box.createVerticalStrut(10));
        this.scvl.add(this.labelSelectScenario);
        this.scvl.add(Box.createVerticalStrut(10));
        this.scvl.add(this.labelSelectGroup);
        this.scvl.add(Box.createVerticalStrut(10));
        this.scvc.add(Box.createVerticalStrut(10));
        this.scvc.add(this.comboSelectScenario);
        this.scvc.add(Box.createVerticalStrut(10));
        this.scvc.add(this.comboSelectGroup);
        this.scvc.add(Box.createVerticalStrut(10));
        this.sch.add(Box.createHorizontalStrut(100));
        this.sch.add(this.scvl);
        this.sch.add(Box.createHorizontalStrut(10));
        this.sch.add(this.scvc);
        this.sch.add(Box.createHorizontalStrut(50));
        this.bh.add(Box.createHorizontalGlue());
        this.bh.add(Box.createHorizontalStrut(300));
        this.bh.add(this.cmdStart);
        this.bh.add(this.cmdCancel);
        this.bh.add(Box.createHorizontalStrut(100));
        this.getContentPane().add(this.sch);
        this.getContentPane().add(this.bh);
    }

    public void populateScenarioList() {
        this.comboSelectScenario.removeAllItems();
        this.comboSelectGroup.removeAllItems();
        this.scenarioDir = new File(System.getProperty("user.dir") + "/scn");
        if (!this.scenarioDir.exists()) {
            this.scenarioDir.mkdir();
            this.handleNoScenarios();
        } else {
            File[] list = this.scenarioDir.listFiles(this);
            if (Array.getLength(list) == 0) {
                this.handleNoScenarios();
            } else {
                int i = 0;
                while (i < Array.getLength(list)) {
                    this.comboSelectScenario.addItem(list[i].getName());
                    ++i;
                }
            }
        }
        this.loadScenarioInfo();
    }

    public void populateGroupList() {
        int i = 0;
        while (i < this.sceneInfo.groupCount) {
            if (!this.sceneInfo.isFake(i)) {
                this.comboSelectGroup.addItem(this.sceneInfo.groupNames[i]);
            }
            ++i;
        }
    }

    public void loadScenarioInfo() {
        String filename = this.scenarioDir.getAbsolutePath() + "/" + (String)this.comboSelectScenario.getSelectedItem();
        try {
            SAXParser parser = new SAXParser();
            parser.setContentHandler(this);
            parser.parse(filename);
            this.populateGroupList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadGameState() {
        String filename = this.scenarioDir.getAbsolutePath() + "/" + (String)this.comboSelectScenario.getSelectedItem();
        try {
            SAXParser parser = new SAXParser();
            parser.setContentHandler(this);
            parser.parse(filename);
            this.loadMap();
            ((Component)this).setVisible(false);
            W6GameWindow gw = new W6GameWindow(this.scenario);
            this.scenario = null;
            ((Component)gw).setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadRgbZones() {
        int x = 0;
        while (x < this.scenario.frontiers.getWidth()) {
            int y = 0;
            while (y < this.scenario.frontiers.getHeight()) {
                int cid = new Color(this.scenario.frontiers.getRGB(x, y)).getRed();
                this.scenario.rgbBounds.addPoint(cid, x, y);
                ++y;
            }
            ++x;
        }
    }

    public void loadMap() {
        this.scenario.onscreen = TinGraphicsUtil.makeBufferedImage(TinGraphicsUtil.blockingLoad(System.getProperty("user.dir") + "/maps/frontier.gif"));
        this.scenario.frontiers = TinGraphicsUtil.makeBufferedImage(TinGraphicsUtil.blockingLoad(System.getProperty("user.dir") + "/maps/frontier.gif"));
        this.scenario.bumps = TinGraphicsUtil.makeBufferedImage(TinGraphicsUtil.blockingLoad(System.getProperty("user.dir") + "/maps/bump.gif"));
        this.loadRgbZones();
        int ix = 0;
        while (ix < this.scenario.frontiers.getWidth()) {
            int iy = 0;
            while (iy < this.scenario.frontiers.getHeight()) {
                Color pixelColor = new Color(this.scenario.frontiers.getRGB(ix, iy));
                int cid = pixelColor.getRed();
                int gid = this.scenario.countryOwners[cid];
                Color bumpColor = new Color(this.scenario.bumps.getRGB(ix, iy));
                Color groupColor = new Color(this.scenario.groupRed[gid], this.scenario.groupGreen[gid], this.scenario.groupBlue[gid]);
                int nr = (bumpColor.getRed() + groupColor.getRed()) / 2;
                int ng = (bumpColor.getGreen() + groupColor.getGreen()) / 2;
                int nb = (bumpColor.getBlue() + groupColor.getBlue()) / 2;
                Color combinedColor = new Color(nr, ng, nb);
                this.scenario.onscreen.setRGB(ix, iy, combinedColor.getRGB());
                ++iy;
            }
            if ((double)(ix / 100) == (double)ix / 100.0) {
                System.out.println(ix);
            }
            ++ix;
        }
        this.scenario.humanGroup = this.comboSelectGroup.getSelectedIndex() + this.scenario.fakeCount;
        this.scenario.selectedCountry = this.scenario.groupHome[this.scenario.humanGroup];
        this.spawnArmies();
    }

    public void spawnArmies() {
        int i = 0;
        while (i < this.scenario.countryCount) {
            this.scenario.spawnArmy(i);
            ++i;
        }
    }

    public void handleNoScenarios() {
        this.comboSelectScenario.addItem("No Scenarios Available");
        this.comboSelectScenario.setEnabled(false);
        this.comboSelectGroup.setEnabled(false);
    }

    public boolean accept(File dir, String name) {
        return name.endsWith(".xml");
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource().equals(this.cmdStart)) {
            this.loadingGameState = true;
            this.loadGameState();
        }
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        String s = new String(ch, start, end);
    }

    public void endDocument() throws SAXException {
        this.neutralStatus = 0;
        this.fakeStatus = 0;
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public W6ScenarioInfo getScenarioInfo() {
        return this.sceneInfo;
    }

    public void ignorableWhitespace(char[] ch, int start, int end) throws SAXException {
        String s = new String(ch, start, end);
    }

    public void processingInstruction(String arg1, String arg2) throws SAXException {
    }

    public void setDocumentLocator(Locator arg1) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        block75: {
            block73: {
                block77: {
                    block76: {
                        block74: {
                            if (!this.loadingGameState) break block73;
                            if (!localName.equals("Date")) break block74;
                            int i = 0;
                            while (i < atts.getLength()) {
                                if (atts.getLocalName(i).equals("day")) {
                                    this.scenario.day = Integer.parseInt(atts.getValue(i));
                                } else if (atts.getLocalName(i).equals("month")) {
                                    this.scenario.month = Integer.parseInt(atts.getValue(i));
                                } else if (atts.getLocalName(i).equals("year")) {
                                    this.scenario.year = Integer.parseInt(atts.getValue(i));
                                }
                                ++i;
                            }
                            break block75;
                        }
                        if (!localName.equals("Scenario")) break block76;
                        int noc = 0;
                        int nog = 0;
                        int nof = 0;
                        int non = 0;
                        int i = 0;
                        while (i < atts.getLength()) {
                            if (atts.getLocalName(i).equals("countryCount")) {
                                noc = Integer.parseInt(atts.getValue(i));
                            } else if (atts.getLocalName(i).equals("groupCount")) {
                                nog = Integer.parseInt(atts.getValue(i));
                            } else if (atts.getLocalName(i).equals("fakeCount")) {
                                nof = Integer.parseInt(atts.getValue(i));
                            } else if (atts.getLocalName(i).equals("neutralCount")) {
                                non = Integer.parseInt(atts.getValue(i));
                            }
                            ++i;
                        }
                        this.scenario = new W6GameState(noc, nog, nof, non);
                        break block75;
                    }
                    if (!localName.equals("Country")) break block77;
                    int id = 0;
                    int i = 0;
                    while (i < atts.getLength()) {
                        if (atts.getLocalName(i).equals("id")) {
                            id = Integer.parseInt(atts.getValue(i));
                        } else if (atts.getLocalName(i).equals("name")) {
                            this.scenario.countryNames[id] = atts.getValue(i);
                        } else if (atts.getLocalName(i).equals("owner")) {
                            this.scenario.countryOwners[id] = Integer.parseInt(atts.getValue(i));
                            int n = Integer.parseInt(atts.getValue(i));
                            this.scenario.territoryCount[n] = this.scenario.territoryCount[n] + 1;
                        } else if (atts.getLocalName(i).equals("pop")) {
                            this.scenario.countryPops[id] = Long.parseLong(atts.getValue(i));
                        } else if (atts.getLocalName(i).equals("gdp")) {
                            this.scenario.countryGDPs[id] = Long.parseLong(atts.getValue(i));
                        }
                        ++i;
                    }
                    break block75;
                }
                if (!localName.equals("Group")) break block75;
                int id = 0;
                int i = 0;
                while (i < atts.getLength()) {
                    if (atts.getLocalName(i).equals("id")) {
                        id = Integer.parseInt(atts.getValue(i));
                    } else if (atts.getLocalName(i).equals("name")) {
                        this.scenario.groupNames[id] = atts.getValue(i);
                    } else if (atts.getLocalName(i).equals("red")) {
                        this.scenario.groupRed[id] = Integer.parseInt(atts.getValue(i));
                    } else if (atts.getLocalName(i).equals("green")) {
                        this.scenario.groupGreen[id] = Integer.parseInt(atts.getValue(i));
                    } else if (atts.getLocalName(i).equals("blue")) {
                        this.scenario.groupBlue[id] = Integer.parseInt(atts.getValue(i));
                    } else if (atts.getLocalName(i).equals("fake")) {
                        if (atts.getValue(i).equals("true")) {
                            this.scenario.fakeGroups[this.fakeStatus] = id;
                            ++this.fakeStatus;
                        }
                    } else if (atts.getLocalName(i).equals("neutral")) {
                        if (atts.getValue(i).equals("true")) {
                            this.scenario.neutralGroups[this.neutralStatus] = id;
                            ++this.neutralStatus;
                        }
                    } else if (atts.getLocalName(i).equals("party")) {
                        this.scenario.groupPolitics[i] = Integer.parseInt(atts.getValue(i));
                    } else if (atts.getLocalName(i).equals("home")) {
                        this.scenario.groupHome[id] = Integer.parseInt(atts.getValue(i));
                    }
                    ++i;
                }
                break block75;
            }
            if (localName.equals("Scenario")) {
                int nog = 0;
                int nof = 0;
                int non = 0;
                int i = 0;
                while (i < atts.getLength()) {
                    if (atts.getLocalName(i).equals("groupCount")) {
                        nog = Integer.parseInt(atts.getValue(i));
                    } else if (atts.getLocalName(i).equals("fakeCount")) {
                        nof = Integer.parseInt(atts.getValue(i));
                    } else if (atts.getLocalName(i).equals("neutralCount")) {
                        non = Integer.parseInt(atts.getValue(i));
                    }
                    ++i;
                }
                this.sceneInfo = new W6ScenarioInfo(nog, nof, non);
            } else if (localName.equals("Group")) {
                int id = 0;
                int i = 0;
                while (i < atts.getLength()) {
                    if (atts.getLocalName(i).equals("id")) {
                        id = Integer.parseInt(atts.getValue(i));
                    } else if (atts.getLocalName(i).equals("name")) {
                        this.sceneInfo.groupNames[id] = atts.getValue(i);
                    } else if (atts.getLocalName(i).equals("red")) {
                        this.sceneInfo.groupRed[id] = Integer.parseInt(atts.getValue(i));
                    } else if (atts.getLocalName(i).equals("green")) {
                        this.sceneInfo.groupGreen[id] = Integer.parseInt(atts.getValue(i));
                    } else if (atts.getLocalName(i).equals("blue")) {
                        this.sceneInfo.groupBlue[id] = Integer.parseInt(atts.getValue(i));
                    } else if (atts.getLocalName(i).equals("fake")) {
                        if (atts.getValue(i).equals("true")) {
                            this.sceneInfo.fakeGroups[this.fakeStatus] = id;
                            ++this.fakeStatus;
                        }
                    } else if (atts.getLocalName(i).equals("neutral")) {
                        if (atts.getValue(i).equals("true")) {
                            this.sceneInfo.neutralGroups[this.neutralStatus] = id;
                            ++this.neutralStatus;
                        }
                    } else if (atts.getLocalName(i).equals("party")) {
                        this.sceneInfo.groupPolitics[i] = Integer.parseInt(atts.getValue(i));
                    } else if (atts.getLocalName(i).equals("home")) {
                        this.sceneInfo.groupHome[i] = Integer.parseInt(atts.getValue(i));
                    }
                    ++i;
                }
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

