/*
 * Decompiled with CFR 0.152.
 */
package com.mct.w6;

import com.mct.w6.W6GameState;
import com.mct.w6.W6GameWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class W6PurchaseTroopsWindow
extends JDialog
implements ActionListener,
ChangeListener {
    NumberFormat nf = NumberFormat.getInstance();
    long availableCash;
    W6GameState gs;
    W6GameWindow gw;
    JLabel i = new JLabel("(0)");
    JLabel t = new JLabel("(0)");
    JLabel e = new JLabel("(0)");
    JLabel a = new JLabel("(0)");
    JLabel m = new JLabel("(0)");
    JLabel n = new JLabel("(0)");
    JSlider infantry = new JSlider(0);
    JSlider tanks = new JSlider(0);
    JSlider elite = new JSlider(0);
    JSlider air = new JSlider(0);
    JSlider missiles = new JSlider(0);
    JSlider nukes = new JSlider(0);
    JButton buy = new JButton("Buy");
    JButton cancel = new JButton("Cancel");

    public W6PurchaseTroopsWindow(W6GameWindow gw) {
        ((Component)this).setBounds(0, 0, 300, 300);
        this.setTitle("Purchase Troops");
        ((Component)this).setVisible(false);
        this.gw = gw;
        this.buy.addActionListener(this);
        this.cancel.addActionListener(this);
        this.infantry.addChangeListener(this);
        this.tanks.addChangeListener(this);
        this.elite.addChangeListener(this);
        this.air.addChangeListener(this);
        this.missiles.addChangeListener(this);
        this.nukes.addChangeListener(this);
        this.infantry.setValue(0);
        this.tanks.setValue(0);
        this.elite.setValue(0);
        this.air.setValue(0);
        this.missiles.setValue(0);
        this.nukes.setValue(0);
        Box vContent = Box.createVerticalBox();
        Box hSliders = Box.createHorizontalBox();
        Box vLabels = Box.createVerticalBox();
        Box vTroops = Box.createVerticalBox();
        Box vSliders = Box.createVerticalBox();
        Box hButtons = Box.createHorizontalBox();
        hButtons.add(this.buy);
        hButtons.add(Box.createHorizontalStrut(10));
        hButtons.add(this.cancel);
        vLabels.add(Box.createVerticalStrut(10));
        vLabels.add(new JLabel("Infantry: "));
        vLabels.add(Box.createVerticalStrut(10));
        vLabels.add(new JLabel("Tanks: "));
        vLabels.add(Box.createVerticalStrut(10));
        vLabels.add(new JLabel("Elites: "));
        vLabels.add(Box.createVerticalStrut(10));
        vLabels.add(new JLabel("Air: "));
        vLabels.add(Box.createVerticalStrut(10));
        vLabels.add(new JLabel("Missiles: "));
        vLabels.add(Box.createVerticalStrut(10));
        vLabels.add(new JLabel("Nukes: "));
        vLabels.add(Box.createVerticalStrut(10));
        vTroops.add(Box.createVerticalStrut(10));
        vTroops.add(this.i);
        vTroops.add(Box.createVerticalStrut(10));
        vTroops.add(this.t);
        vTroops.add(Box.createVerticalStrut(10));
        vTroops.add(this.e);
        vTroops.add(Box.createVerticalStrut(10));
        vTroops.add(this.a);
        vTroops.add(Box.createVerticalStrut(10));
        vTroops.add(this.m);
        vTroops.add(Box.createVerticalStrut(10));
        vTroops.add(this.n);
        vTroops.add(Box.createVerticalStrut(10));
        vSliders.add(Box.createVerticalStrut(10));
        vSliders.add(this.infantry);
        vSliders.add(Box.createVerticalStrut(10));
        vSliders.add(this.tanks);
        vSliders.add(Box.createVerticalStrut(10));
        vSliders.add(this.elite);
        vSliders.add(Box.createVerticalStrut(10));
        vSliders.add(this.air);
        vSliders.add(Box.createVerticalStrut(10));
        vSliders.add(this.missiles);
        vSliders.add(Box.createVerticalStrut(10));
        vSliders.add(this.nukes);
        vSliders.add(Box.createVerticalStrut(10));
        hSliders.add(Box.createHorizontalStrut(10));
        hSliders.add(vLabels);
        hSliders.add(Box.createHorizontalStrut(25));
        hSliders.add(vSliders);
        hSliders.add(Box.createHorizontalStrut(10));
        vContent.add(hSliders);
        vContent.add(Box.createVerticalStrut(10));
        vContent.add(hButtons);
        this.getContentPane().add(vContent);
    }

    public void setGameState(W6GameState gamestate) {
        this.gs = gamestate;
        this.resetSliderValues();
        this.updateAvailableCash();
        this.updateSliderMaxes();
    }

    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o.equals(this.buy)) {
            int n;
            int m;
            int a;
            int e;
            int t;
            boolean canbuy = false;
            int i = this.infantry.getValue();
            long cost = i * this.gs.infantryCost + (t = this.tanks.getValue()) * this.gs.tankCost + (e = this.elite.getValue()) * this.gs.eliteCost + (a = this.air.getValue()) * this.gs.airCost + (m = this.missiles.getValue()) * this.gs.missileCost + (n = this.nukes.getValue()) * this.gs.nukeCost;
            if (cost > this.gs.countryCash[this.gs.selectedCountry]) {
                JOptionPane.showMessageDialog(null, "Not Enough Money!");
            } else {
                int n2 = this.gs.selectedCountry;
                this.gs.friendlyInfantry[n2] = this.gs.friendlyInfantry[n2] + (long)i;
                int n3 = this.gs.selectedCountry;
                this.gs.friendlyTanks[n3] = this.gs.friendlyTanks[n3] + (long)t;
                int n4 = this.gs.selectedCountry;
                this.gs.friendlyElite[n4] = this.gs.friendlyElite[n4] + (long)e;
                int n5 = this.gs.selectedCountry;
                this.gs.friendlyAir[n5] = this.gs.friendlyAir[n5] + (long)a;
                int n6 = this.gs.selectedCountry;
                this.gs.friendlyMissiles[n6] = this.gs.friendlyMissiles[n6] + (long)m;
                int n7 = this.gs.selectedCountry;
                this.gs.friendlyNukes[n7] = this.gs.friendlyNukes[n7] + (long)n;
                int n8 = this.gs.selectedCountry;
                this.gs.countryCash[n8] = this.gs.countryCash[n8] - cost;
                this.gw.gs = this.gs;
            }
            this.exit();
        } else if (o.equals(this.cancel)) {
            this.exit();
        }
    }

    public void stateChanged(ChangeEvent ce) {
        this.updateAvailableCash();
        this.updateSliderMaxes();
        this.updateSliderMinimums();
    }

    public void resetSliderValues() {
        this.infantry.setValue(0);
        this.tanks.setValue(0);
        this.elite.setValue(0);
        this.air.setValue(0);
        this.missiles.setValue(0);
        this.nukes.setValue(0);
    }

    public void updateAvailableCash() {
        if (this.gs != null) {
            this.availableCash = this.gs.countryCash[this.gs.selectedCountry];
            this.availableCash -= (long)(this.infantry.getValue() * this.gs.infantryCost);
            this.availableCash -= (long)(this.tanks.getValue() * this.gs.tankCost);
            this.availableCash -= (long)(this.elite.getValue() * this.gs.eliteCost);
            this.availableCash -= (long)(this.air.getValue() * this.gs.airCost);
            this.availableCash -= (long)(this.missiles.getValue() * this.gs.missileCost);
            this.availableCash -= (long)(this.nukes.getValue() * this.gs.nukeCost);
        }
    }

    public void updateSliderMinimums() {
        if (this.gs != null) {
            this.infantry.setMinimum(0);
            this.tanks.setMinimum(0);
            this.elite.setMinimum(0);
            this.air.setMinimum(0);
            this.missiles.setMinimum(0);
            this.nukes.setMinimum(0);
        }
    }

    public void updateSliderMaxes() {
        if (this.gs != null) {
            int sc = this.gs.selectedCountry;
            this.infantry.setMaximum(this.infantry.getValue() + (int)this.availableCash / this.gs.infantryCost);
            this.tanks.setMaximum(this.tanks.getValue() + (int)this.availableCash / this.gs.tankCost);
            this.elite.setMaximum(this.elite.getValue() + (int)this.availableCash / this.gs.eliteCost);
            this.air.setMaximum(this.air.getValue() + (int)this.availableCash / this.gs.airCost);
            this.missiles.setMaximum(this.missiles.getValue() + (int)this.availableCash / this.gs.missileCost);
            this.nukes.setMaximum(this.nukes.getValue() + (int)this.availableCash / this.gs.nukeCost);
        }
    }

    public void exit() {
        this.infantry.setValue(0);
        this.tanks.setValue(0);
        this.elite.setValue(0);
        this.air.setValue(0);
        this.missiles.setValue(0);
        this.nukes.setValue(0);
        ((Component)this).setVisible(false);
    }
}

