/*
 * Decompiled with CFR 0.152.
 */
package com.mct.w6;

import com.mct.w6.W6GameState;
import com.mct.w6.W6GameWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class W6MoveTroopsWindow
extends JDialog
implements ActionListener,
ChangeListener {
    NumberFormat nf = NumberFormat.getInstance();
    boolean hostile = false;
    long availableCash;
    W6GameState gs;
    W6GameWindow gw;
    JSlider infantry = new JSlider(0);
    JSlider tanks = new JSlider(0);
    JSlider elite = new JSlider(0);
    JSlider air = new JSlider(0);
    JSlider missiles = new JSlider(0);
    JSlider nukes = new JSlider(0);
    JButton send = new JButton("Send");
    JButton cancel = new JButton("Cancel");

    public W6MoveTroopsWindow(W6GameWindow gw) {
        ((Component)this).setBounds(0, 0, 300, 300);
        this.setTitle("Move Troops");
        ((Component)this).setVisible(false);
        this.gw = gw;
        this.send.addActionListener(this);
        this.cancel.addActionListener(this);
        this.infantry.addChangeListener(this);
        this.tanks.addChangeListener(this);
        this.elite.addChangeListener(this);
        this.air.addChangeListener(this);
        this.missiles.addChangeListener(this);
        this.nukes.addChangeListener(this);
        this.infantry.setValue(0);
        this.tanks.setValue(0);
        this.elite.setValue(0);
        this.air.setValue(0);
        this.missiles.setValue(0);
        this.nukes.setValue(0);
        Box vContent = Box.createVerticalBox();
        Box hSliders = Box.createHorizontalBox();
        Box vLabels = Box.createVerticalBox();
        Box vSliders = Box.createVerticalBox();
        Box hButtons = Box.createHorizontalBox();
        hButtons.add(this.send);
        hButtons.add(Box.createHorizontalStrut(10));
        hButtons.add(this.cancel);
        vLabels.add(Box.createVerticalStrut(10));
        vLabels.add(new JLabel("Infantry: "));
        vLabels.add(Box.createVerticalStrut(10));
        vLabels.add(new JLabel("Tanks: "));
        vLabels.add(Box.createVerticalStrut(10));
        vLabels.add(new JLabel("Elites: "));
        vLabels.add(Box.createVerticalStrut(10));
        vLabels.add(new JLabel("Air: "));
        vLabels.add(Box.createVerticalStrut(10));
        vLabels.add(new JLabel("Missiles: "));
        vLabels.add(Box.createVerticalStrut(10));
        vLabels.add(new JLabel("Nukes: "));
        vLabels.add(Box.createVerticalStrut(10));
        vSliders.add(Box.createVerticalStrut(10));
        vSliders.add(this.infantry);
        vSliders.add(Box.createVerticalStrut(10));
        vSliders.add(this.tanks);
        vSliders.add(Box.createVerticalStrut(10));
        vSliders.add(this.elite);
        vSliders.add(Box.createVerticalStrut(10));
        vSliders.add(this.air);
        vSliders.add(Box.createVerticalStrut(10));
        vSliders.add(this.missiles);
        vSliders.add(Box.createVerticalStrut(10));
        vSliders.add(this.nukes);
        vSliders.add(Box.createVerticalStrut(10));
        hSliders.add(Box.createHorizontalStrut(10));
        hSliders.add(vLabels);
        hSliders.add(Box.createHorizontalStrut(25));
        hSliders.add(vSliders);
        hSliders.add(Box.createHorizontalStrut(10));
        vContent.add(hSliders);
        vContent.add(Box.createVerticalStrut(10));
        vContent.add(hButtons);
        this.getContentPane().add(vContent);
    }

    public void setGameState(W6GameState gamestate) {
        this.gs = gamestate;
        this.updateSliderMaxes();
    }

    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o.equals(this.send)) {
            this.executeMove();
            this.exit();
        } else if (o.equals(this.cancel)) {
            this.exit();
        }
    }

    public void stateChanged(ChangeEvent ce) {
        this.updateSliderMaxes();
    }

    public void updateSliderMaxes() {
        if (this.gs != null) {
            int sc = this.gs.selectedCountry;
            this.infantry.setMaximum((int)this.gs.friendlyInfantry[sc]);
            this.tanks.setMaximum((int)this.gs.friendlyTanks[sc]);
            this.elite.setMaximum((int)this.gs.friendlyElite[sc]);
            this.air.setMaximum((int)this.gs.friendlyAir[sc]);
            this.missiles.setMaximum((int)this.gs.friendlyMissiles[sc]);
            this.nukes.setMaximum((int)this.gs.friendlyNukes[sc]);
        }
    }

    public void executeMove() {
        long i = this.infantry.getValue();
        long t = this.tanks.getValue();
        long e = this.elite.getValue();
        long a = this.air.getValue();
        long m = this.missiles.getValue();
        long n = this.nukes.getValue();
        this.hostile = this.gs.countryOwners[this.gs.sourceCountry] != this.gs.countryOwners[this.gs.targetCountry];
        if (this.hostile) {
            this.gs.countryAttacker[this.gs.targetCountry] = this.gs.countryOwners[this.gs.sourceCountry];
            this.gs.enemyInfantry[this.gs.targetCountry] = this.gs.enemyInfantry[this.gs.targetCountry] + i;
            this.gs.enemyTanks[this.gs.targetCountry] = this.gs.enemyTanks[this.gs.targetCountry] + t;
            this.gs.enemyElite[this.gs.targetCountry] = this.gs.enemyElite[this.gs.targetCountry] + e;
            this.gs.enemyAir[this.gs.targetCountry] = this.gs.enemyAir[this.gs.targetCountry] + a;
            this.gs.enemyMissiles[this.gs.targetCountry] = this.gs.enemyMissiles[this.gs.targetCountry] + m;
            this.gs.enemyNukes[this.gs.targetCountry] = this.gs.enemyNukes[this.gs.targetCountry] + n;
        } else {
            this.gs.friendlyInfantry[this.gs.targetCountry] = this.gs.friendlyInfantry[this.gs.targetCountry] + i;
            this.gs.friendlyTanks[this.gs.targetCountry] = this.gs.friendlyTanks[this.gs.targetCountry] + t;
            this.gs.friendlyElite[this.gs.targetCountry] = this.gs.friendlyElite[this.gs.targetCountry] + e;
            this.gs.friendlyAir[this.gs.targetCountry] = this.gs.friendlyAir[this.gs.targetCountry] + a;
            this.gs.friendlyMissiles[this.gs.targetCountry] = this.gs.friendlyMissiles[this.gs.targetCountry] + m;
            this.gs.friendlyNukes[this.gs.targetCountry] = this.gs.friendlyNukes[this.gs.targetCountry] + n;
        }
        this.gs.friendlyInfantry[this.gs.sourceCountry] = this.gs.friendlyInfantry[this.gs.sourceCountry] - i;
        this.gs.friendlyTanks[this.gs.sourceCountry] = this.gs.friendlyTanks[this.gs.sourceCountry] - t;
        this.gs.friendlyElite[this.gs.sourceCountry] = this.gs.friendlyElite[this.gs.sourceCountry] - e;
        this.gs.friendlyAir[this.gs.sourceCountry] = this.gs.friendlyAir[this.gs.sourceCountry] - a;
        this.gs.friendlyMissiles[this.gs.sourceCountry] = this.gs.friendlyMissiles[this.gs.sourceCountry] - m;
        this.gs.friendlyNukes[this.gs.sourceCountry] = this.gs.friendlyNukes[this.gs.sourceCountry] - n;
        this.gw.gs = this.gs;
    }

    public void exit() {
        this.infantry.setValue(0);
        this.tanks.setValue(0);
        this.elite.setValue(0);
        this.air.setValue(0);
        this.missiles.setValue(0);
        this.nukes.setValue(0);
        ((Component)this).setVisible(false);
    }
}

