/*
 * Decompiled with CFR 0.152.
 */
package com.mct.w6;

import com.mct.util.TinGraphicsUtil;
import com.mct.w6.TroopMovement;
import com.mct.w6.W6GameState;
import com.mct.w6.W6MoveTroopsWindow;
import com.mct.w6.W6PurchaseTroopsWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class W6GameWindow
extends JFrame
implements ActionListener,
MouseListener,
MouseMotionListener,
WindowListener {
    W6PurchaseTroopsWindow ptw = new W6PurchaseTroopsWindow(this);
    W6MoveTroopsWindow mtw = new W6MoveTroopsWindow(this);
    JPanel pnMap;
    JPanel pnPowerBar;
    JScrollPane spMapScroller;
    JLabel lbCountryName = new JLabel("[Country Name]");
    JLabel lbPopulation = new JLabel("[Pop]");
    JLabel lbGDP = new JLabel("$[GDP]");
    JLabel lbCash = new JLabel("$[Cash]");
    JLabel fInfantry = new JLabel("fi");
    JLabel fTanks = new JLabel("ft");
    JLabel fElite = new JLabel("fe");
    JLabel fAir = new JLabel("fa");
    JLabel fMissiles = new JLabel("fm");
    JLabel fNukes = new JLabel("fn");
    JLabel eInfantry = new JLabel("ei");
    JLabel eTanks = new JLabel("et");
    JLabel eElite = new JLabel("ee");
    JLabel eAir = new JLabel("ea");
    JLabel eMissiles = new JLabel("em");
    JLabel eNukes = new JLabel("en");
    JList log = new JList();
    JButton buyTroops = new JButton("Purchase Troops");
    Color bumpColor;
    Color frontierColor;
    Color countryColor;
    Color combinedColor;
    static Color selectedColor = Color.yellow;
    int bRgb = Color.black.getRGB();
    int yRgb = Color.yellow.getRGB();
    int n;
    int s;
    int e;
    int w;
    NumberFormat nf = NumberFormat.getInstance();
    boolean mouse_dragging = false;
    Dimension d = new Dimension(100, 100);
    public W6GameState gs;
    Thread dayThread;
    TimerTask waitToSelectCountry;
    TinGraphicsUtil util = new TinGraphicsUtil();

    public W6GameWindow() {
    }

    public W6GameWindow(W6GameState gamestate) {
        this.gs = gamestate;
        this.init();
        this.dayThread.start();
    }

    public void init() {
        ((Component)this).setVisible(true);
        ((Component)this).setSize(300, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(this);
        TinGraphicsUtil.centerFrame(this.mtw);
        TinGraphicsUtil.centerFrame(this.ptw);
        this.nf.setMaximumFractionDigits(0);
        this.dayThread = this.getDayThread();
        this.initUserInterface();
    }

    public void initUserInterface() {
        this.buyTroops.addActionListener(this);
        this.pnMap = this.getMapPanel();
        this.d.setSize(300, 300);
        this.pnMap.setMinimumSize(this.d);
        this.d.setSize(this.gs.onscreen.getWidth(), this.gs.onscreen.getHeight());
        this.pnMap.setMinimumSize(this.d);
        this.pnMap.setPreferredSize(this.d);
        this.pnMap.setMaximumSize(this.d);
        this.pnMap.addMouseListener(this);
        this.pnMap.addMouseMotionListener(this);
        this.selectCountry(this.gs.groupHome[this.gs.humanGroup]);
        this.spMapScroller = this.getMapScroller();
        this.getContentPane().add((Component)this.spMapScroller, "Center");
        this.getContentPane().add((Component)this.getGameInfoContainer(), "South");
    }

    public Thread getDayThread() {
        return new Thread(){

            public void run() {
                super.run();
                if (W6GameWindow.this.gs.secondsPerDay != -1) {
                    while (!W6GameWindow.this.gs.isGameOver()) {
                        if (W6GameWindow.this.gs.isPaused()) continue;
                        try {
                            W6GameWindow.this.setTitle("World War 6 - " + W6GameWindow.this.gs.groupNames[W6GameWindow.this.gs.humanGroup] + " - " + W6GameWindow.this.gs.df.format(W6GameWindow.this.gs.date.getTime()));
                            W6GameWindow.this.gs.runDay();
                            W6GameWindow.this.updateInterface();
                            Thread.sleep(W6GameWindow.this.gs.secondsPerDay * 1000);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (W6GameWindow.this.gs.daysPerSecond != -1) {
                    // empty if block
                }
            }
        };
    }

    public JPanel getMapPanel() {
        return new JPanel(){

            public void paint(Graphics g) {
                g.drawImage(W6GameWindow.this.gs.onscreen, 0, 0, this);
                this.setForeground(Color.yellow);
                if (W6GameWindow.this.gs.selectedCountry > 1) {
                    // empty if block
                }
                int i = 0;
                while (i < W6GameWindow.this.gs.moves.size()) {
                    int src = ((TroopMovement)W6GameWindow.this.gs.moves.elementAt(i)).getSource();
                    int tar = ((TroopMovement)W6GameWindow.this.gs.moves.elementAt(i)).getTarget();
                    int src_cx = W6GameWindow.this.gs.rgbBounds.getX2(src) + (W6GameWindow.this.gs.rgbBounds.getX1(src) - W6GameWindow.this.gs.rgbBounds.getX2(src)) / 2;
                    int src_cy = W6GameWindow.this.gs.rgbBounds.getY2(src) + (W6GameWindow.this.gs.rgbBounds.getY1(src) - W6GameWindow.this.gs.rgbBounds.getY2(src)) / 2;
                    int tar_cx = W6GameWindow.this.gs.rgbBounds.getX2(tar) + (W6GameWindow.this.gs.rgbBounds.getX1(tar) - W6GameWindow.this.gs.rgbBounds.getX2(tar)) / 2;
                    int tar_cy = W6GameWindow.this.gs.rgbBounds.getY2(tar) + (W6GameWindow.this.gs.rgbBounds.getY1(tar) - W6GameWindow.this.gs.rgbBounds.getY2(tar)) / 2;
                    g.drawLine(src_cx, src_cy, tar_cx, tar_cy);
                    ++i;
                }
                W6GameWindow.this.gs.moves.clear();
                if (W6GameWindow.this.mouse_dragging) {
                    g.drawLine(W6GameWindow.this.gs.humanAttackX1, W6GameWindow.this.gs.humanAttackY1, W6GameWindow.this.gs.humanAttackX2, W6GameWindow.this.gs.humanAttackY2);
                    g.drawString(W6GameWindow.this.gs.mouseOverSourceCountryName, W6GameWindow.this.gs.humanAttackX1, W6GameWindow.this.gs.humanAttackY1);
                    g.drawString(W6GameWindow.this.gs.mouseOverTargetCountryName, W6GameWindow.this.gs.humanAttackX2, W6GameWindow.this.gs.humanAttackY2);
                }
            }

            public void update(Graphics g) {
                this.setForeground(Color.yellow);
                g.drawImage(W6GameWindow.this.gs.onscreen, 0, 0, this);
            }
        };
    }

    public JScrollPane getMapScroller() {
        JScrollPane spms = new JScrollPane(this.pnMap);
        spms.getHorizontalScrollBar().setUnitIncrement(this.gs.onscreen.getWidth() >> 10);
        spms.getVerticalScrollBar().setUnitIncrement(this.gs.onscreen.getHeight() >> 10);
        spms.setAutoscrolls(true);
        this.d.setSize(this.gs.onscreen.getWidth(), this.gs.onscreen.getHeight());
        spms.setPreferredSize(this.d);
        return spms;
    }

    public JPanel getGameInfoContainer() {
        JPanel gic = new JPanel();
        gic.setLayout(new BorderLayout());
        this.pnPowerBar = this.getPowerBarPanel();
        gic.add((Component)this.getGameInfoPanel(), "Center");
        gic.add((Component)this.pnPowerBar, "South");
        return gic;
    }

    public JPanel getGameInfoPanel() {
        JPanel gip = new JPanel();
        gip.setLayout(new GridLayout(1, 2));
        gip.add(this.getTabbedStatusPanel());
        gip.add(this.getWorldWideLog());
        return gip;
    }

    public JTabbedPane getTabbedStatusPanel() {
        JTabbedPane tsp = new JTabbedPane();
        tsp.setMaximumSize(new Dimension(200, 200));
        tsp.addTab("Domestic", this.getDomesticTab());
        tsp.addTab("Military", this.getMilitaryTab());
        return tsp;
    }

    public JPanel getDomesticTab() {
        JPanel dt = new JPanel();
        Box hBox = Box.createHorizontalBox();
        Box vBox = Box.createVerticalBox();
        Box vOwner = Box.createVerticalBox();
        Box hPopulation = Box.createHorizontalBox();
        Box hGDP = Box.createHorizontalBox();
        Box hCash = Box.createHorizontalBox();
        hCash.add(Box.createHorizontalStrut(10));
        hPopulation.add(new JLabel("Population: "));
        hCash.add(Box.createHorizontalStrut(10));
        hPopulation.add(this.lbPopulation);
        hCash.add(Box.createHorizontalStrut(10));
        hCash.add(Box.createHorizontalStrut(10));
        hGDP.add(new JLabel("GDP: "));
        hCash.add(Box.createHorizontalStrut(10));
        hGDP.add(this.lbGDP);
        hCash.add(Box.createHorizontalStrut(10));
        hCash.add(Box.createHorizontalStrut(10));
        hCash.add(new JLabel("Cash: "));
        hCash.add(Box.createHorizontalStrut(10));
        hCash.add(this.lbCash);
        hCash.add(Box.createHorizontalStrut(10));
        vBox.add(Box.createVerticalStrut(10));
        vBox.add(this.lbCountryName);
        vBox.add(Box.createVerticalStrut(10));
        vBox.add(hPopulation);
        vBox.add(Box.createVerticalStrut(10));
        vBox.add(hGDP);
        vBox.add(Box.createVerticalStrut(10));
        vBox.add(hCash);
        vBox.add(Box.createVerticalStrut(10));
        hBox.add(vBox);
        hBox.add(vOwner);
        dt.add(hBox);
        return dt;
    }

    public JPanel getMilitaryTab() {
        JPanel mp = new JPanel();
        Box vBox = Box.createVerticalBox();
        Box hBox = Box.createHorizontalBox();
        Box vTroops = Box.createVerticalBox();
        Box vProjectiles = Box.createVerticalBox();
        Box hInfantry = Box.createHorizontalBox();
        Box hTanks = Box.createHorizontalBox();
        Box hElite = Box.createHorizontalBox();
        Box hAir = Box.createHorizontalBox();
        Box hMissiles = Box.createHorizontalBox();
        Box hNukes = Box.createHorizontalBox();
        hInfantry.add(Box.createHorizontalStrut(10));
        hInfantry.add(new JLabel("Infantry: "));
        hInfantry.add(Box.createHorizontalStrut(10));
        hInfantry.add(this.fInfantry);
        hInfantry.add(Box.createHorizontalStrut(10));
        hInfantry.add(this.eInfantry);
        hTanks.add(Box.createHorizontalStrut(10));
        hTanks.add(new JLabel("Tanks: "));
        hTanks.add(Box.createHorizontalStrut(10));
        hTanks.add(this.fTanks);
        hTanks.add(Box.createHorizontalStrut(10));
        hTanks.add(this.eTanks);
        hElite.add(Box.createHorizontalStrut(10));
        hElite.add(new JLabel("Elites: "));
        hElite.add(Box.createHorizontalStrut(10));
        hElite.add(this.fElite);
        hElite.add(Box.createHorizontalStrut(10));
        hElite.add(this.eElite);
        hAir.add(Box.createHorizontalStrut(10));
        hAir.add(new JLabel("Air: "));
        hAir.add(Box.createHorizontalStrut(10));
        hAir.add(this.fAir);
        hAir.add(Box.createHorizontalStrut(10));
        hAir.add(this.eAir);
        hMissiles.add(Box.createHorizontalStrut(10));
        hMissiles.add(new JLabel("Missiles: "));
        hMissiles.add(Box.createHorizontalStrut(10));
        hMissiles.add(this.fMissiles);
        hMissiles.add(Box.createHorizontalStrut(10));
        hMissiles.add(this.eMissiles);
        hNukes.add(Box.createHorizontalStrut(10));
        hNukes.add(new JLabel("Nukes: "));
        hNukes.add(Box.createHorizontalStrut(10));
        hNukes.add(this.fNukes);
        hNukes.add(Box.createHorizontalStrut(10));
        hNukes.add(this.eNukes);
        vTroops.add(Box.createVerticalStrut(10));
        vTroops.add(hInfantry);
        vTroops.add(Box.createVerticalStrut(10));
        vTroops.add(hTanks);
        vTroops.add(Box.createVerticalStrut(10));
        vTroops.add(hElite);
        vTroops.add(Box.createVerticalStrut(10));
        vProjectiles.add(Box.createVerticalStrut(10));
        vProjectiles.add(hAir);
        vProjectiles.add(Box.createVerticalStrut(10));
        vProjectiles.add(hMissiles);
        vProjectiles.add(Box.createVerticalStrut(10));
        vProjectiles.add(hNukes);
        vProjectiles.add(Box.createVerticalStrut(10));
        hBox.add(vTroops);
        hBox.add(Box.createHorizontalStrut(50));
        hBox.add(vProjectiles);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(10));
        vBox.add(this.buyTroops);
        mp.add(vBox);
        return mp;
    }

    public JScrollPane getWorldWideLog() {
        this.gs.logData.add("World War 6 Starts...");
        this.log.setListData(this.gs.logData);
        JScrollPane listHolder = new JScrollPane(this.log);
        listHolder.setAutoscrolls(true);
        return listHolder;
    }

    public JPanel getPowerBarPanel() {
        return new JPanel(){

            public void paint(Graphics g) {
                int x = 0;
                int i = 0;
                while (i < W6GameWindow.this.gs.groupCount) {
                    if (!W6GameWindow.this.gs.isGroupFake(i)) {
                        Color temp = new Color(W6GameWindow.this.gs.groupRed[i], W6GameWindow.this.gs.groupGreen[i], W6GameWindow.this.gs.groupBlue[i]);
                        int w = (int)(1.0 * (double)W6GameWindow.this.gs.territoryCount[i] / (1.0 * (double)(W6GameWindow.this.gs.countryCount - W6GameWindow.this.gs.fakeCount)) * (double)this.getWidth());
                        g.setPaintMode();
                        g.setColor(temp);
                        g.fillRect(x, 0, w, 10);
                        g.setColor(Color.black);
                        g.drawLine(x += w, 0, x, 10);
                        ++x;
                    }
                    ++i;
                }
            }
        };
    }

    public void updateInterface() {
        this.updateInfo();
        this.updateMap();
        this.pnPowerBar.repaint();
    }

    public void redrawCountry(int redrawCID) {
        int startx = this.gs.rgbBounds.X1[redrawCID];
        int endx = this.gs.rgbBounds.X2[redrawCID];
        int starty = this.gs.rgbBounds.Y1[redrawCID];
        int endy = this.gs.rgbBounds.Y2[redrawCID];
        Color groupColor = new Color(this.gs.groupRed[this.gs.countryOwners[redrawCID]], this.gs.groupGreen[this.gs.countryOwners[redrawCID]], this.gs.groupBlue[this.gs.countryOwners[redrawCID]]);
        Color countryColor = new Color(redrawCID, redrawCID, redrawCID);
        int x = endx;
        while (x < startx) {
            int y = endy;
            while (y < starty) {
                Color frontierPixel = new Color(this.gs.frontiers.getRGB(x, y));
                if (frontierPixel.getRGB() == countryColor.getRGB()) {
                    Color bumpyPixel = new Color(this.gs.bumps.getRGB(x, y));
                    int nr = (bumpyPixel.getRed() + groupColor.getRed()) / 2;
                    int ng = (bumpyPixel.getGreen() + groupColor.getGreen()) / 2;
                    int nb = (bumpyPixel.getBlue() + groupColor.getBlue()) / 2;
                    Color combinedPixel = new Color(nr, ng, nb);
                    this.gs.onscreen.setRGB(x, y, combinedPixel.getRGB());
                }
                ++y;
            }
            ++x;
        }
        this.pnMap.repaint();
        if (this.gs.selectedCountry == redrawCID) {
            this.selectCountry(this.gs.selectedCountry);
        }
    }

    public void updateMap() {
        Enumeration e = this.gs.countryRedraws.elements();
        while (e.hasMoreElements()) {
            this.redrawCountry((Integer)e.nextElement());
        }
        this.gs.countryRedraws = new Vector();
        this.pnMap.repaint();
    }

    private void updateInfo() {
        int sc = this.gs.selectedCountry;
        this.lbCountryName.setText(this.gs.countryNames[sc]);
        this.lbPopulation.setText(this.nf.format(this.gs.countryPops[sc]));
        this.lbCash.setText("$" + this.nf.format(this.gs.countryCash[sc]));
        this.lbGDP.setText("$" + this.nf.format(this.gs.countryGDPs[sc]) + " ea. month");
        this.fInfantry.setText(this.nf.format(this.gs.friendlyInfantry[sc]));
        this.fTanks.setText(this.nf.format(this.gs.friendlyTanks[sc]));
        this.fElite.setText(this.nf.format(this.gs.friendlyElite[sc]));
        this.fAir.setText(this.nf.format(this.gs.friendlyAir[sc]));
        this.fMissiles.setText(this.nf.format(this.gs.friendlyMissiles[sc]));
        this.fNukes.setText(this.nf.format(this.gs.friendlyNukes[sc]));
        this.eInfantry.setText("(" + this.nf.format(this.gs.enemyInfantry[sc]) + ")");
        this.eTanks.setText("(" + this.nf.format(this.gs.enemyTanks[sc]) + ")");
        this.eElite.setText("(" + this.nf.format(this.gs.enemyElite[sc]) + ")");
        this.eAir.setText("(" + this.nf.format(this.gs.enemyAir[sc]) + ")");
        this.eMissiles.setText("(" + this.nf.format(this.gs.enemyMissiles[sc]) + ")");
        this.eNukes.setText("(" + this.nf.format(this.gs.enemyNukes[sc]) + ")");
        if (this.gs.countryOwners[this.gs.selectedCountry] == this.gs.humanGroup) {
            this.buyTroops.setEnabled(true);
        } else {
            this.buyTroops.setEnabled(false);
        }
        this.log.setListData(this.flipLog());
    }

    public Vector flipLog() {
        Vector v = new Vector();
        int i = this.gs.logData.size() - 1;
        while (i >= 0) {
            v.add(this.gs.logData.elementAt(i));
            --i;
        }
        return v;
    }

    private void selectCountry(int cid) {
        if (this.gs.selectedCountry > 1) {
            this.deselectCountry();
        }
        int SELECTED_BORDER_WIDTH = 2;
        Color countryColor = new Color(cid, cid, cid);
        int xmin = 2500000;
        int ymin = 2500000;
        int xmax = 0;
        int ymax = 0;
        this.gs.selectedCountry = cid;
        int x = this.gs.rgbBounds.X2[cid];
        while (x < this.gs.rgbBounds.X1[cid]) {
            int y = this.gs.rgbBounds.Y2[cid];
            while (y < this.gs.rgbBounds.Y1[cid]) {
                Color frontierColor = new Color(this.gs.frontiers.getRGB(x, y));
                if (countryColor.getRGB() == frontierColor.getRGB()) {
                    if (x < xmin) {
                        xmin = x;
                    }
                    if (y < ymin) {
                        ymin = y;
                    }
                    if (x > xmax) {
                        xmax = x;
                    }
                    if (y > ymax) {
                        ymax = y;
                    }
                    this.n = this.gs.frontiers.getRGB(x, y + 1);
                    this.s = this.gs.frontiers.getRGB(x, y - 1);
                    this.e = this.gs.frontiers.getRGB(x + 1, y);
                    this.w = this.gs.frontiers.getRGB(x - 1, y);
                    if (this.bRgb == this.n) {
                        int i = 0;
                        while (i < SELECTED_BORDER_WIDTH) {
                            if (this.gs.onscreen.getRGB(x, y - i) != this.bRgb) {
                                this.gs.onscreen.setRGB(x, y - i, this.yRgb);
                            }
                            ++i;
                        }
                    }
                    if (this.bRgb == this.s) {
                        int i = 0;
                        while (i < SELECTED_BORDER_WIDTH) {
                            if (this.gs.onscreen.getRGB(x, y + i) != this.bRgb) {
                                this.gs.onscreen.setRGB(x, y + i, this.yRgb);
                            }
                            ++i;
                        }
                    }
                    if (this.bRgb == this.e) {
                        int i = 0;
                        while (i < SELECTED_BORDER_WIDTH) {
                            if (this.gs.onscreen.getRGB(x - i, y) != this.bRgb) {
                                this.gs.onscreen.setRGB(x - i, y, this.yRgb);
                            }
                            ++i;
                        }
                    }
                    if (this.bRgb == this.w) {
                        int i = 0;
                        while (i < SELECTED_BORDER_WIDTH) {
                            if (this.gs.onscreen.getRGB(x + i, y) != this.bRgb) {
                                this.gs.onscreen.setRGB(x + i, y, this.yRgb);
                            }
                            ++i;
                        }
                    }
                }
                ++y;
            }
            ++x;
        }
        this.updateInfo();
        this.pnMap.repaint();
    }

    private void deselectCountry() {
        int gid = this.gs.countryOwners[this.gs.selectedCountry];
        int SELECTED_BORDER_WIDTH = 2;
        Color selectedBorderColor = Color.yellow;
        Color countryColor = new Color(this.gs.selectedCountry, this.gs.selectedCountry, this.gs.selectedCountry);
        Color border = Color.black;
        Color groupColor = new Color(this.gs.groupRed[gid], this.gs.groupGreen[gid], this.gs.groupBlue[gid]);
        int xmin = 2500000;
        int ymin = 2500000;
        int xmax = 0;
        int ymax = 0;
        int x = this.gs.rgbBounds.X2[this.gs.selectedCountry];
        while (x < this.gs.rgbBounds.X1[this.gs.selectedCountry]) {
            int y = this.gs.rgbBounds.Y2[this.gs.selectedCountry];
            while (y < this.gs.rgbBounds.Y1[this.gs.selectedCountry]) {
                Color temp = new Color(this.gs.frontiers.getRGB(x, y));
                if (temp.getRGB() == countryColor.getRGB()) {
                    int i;
                    if (x < xmin) {
                        xmin = x;
                    }
                    if (y < ymin) {
                        ymin = y;
                    }
                    if (x > xmax) {
                        xmax = x;
                    }
                    if (y > ymax) {
                        ymax = y;
                    }
                    int n = this.gs.frontiers.getRGB(x, y + 1);
                    int s = this.gs.frontiers.getRGB(x, y - 1);
                    int e = this.gs.frontiers.getRGB(x + 1, y);
                    int w = this.gs.frontiers.getRGB(x - 1, y);
                    int b = border.getRGB();
                    if (b == n) {
                        i = 0;
                        while (i < SELECTED_BORDER_WIDTH) {
                            if (this.gs.onscreen.getRGB(x, y - i) != b) {
                                this.bumpColor = new Color(this.gs.bumps.getRGB(x, y - i));
                                this.combinedColor = new Color((this.bumpColor.getRed() + groupColor.getRed()) / 2, (this.bumpColor.getGreen() + groupColor.getGreen()) / 2, (this.bumpColor.getBlue() + groupColor.getBlue()) / 2);
                                this.gs.onscreen.setRGB(x, y - i, this.combinedColor.getRGB());
                            }
                            ++i;
                        }
                    }
                    if (b == s) {
                        i = 0;
                        while (i < SELECTED_BORDER_WIDTH) {
                            if (this.gs.onscreen.getRGB(x, y + i) != b) {
                                this.bumpColor = new Color(this.gs.bumps.getRGB(x, y + i));
                                this.combinedColor = new Color((this.bumpColor.getRed() + groupColor.getRed()) / 2, (this.bumpColor.getGreen() + groupColor.getGreen()) / 2, (this.bumpColor.getBlue() + groupColor.getBlue()) / 2);
                                this.gs.onscreen.setRGB(x, y + i, this.combinedColor.getRGB());
                            }
                            ++i;
                        }
                    }
                    if (b == e) {
                        i = 0;
                        while (i < SELECTED_BORDER_WIDTH) {
                            if (this.gs.onscreen.getRGB(x - i, y) != b) {
                                this.bumpColor = new Color(this.gs.bumps.getRGB(x - i, y));
                                this.combinedColor = new Color((this.bumpColor.getRed() + groupColor.getRed()) / 2, (this.bumpColor.getGreen() + groupColor.getGreen()) / 2, (this.bumpColor.getBlue() + groupColor.getBlue()) / 2);
                                this.gs.onscreen.setRGB(x - i, y, this.combinedColor.getRGB());
                            }
                            ++i;
                        }
                    }
                    if (b == w) {
                        i = 0;
                        while (i < SELECTED_BORDER_WIDTH) {
                            if (this.gs.onscreen.getRGB(x + i, y) != b) {
                                this.bumpColor = new Color(this.gs.bumps.getRGB(x + i, y));
                                this.combinedColor = new Color((this.bumpColor.getRed() + groupColor.getRed()) / 2, (this.bumpColor.getGreen() + groupColor.getGreen()) / 2, (this.bumpColor.getBlue() + groupColor.getBlue()) / 2);
                                this.gs.onscreen.setRGB(x + i, y, this.combinedColor.getRGB());
                            }
                            ++i;
                        }
                    }
                }
                ++y;
            }
            ++x;
        }
        this.pnMap.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource().equals(this.buyTroops)) {
            this.ptw.setGameState(this.gs);
            ((Component)this.ptw).setVisible(true);
        }
    }

    public void mouseClicked(MouseEvent me) {
        Color c;
        int cid;
        if (me.getSource() == this.pnMap && (cid = (c = new Color(this.gs.frontiers.getRGB(me.getX(), me.getY()))).getRed()) > 1) {
            this.selectCountry(cid);
        }
    }

    public void mousePressed(MouseEvent me) {
        int countryID = 0;
        Timer t = new Timer();
        this.waitToSelectCountry = new TimerTask(){

            public void run() {
            }
        };
        t.schedule(this.waitToSelectCountry, 500L);
        this.gs.humanAttackX1 = me.getX();
        this.gs.humanAttackY1 = me.getY();
        this.gs.humanAttackX2 = me.getX();
        this.gs.humanAttackY2 = me.getY();
        this.gs.sourceCountry = countryID = new Color(this.gs.frontiers.getRGB(me.getX(), me.getY())).getRed();
        this.gs.mouseOverSourceCountryName = this.gs.countryNames[countryID];
    }

    public void mouseReleased(MouseEvent me) {
        if (this.mouse_dragging) {
            if (this.gs.countryOwners[this.gs.sourceCountry] == this.gs.humanGroup) {
                this.gs.targetCountry = new Color(this.gs.frontiers.getRGB(me.getX(), me.getY())).getRed();
                if (!(this.gs.isGroupFake(this.gs.targetCountry) || this.gs.sourceCountry == this.gs.targetCountry || this.gs.countryAttacker[this.gs.targetCountry] != this.gs.sourceCountry && this.gs.countryAttacker[this.gs.targetCountry] != -1)) {
                    this.mtw.setGameState(this.gs);
                    ((Component)this.mtw).setVisible(true);
                }
            }
            this.gs.humanAttackX1 = 0;
            this.gs.humanAttackX2 = 0;
            this.gs.humanAttackY1 = 0;
            this.gs.humanAttackY2 = 0;
            this.gs.mouseOverTargetCountryName = "";
            this.gs.mouseOverSourceCountryName = "";
            this.pnMap.repaint();
            this.mouse_dragging = false;
        }
    }

    public void mouseDragged(MouseEvent me) {
        this.mouse_dragging = true;
        if (me.getX() > 0 && me.getY() > 0) {
            int increment;
            this.gs.humanAttackX2 = me.getX();
            this.gs.humanAttackY2 = me.getY();
            this.pnMap.repaint();
            if ((double)me.getX() * 1.0 / (double)(this.spMapScroller.getWidth() + this.spMapScroller.getHorizontalScrollBar().getValue()) >= 0.9) {
                increment = (int)((double)this.spMapScroller.getWidth() * 0.01);
                this.spMapScroller.getHorizontalScrollBar().setValue(this.spMapScroller.getHorizontalScrollBar().getValue() + 1 + increment);
            } else if (((double)me.getX() - (double)this.spMapScroller.getHorizontalScrollBar().getValue() * 1.0) / (double)this.spMapScroller.getWidth() <= 0.1) {
                increment = (int)((double)this.spMapScroller.getWidth() * 0.01);
                this.spMapScroller.getHorizontalScrollBar().setValue(this.spMapScroller.getHorizontalScrollBar().getValue() - 1 - increment);
            }
            if ((double)me.getY() * 1.0 / (double)(this.spMapScroller.getHeight() + this.spMapScroller.getVerticalScrollBar().getValue()) >= 0.9) {
                increment = (int)((double)this.spMapScroller.getWidth() * 0.01);
                this.spMapScroller.getVerticalScrollBar().setValue(this.spMapScroller.getVerticalScrollBar().getValue() + 1 + increment);
            } else if (((double)me.getY() - (double)this.spMapScroller.getVerticalScrollBar().getValue() * 1.0) / (double)this.spMapScroller.getHeight() <= 0.1) {
                increment = (int)((double)this.spMapScroller.getWidth() * 0.01);
                this.spMapScroller.getVerticalScrollBar().setValue(this.spMapScroller.getVerticalScrollBar().getValue() - 1 - increment);
            }
            int mouseOver_cid = new Color(this.gs.frontiers.getRGB(me.getX(), me.getY())).getRed();
            this.gs.mouseOverTargetCountryName = this.gs.isGroupFake(mouseOver_cid) ? "" : this.gs.countryNames[mouseOver_cid];
            this.pnMap.repaint();
        }
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void windowActivated(WindowEvent we) {
    }

    public void windowClosed(WindowEvent we) {
    }

    public void windowClosing(WindowEvent we) {
    }

    public void windowDeactivated(WindowEvent we) {
    }

    public void windowDeiconified(WindowEvent we) {
    }

    public void windowIconified(WindowEvent we) {
    }

    public void windowOpened(WindowEvent we) {
    }
}

