/*
 * Decompiled with CFR 0.152.
 */
package com.mct.w6;

import com.mct.w6.RgbBoundsCollection;
import com.mct.w6.TroopMovement;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Random;
import java.util.Vector;

public class W6GameState {
    public int humanGroup = -1;
    public DateFormat df = DateFormat.getDateInstance(3);
    public boolean paused = false;
    public boolean gameover = false;
    Random r = new Random();
    public int secondsPerDay = 2;
    public int daysPerSecond = -1;
    public int humanAttackCount = 0;
    public int computerAttackCount = 0;
    public int humanAttackX1 = 0;
    public int humanAttackX2 = 0;
    public int humanAttackY1 = 0;
    public int humanAttackY2 = 0;
    public int sourceCountry;
    public int targetCountry;
    public Vector moves = new Vector();
    public Vector countryRedraws = new Vector();
    public Vector logData = new Vector();
    public RgbBoundsCollection rgbBounds = new RgbBoundsCollection();
    public int selectedCountry = 0;
    public Polygon selectedCountryOutline;
    public int sourcex = 0;
    public int sourcey = 0;
    public String mouseOverSourceCountryName = "";
    public String mouseOverTargetCountryName = "";
    public int year;
    public int month;
    public int day;
    public Calendar date;
    public int lastMonth;
    public int groupsLeft;
    public int countryCount;
    public int groupCount;
    public int fakeCount;
    public int neutralCount;
    public int[] fakeGroups;
    public int[] neutralGroups;
    public String[] groupNames;
    public int[] groupPolitics;
    public int[] groupRed;
    public int[] groupGreen;
    public int[] groupBlue;
    public int[] groupHome;
    public String[] countryNames;
    public int[] countryOwners;
    public int[] countryAttacker;
    public long[] countryPops;
    public long[] countryGDPs;
    public long[] countryCash;
    public long[] friendlyInfantry;
    public long[] friendlyTanks;
    public long[] friendlyElite;
    public long[] friendlyAir;
    public long[] friendlyMissiles;
    public long[] friendlyNukes;
    public long[] enemyInfantry;
    public long[] enemyTanks;
    public long[] enemyElite;
    public long[] enemyAir;
    public long[] enemyMissiles;
    public long[] enemyNukes;
    public int[] territoryCount;
    public int infantryCost = 1;
    public int tankCost = 5;
    public int eliteCost = 20;
    public int airCost = 250;
    public int missileCost = 500;
    public int nukeCost = 1000;
    public BufferedImage frontiers;
    public BufferedImage bumps;
    public BufferedImage onscreen;

    public W6GameState(int c, int g) {
        this.countryCount = c;
        this.groupCount = g;
        this.init();
    }

    public W6GameState(int c, int g, int f, int n) {
        this.countryCount = c;
        this.groupCount = g;
        this.fakeCount = f;
        this.neutralCount = n;
        this.init();
    }

    private void init() {
        this.date = Calendar.getInstance();
        this.groupsLeft = this.groupCount - this.fakeCount;
        this.fakeGroups = new int[this.fakeCount];
        this.neutralGroups = new int[this.neutralCount];
        this.countryNames = new String[this.countryCount];
        this.countryOwners = new int[this.countryCount];
        this.countryAttacker = new int[this.countryCount];
        this.countryPops = new long[this.countryCount];
        this.countryGDPs = new long[this.countryCount];
        this.countryCash = new long[this.countryCount];
        this.friendlyInfantry = new long[this.countryCount];
        this.friendlyTanks = new long[this.countryCount];
        this.friendlyElite = new long[this.countryCount];
        this.friendlyAir = new long[this.countryCount];
        this.friendlyMissiles = new long[this.countryCount];
        this.friendlyNukes = new long[this.countryCount];
        this.enemyInfantry = new long[this.countryCount];
        this.enemyTanks = new long[this.countryCount];
        this.enemyElite = new long[this.countryCount];
        this.enemyAir = new long[this.countryCount];
        this.enemyMissiles = new long[this.countryCount];
        this.enemyNukes = new long[this.countryCount];
        this.groupNames = new String[this.groupCount];
        this.groupPolitics = new int[this.groupCount];
        this.groupRed = new int[this.groupCount];
        this.groupGreen = new int[this.groupCount];
        this.groupBlue = new int[this.groupCount];
        this.groupHome = new int[this.groupCount];
        this.territoryCount = new int[this.groupCount];
        int i = 0;
        while (i < this.groupCount) {
            this.territoryCount[i] = 0;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.countryCount) {
            this.countryAttacker[i2] = -1;
            ++i2;
        }
        this.selectedCountryOutline = new Polygon();
    }

    public void spawnArmy(int c) {
        this.friendlyInfantry[c] = this.countryGDPs[c] / 1L;
        this.friendlyTanks[c] = this.countryGDPs[c] / 10L;
        this.friendlyElite[c] = this.countryGDPs[c] / 50L;
        this.friendlyAir[c] = this.countryGDPs[c] / 500L;
        this.friendlyMissiles[c] = this.countryGDPs[c] / 450L;
        this.friendlyNukes[c] = this.countryGDPs[c] / 1000L;
    }

    public boolean isGroupFake(int g) {
        int i = 0;
        while (i < this.fakeCount) {
            if (g == this.fakeGroups[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isGroupNeutral(int g) {
        int i = 0;
        while (i < this.neutralCount) {
            if (this.neutralGroups[i] == g) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isGroupHuman(int g) {
        return g == this.humanGroup;
    }

    public static int random(int n) {
        return (int)(Math.random() * (double)n + 1.0);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPause(boolean val) {
        this.paused = val;
    }

    public boolean isGameOver() {
        return this.gameover;
    }

    public void runDay() {
        this.date.roll(6, 1);
        if (this.date.get(6) == 365) {
            this.date.roll(1, 1);
        }
        this.updateCash();
        this.updateBattles();
        this.updateTerritoryCount();
        this.spawnNewAttacks();
    }

    private void updateCash() {
        if (this.lastMonth != this.date.get(2)) {
            int i = 0;
            while (i < this.countryCount) {
                this.countryCash[i] = this.countryCash[i] + this.countryGDPs[i];
                ++i;
            }
            this.purchaseTroops();
            this.lastMonth = this.date.get(2);
        }
    }

    private void updateBattles() {
        int i = 0;
        while (i < this.countryCount) {
            if (this.countryAttacker[i] != -1) {
                boolean no_enemy_infantry = false;
                long enemy_infantry_lost = 0L;
                long enemy_elite_lost = 0L;
                long enemy_tanks_lost = 0L;
                long enemy_airForce_lost = 0L;
                long enemy_missiles_lost = 0L;
                long enemy_nukes_lost = 0L;
                long friendly_infantry_lost = 0L;
                long friendly_elite_lost = 0L;
                long friendly_tanks_lost = 0L;
                long friendly_airForce_lost = 0L;
                long friendly_missiles_lost = 0L;
                long friendly_nukes_lost = 0L;
                Random rand = new Random(System.currentTimeMillis());
                int r = rand.nextInt();
                if (this.enemyAir[i] > 0L && this.enemyAir[i] >= 100L) {
                    if (this.friendlyAir[i] > 0L) {
                        enemy_airForce_lost += (long)((double)this.friendlyAir[i] * 0.07);
                        friendly_airForce_lost += (long)((double)this.enemyAir[i] * 0.05);
                    } else if (this.friendlyTanks[i] > 0L) {
                        enemy_airForce_lost += (long)((double)this.friendlyTanks[i] * 0.01);
                        friendly_tanks_lost += (long)((double)this.enemyAir[i] * 0.07);
                    } else if (this.friendlyElite[i] > 0L) {
                        enemy_airForce_lost += (long)((double)this.friendlyElite[i] * 0.02);
                        friendly_elite_lost += (long)((double)this.enemyAir[i] * 0.01);
                    } else if (this.friendlyInfantry[i] > 0L) {
                        enemy_airForce_lost += (long)((double)this.friendlyInfantry[i] * 0.01);
                        friendly_infantry_lost += (long)((double)this.enemyAir[i] * 0.15);
                    }
                }
                if (this.enemyTanks[i] > 0L && this.enemyTanks[i] >= 100L) {
                    if (this.friendlyAir[i] > 0L) {
                        enemy_tanks_lost += (long)((double)this.friendlyAir[i] * 0.07);
                        friendly_airForce_lost += (long)((double)this.enemyTanks[i] * 0.01);
                    } else if (this.friendlyTanks[i] > 0L) {
                        enemy_tanks_lost += (long)((double)this.friendlyTanks[i] * 0.05);
                        friendly_tanks_lost += (long)((double)this.enemyTanks[i] * 0.04);
                    } else if (this.friendlyElite[i] > 0L) {
                        enemy_tanks_lost += (long)((double)this.friendlyElite[i] * 0.03);
                        friendly_elite_lost += (long)((double)this.enemyTanks[i] * 0.05);
                    } else if (this.friendlyInfantry[i] > 0L) {
                        enemy_tanks_lost += (long)((double)this.friendlyInfantry[i] * 0.02);
                        friendly_infantry_lost += (long)((double)this.enemyTanks[i] * 0.05);
                    }
                }
                if (this.enemyElite[i] > 0L && this.enemyElite[i] >= 100L) {
                    if (this.friendlyAir[i] > 0L) {
                        enemy_elite_lost += (long)((double)this.friendlyAir[i] * 0.02);
                        friendly_airForce_lost += (long)((double)this.enemyElite[i] * 0.01);
                    } else if (this.friendlyTanks[i] > 0L) {
                        enemy_elite_lost += (long)((double)this.friendlyTanks[i] * 0.07);
                        friendly_tanks_lost += (long)((double)this.enemyElite[i] * 0.03);
                    } else if (this.friendlyElite[i] > 0L) {
                        enemy_elite_lost += (long)((double)this.friendlyElite[i] * 0.02);
                        friendly_elite_lost += (long)((double)this.enemyElite[i] * 0.01);
                    } else if (this.friendlyInfantry[i] > 0L) {
                        enemy_elite_lost += (long)((double)this.friendlyInfantry[i] * 0.01);
                        friendly_infantry_lost += (long)((double)this.enemyElite[i] * 0.1);
                    }
                }
                if (this.enemyInfantry[i] > 0L && this.enemyInfantry[i] >= 100L) {
                    if (this.friendlyAir[i] > 0L) {
                        enemy_infantry_lost += (long)((double)this.friendlyAir[i] * 0.75);
                        friendly_airForce_lost += (long)((double)this.enemyInfantry[i] * 0.01);
                    } else if (this.friendlyTanks[i] > 0L) {
                        enemy_infantry_lost += (long)((double)this.friendlyTanks[i] * 0.5);
                        friendly_tanks_lost += (long)((double)this.enemyInfantry[i] * 0.01);
                    } else if (this.friendlyElite[i] > 0L) {
                        enemy_infantry_lost += (long)((double)this.friendlyElite[i] * 15.0);
                        friendly_elite_lost += (long)((double)this.enemyInfantry[i] * 0.005);
                    } else if (this.friendlyInfantry[i] > 0L) {
                        enemy_infantry_lost += (long)((double)this.friendlyInfantry[i] * 0.2);
                        friendly_infantry_lost += (long)((double)this.enemyInfantry[i] * 0.01);
                    }
                }
                if (this.enemyAir[i] > 0L && this.enemyAir[i] < 100L) {
                    if (this.friendlyAir[i] > 0L) {
                        enemy_airForce_lost += (long)W6GameState.random(7);
                        friendly_airForce_lost += (long)W6GameState.random(5);
                    } else if (this.friendlyTanks[i] > 0L) {
                        enemy_airForce_lost += (long)W6GameState.random(1);
                        friendly_tanks_lost += (long)W6GameState.random(7);
                    } else if (this.friendlyElite[i] > 0L) {
                        enemy_airForce_lost += (long)W6GameState.random(2);
                        friendly_elite_lost += (long)W6GameState.random(1);
                    } else if (this.friendlyInfantry[i] > 0L) {
                        enemy_airForce_lost += (long)W6GameState.random(1);
                        friendly_infantry_lost += (long)W6GameState.random(15);
                    }
                }
                if (this.enemyTanks[i] > 0L && this.enemyTanks[i] < 100L) {
                    if (this.friendlyAir[i] > 0L) {
                        enemy_tanks_lost += (long)W6GameState.random(7);
                        friendly_airForce_lost += (long)W6GameState.random(1);
                    } else if (this.friendlyTanks[i] > 0L) {
                        enemy_tanks_lost += (long)W6GameState.random(5);
                        friendly_tanks_lost += (long)W6GameState.random(4);
                    } else if (this.friendlyElite[i] > 0L) {
                        enemy_tanks_lost += (long)W6GameState.random(3);
                        friendly_elite_lost += (long)W6GameState.random(5);
                    } else if (this.friendlyInfantry[i] > 0L) {
                        enemy_tanks_lost += (long)W6GameState.random(2);
                        friendly_infantry_lost += (long)W6GameState.random(5);
                    }
                }
                if (this.enemyElite[i] > 0L && this.enemyElite[i] < 100L) {
                    if (this.friendlyAir[i] > 0L) {
                        enemy_elite_lost += (long)W6GameState.random(2);
                        friendly_airForce_lost += (long)W6GameState.random(1);
                    } else if (this.friendlyTanks[i] > 0L) {
                        enemy_elite_lost += (long)W6GameState.random(7);
                        friendly_tanks_lost += (long)W6GameState.random(3);
                    } else if (this.friendlyElite[i] > 0L) {
                        enemy_elite_lost += (long)W6GameState.random(2);
                        friendly_elite_lost += (long)W6GameState.random(1);
                    } else if (this.friendlyInfantry[i] > 0L) {
                        enemy_elite_lost += (long)W6GameState.random(1);
                        friendly_infantry_lost += (long)W6GameState.random(10);
                    }
                }
                if (this.enemyInfantry[i] > 0L && this.enemyInfantry[i] < 100L) {
                    if (this.friendlyAir[i] > 0L) {
                        enemy_infantry_lost += (long)W6GameState.random(15);
                        friendly_airForce_lost += (long)W6GameState.random(2);
                    } else if (this.friendlyTanks[i] > 0L) {
                        enemy_infantry_lost += (long)W6GameState.random(10);
                        friendly_tanks_lost += (long)W6GameState.random(2);
                    } else if (this.friendlyElite[i] > 0L) {
                        enemy_infantry_lost += (long)W6GameState.random(7);
                        friendly_elite_lost += (long)W6GameState.random(1);
                    } else if (this.friendlyInfantry[i] > 0L) {
                        enemy_infantry_lost += (long)W6GameState.random(7);
                        friendly_infantry_lost += (long)W6GameState.random(5);
                    }
                }
                boolean enemyWon = false;
                boolean defenderWon = false;
                boolean battleOver = false;
                if (this.enemyInfantry[i] <= 0L && this.enemyElite[i] <= 0L && this.enemyTanks[i] <= 0L && this.enemyAir[i] <= 0L) {
                    enemyWon = false;
                    defenderWon = true;
                    battleOver = true;
                }
                if (this.friendlyInfantry[i] <= 0L && this.friendlyElite[i] <= 0L && this.friendlyTanks[i] <= 0L && this.friendlyAir[i] <= 0L) {
                    enemyWon = true;
                    defenderWon = false;
                    battleOver = true;
                }
                if (battleOver) {
                    if (enemyWon) {
                        this.countryOwners[i] = this.countryAttacker[i];
                        this.countryAttacker[i] = -1;
                        if (this.friendlyInfantry[i] < 0L) {
                            this.friendlyInfantry[i] = 0L;
                        }
                        if (this.friendlyElite[i] < 0L) {
                            this.friendlyElite[i] = 0L;
                        }
                        if (this.friendlyTanks[i] < 0L) {
                            this.friendlyTanks[i] = 0L;
                        }
                        if (this.friendlyAir[i] < 0L) {
                            this.friendlyAir[i] = 0L;
                        }
                        int n = i;
                        this.friendlyInfantry[n] = this.friendlyInfantry[n] + this.enemyInfantry[i];
                        int n2 = i;
                        this.friendlyTanks[n2] = this.friendlyTanks[n2] + this.enemyTanks[i];
                        int n3 = i;
                        this.friendlyElite[n3] = this.friendlyElite[n3] + this.enemyElite[i];
                        int n4 = i;
                        this.friendlyAir[n4] = this.friendlyAir[n4] + this.enemyAir[i];
                        int n5 = i;
                        this.friendlyMissiles[n5] = this.friendlyMissiles[n5] + this.enemyMissiles[i];
                        int n6 = i;
                        this.friendlyNukes[n6] = this.friendlyNukes[n6] + this.enemyNukes[i];
                        this.enemyInfantry[i] = 0L;
                        this.enemyTanks[i] = 0L;
                        this.enemyElite[i] = 0L;
                        this.enemyAir[i] = 0L;
                        this.enemyMissiles[i] = 0L;
                        this.enemyNukes[i] = 0L;
                        this.countryRedraws.add(new Integer(i));
                    } else {
                        this.countryAttacker[i] = -1;
                        if (this.enemyInfantry[i] < 0L) {
                            this.enemyInfantry[i] = 0L;
                        }
                        if (this.enemyElite[i] < 0L) {
                            this.enemyElite[i] = 0L;
                        }
                        if (this.enemyTanks[i] < 0L) {
                            this.enemyTanks[i] = 0L;
                        }
                        if (this.enemyAir[i] < 0L) {
                            this.enemyAir[i] = 0L;
                        }
                    }
                } else {
                    int n = i;
                    this.enemyInfantry[n] = this.enemyInfantry[n] - enemy_infantry_lost;
                    if (this.enemyInfantry[i] < 0L) {
                        this.enemyInfantry[i] = 0L;
                    }
                    int n7 = i;
                    this.enemyElite[n7] = this.enemyElite[n7] - enemy_elite_lost;
                    if (this.enemyElite[i] < 0L) {
                        this.enemyElite[i] = 0L;
                    }
                    int n8 = i;
                    this.enemyTanks[n8] = this.enemyTanks[n8] - enemy_tanks_lost;
                    if (this.enemyTanks[i] < 0L) {
                        this.enemyTanks[i] = 0L;
                    }
                    int n9 = i;
                    this.enemyAir[n9] = this.enemyAir[n9] - enemy_airForce_lost;
                    if (this.enemyAir[i] < 0L) {
                        this.enemyAir[i] = 0L;
                    }
                    int n10 = i;
                    this.friendlyInfantry[n10] = this.friendlyInfantry[n10] - friendly_infantry_lost;
                    if (this.friendlyInfantry[i] < 0L) {
                        this.friendlyInfantry[i] = 0L;
                    }
                    int n11 = i;
                    this.friendlyElite[n11] = this.friendlyElite[n11] - friendly_elite_lost;
                    if (this.friendlyElite[i] < 0L) {
                        this.friendlyElite[i] = 0L;
                    }
                    int n12 = i;
                    this.friendlyTanks[n12] = this.friendlyTanks[n12] - friendly_tanks_lost;
                    if (this.friendlyTanks[i] < 0L) {
                        this.friendlyTanks[i] = 0L;
                    }
                    int n13 = i;
                    this.friendlyAir[n13] = this.friendlyAir[n13] - friendly_airForce_lost;
                    if (this.friendlyAir[i] < 0L) {
                        this.friendlyAir[i] = 0L;
                    }
                }
            }
            ++i;
        }
    }

    public void updateTerritoryCount() {
        int count = 0;
        int groupsLeft = 0;
        int g = 0;
        while (g < this.groupCount) {
            int c = 0;
            while (c < this.countryCount) {
                if (this.countryOwners[c] == g) {
                    ++count;
                }
                ++c;
            }
            if (count > 0) {
                ++groupsLeft;
            } else {
                System.out.println(this.groupNames[g] + " is dead.");
            }
            this.territoryCount[g] = count;
            count = 0;
            ++g;
        }
    }

    public void purchaseTroops() {
        long tospend = 0L;
        int c = 0;
        while (c < W6GameState.random(this.countryCount)) {
            int country = W6GameState.random(this.countryCount);
            int owner = this.countryOwners[country];
            if (!this.isGroupFake(owner) && !this.isGroupHuman(owner) && this.countryCash[country] > 0L) {
                tospend = this.countryGDPs[country] * 90L / 100L;
                int n = country;
                this.friendlyInfantry[n] = this.friendlyInfantry[n] + tospend / 2L / (long)this.infantryCost;
                int n2 = country;
                this.friendlyTanks[n2] = this.friendlyTanks[n2] + tospend / 4L / (long)this.tankCost;
                int n3 = country;
                this.friendlyElite[n3] = this.friendlyElite[n3] + tospend / 4L / (long)this.eliteCost;
                this.countryCash[country] = this.countryCash[c] - tospend;
            }
            ++c;
        }
    }

    public void spawnNewAttacks() {
        int g = 0;
        while (g < this.groupCount) {
            if (!(this.isGroupFake(g) || this.isGroupNeutral(g) || this.isGroupHuman(g))) {
                int val;
                int target = this.getWeakestEnemy(g);
                int source = this.getStrongestCountry(g);
                if (this.shouldAttack(source, target)) {
                    this.r.setSeed(System.currentTimeMillis());
                    val = W6GameState.random(1000);
                    if ((double)(val / 13) == (double)val / 13.0 && this.countryAttacker[target] == -1) {
                        this.executeAttack(source, target);
                    }
                }
                if ((target = this.getStrongestEnemyShouldAttack(source = this.getStrongestCountry(g))) > -1 && target < this.countryCount) {
                    this.r.setSeed(System.currentTimeMillis());
                    val = W6GameState.random(1000);
                    if ((double)(val / 273) == (double)val / 273.0 && this.countryAttacker[target] == -1) {
                        this.executeAttack(source, target);
                    }
                }
            }
            ++g;
        }
    }

    public long getCountryStrength(int cid) {
        return this.friendlyInfantry[cid] * (long)this.infantryCost + this.friendlyTanks[cid] * (long)this.tankCost + this.friendlyElite[cid] * (long)this.eliteCost + this.friendlyAir[cid] * (long)this.airCost + this.friendlyMissiles[cid] * (long)this.missileCost + this.friendlyNukes[cid] * (long)this.nukeCost;
    }

    public int getStrongestCountry(int g) {
        int strongestCountry = -1;
        long strength = 0L;
        int i = 0;
        boolean found_first_real = false;
        while (!found_first_real) {
            if (!this.isGroupFake(this.countryOwners[i]) && this.countryOwners[i] == g) {
                strength = this.getCountryStrength(i);
                strongestCountry = i;
                found_first_real = true;
            }
            ++i;
        }
        while (i < this.countryCount) {
            if (this.countryOwners[i] == g && strength < this.getCountryStrength(i)) {
                strength = this.getCountryStrength(i);
                strongestCountry = i;
            }
            ++i;
        }
        return strongestCountry;
    }

    public long getStrongestCountryStrength() {
        int strongestCountry = -1;
        long strength = 0L;
        int i = 0;
        boolean found_first_real = false;
        while (!found_first_real) {
            if (!this.isGroupFake(this.countryOwners[i])) {
                strength = this.getCountryStrength(i);
                strongestCountry = i;
                found_first_real = true;
            }
            ++i;
        }
        while (i < this.countryCount) {
            if (strength < this.getCountryStrength(i)) {
                strength = this.getCountryStrength(i);
                strongestCountry = i;
            }
            ++i;
        }
        return strongestCountry;
    }

    public int getStrongestEnemyShouldAttack(int c) {
        int owner = this.countryOwners[c];
        int strongestCountry = -1;
        long strength = this.getStrongestCountryStrength();
        int i = 0;
        while (i < this.countryCount) {
            if (this.shouldAttack(c, i) && strength < this.getCountryStrength(i)) {
                strength = this.getCountryStrength(i);
                strongestCountry = i;
            }
            ++i;
        }
        return strongestCountry;
    }

    public int getWeakestEnemy(int g) {
        int weakestCountry = -1;
        long strength = 0L;
        int i = 0;
        boolean found_first_real = false;
        while (!found_first_real) {
            if (!this.isGroupFake(this.countryOwners[i]) && this.countryOwners[i] != g) {
                strength = this.getCountryStrength(i);
                weakestCountry = i;
                found_first_real = true;
            }
            ++i;
        }
        while (i < this.countryCount) {
            if (this.countryOwners[i] != g && strength > this.getCountryStrength(i)) {
                strength = this.getCountryStrength(i);
                weakestCountry = i;
            }
            ++i;
        }
        return weakestCountry;
    }

    public boolean shouldAttack(int src, int tar) {
        long needi = (this.friendlyInfantry[tar] + 10L) * 15L;
        long needt = this.friendlyTanks[tar] * 2L;
        long neede = this.friendlyElite[tar] * 2L;
        if (this.friendlyInfantry[src] <= needi) {
            return false;
        }
        if (this.friendlyTanks[src] == 0L) {
            needi += this.friendlyTanks[tar] * 15L;
        }
        if (this.friendlyElite[src] == 0L) {
            needi += this.friendlyElite[tar] * 100L;
        }
        long lefti = this.friendlyInfantry[src] - needi;
        long leftt = this.friendlyTanks[src] - needt;
        long lefte = this.friendlyElite[src] - neede;
        return lefti > 0L && leftt > 0L && lefte > 0L;
        {
        }
    }

    public void executeAttack(int src, int tar) {
        this.logData.add(this.groupNames[this.countryOwners[src]] + " is invading " + this.countryNames[tar]);
        long needi = (this.friendlyInfantry[tar] + 10L) * 3L;
        long needt = this.friendlyTanks[tar] * 2L;
        long neede = this.friendlyElite[tar] * 2L;
        if (this.friendlyTanks[src] == 0L) {
            needi += this.friendlyTanks[tar] * 15L;
        }
        if (this.friendlyElite[src] == 0L) {
            needi += this.friendlyElite[tar] * 100L;
        }
        this.countryAttacker[tar] = this.countryOwners[src];
        this.enemyInfantry[tar] = needi;
        this.enemyTanks[tar] = needt;
        this.enemyElite[tar] = neede;
        int n = src;
        this.friendlyInfantry[n] = this.friendlyInfantry[n] - needi;
        int n2 = src;
        this.friendlyTanks[n2] = this.friendlyTanks[n2] - needt;
        int n3 = src;
        this.friendlyElite[n3] = this.friendlyElite[n3] - neede;
        this.moves.add(new TroopMovement(src, tar));
    }
}

