/*
 * Decompiled with CFR 0.152.
 */
package com.mct.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.net.URL;

public class TinGraphicsUtil {
    private static final Component sComponent;
    private static final MediaTracker sTracker;
    private static int sID;

    public static Image blockingLoad(String path) {
        Image image = Toolkit.getDefaultToolkit().getImage(path);
        if (!TinGraphicsUtil.waitForImage(image)) {
            return null;
        }
        return image;
    }

    public static Image blockingLoad(URL url) {
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        if (!TinGraphicsUtil.waitForImage(image)) {
            return null;
        }
        return image;
    }

    public static void centerFrame(Window f) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = f.getSize();
        int x = (screen.width - d.width) / 2;
        int y = (screen.height - d.height) / 2;
        ((Component)f).setLocation(x, y);
    }

    public static Frame getNonClearingFrame(String name, Component c) {
        final Frame f = new Frame(name){

            public void update(Graphics g) {
                ((Container)this).paint(g);
            }
        };
        TinGraphicsUtil.sizeContainerToComponent(f, c);
        TinGraphicsUtil.centerFrame(f);
        f.setLayout(new BorderLayout());
        f.add(c, "Center");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                f.dispose();
            }
        });
        return f;
    }

    public static BufferedImage makeBufferedImage(Image image) {
        return TinGraphicsUtil.makeBufferedImage(image, 1);
    }

    public static BufferedImage makeBufferedImage(Image image, int imageType) {
        if (!TinGraphicsUtil.waitForImage(image)) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), imageType);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, null, null);
        return bufferedImage;
    }

    public static void sizeContainerToComponent(Container container, Component component) {
        if (!container.isDisplayable()) {
            container.addNotify();
        }
        Insets insets = container.getInsets();
        Dimension size = component.getPreferredSize();
        int width = insets.left + insets.right + size.width;
        int height = insets.top + insets.bottom + size.height;
        container.setSize(width, height);
    }

    private static boolean waitForImage(Image image) {
        int id;
        Component component = sComponent;
        synchronized (component) {
            id = sID++;
        }
        sTracker.addImage(image, id);
        try {
            sTracker.waitForID(id);
        }
        catch (InterruptedException interruptedexception) {
            return false;
        }
        return !sTracker.isErrorID(id);
    }

    static {
        sID = 0;
        sComponent = new Component(){};
        sTracker = new MediaTracker(sComponent);
    }
}

