/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.resources.MappedColor;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import net.puppygames.applet.Area;
import net.puppygames.applet.Game;
import net.puppygames.applet.MiniGame;
import net.puppygames.applet.NagState;
import net.puppygames.applet.PrizeFeature;
import net.puppygames.applet.Screen;
import net.puppygames.applet.TickableObject;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.widgets.TextField;
import net.puppygames.gamecommerce.shared.NewsletterIncentive;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.Rectangle;

public class UnlockBonusScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private static final boolean ALLOW_ANY_STRING = true;
    private static UnlockBonusScreen instance;
    private static final String CODE = "code";
    private static final String OK = "ok";
    private static final String CANCEL = "cancel";
    private static final String MESSAGE = "message";
    private static final String INSTRUCTION = "instruction";
    private static final String DONTSHOWAGAIN_OFF = "dontShowAgain_off";
    private static final String DONTSHOWAGAIN_ON = "dontShowAgain_on";
    private static final String DONTSHOWAGAIN = "dontShowAgain";
    private static final String CONTINUE = "continue";
    private MappedColor topColor;
    private MappedColor bottomColor;
    private MappedColor color;
    private Rectangle codeInsets;
    private String font;
    private transient TextField emailField;
    private transient boolean valid;
    private transient GLFont fontResource;
    private transient boolean waitForMouse;
    private transient TickableObject emailObject;
    private transient NewsletterIncentive ni;
    private transient boolean done;

    public UnlockBonusScreen(String name) {
        super(name);
    }

    protected void doCreateScreen() {
        this.emailField = new TextField(8, this.getArea(CODE).getBounds().getWidth()){

            public boolean acceptChar(char c) {
                return Character.isDigit(c) || Character.toUpperCase(c) >= 'A' && Character.toUpperCase(c) <= 'F';
            }

            protected void onChangeFocus() {
                SFX.textEntered();
                UnlockBonusScreen.this.requestFocus(UnlockBonusScreen.this.getArea(UnlockBonusScreen.OK));
            }

            protected void onEdited() {
                SFX.keyTyped();
                UnlockBonusScreen.this.checkValid();
            }
        };
        this.emailField.setFont(this.fontResource);
        if (this.color != null) {
            this.emailField.setColour((ReadableColor)this.color);
        }
        if (this.topColor != null) {
            this.emailField.setTopColour((ReadableColor)this.topColor);
        }
        if (this.bottomColor != null) {
            this.emailField.setBottomColour((ReadableColor)this.bottomColor);
        }
        this.setVisible(CONTINUE, false);
    }

    protected void onResized() {
        Area emailArea = this.getArea(CODE);
        this.emailField.setLocation(emailArea.getBounds().getX() + this.codeInsets.getX(), emailArea.getBounds().getY() + this.codeInsets.getY());
        this.emailField.setWidth(emailArea.getBounds().getWidth() - this.codeInsets.getWidth());
    }

    protected void doRegister() {
        instance = this;
    }

    protected void doDeregister() {
        instance = null;
    }

    public static void show(NewsletterIncentive ni) {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        UnlockBonusScreen.instance.ni = ni;
        instance.open();
    }

    protected void onOpen() {
        Game.setPauseEnabled(false);
        this.emailField.setEditing(true);
        this.waitForMouse = true;
        this.checkValid();
        this.emailObject = new TickableObject(){

            protected void render() {
                UnlockBonusScreen.this.emailField.render((SimpleRenderer)this);
            }
        };
        this.emailObject.setLayer(100);
        this.emailObject.spawn(this);
        this.enableButtons();
    }

    protected void onClose() {
        Game.setPauseEnabled(true);
        if (this.emailObject != null) {
            this.emailObject.remove();
            this.emailObject = null;
        }
        MiniGame.showTitleScreen();
        NagState nagState = MiniGame.getNagState();
        if (nagState == NagState.REDEEMED || nagState == NagState.DONT_NAG) {
            MiniGame.getIncentiveFile().delete();
        }
    }

    protected void onClicked(String id) {
        if (this.waitForMouse) {
            if (!Mouse.isButtonDown((int)0)) {
                this.waitForMouse = false;
            }
            return;
        }
        if (id.equals(CODE)) {
            this.emailField.setEditing(true);
        } else if (id.equals(OK) || id.equals(CONTINUE)) {
            if (this.done) {
                this.close();
            } else {
                this.unlock();
            }
        } else if (id.equals(CANCEL)) {
            this.close();
        } else if (id.equals(DONTSHOWAGAIN)) {
            NagState nagState = MiniGame.getNagState();
            switch (nagState) {
                case DONT_NAG: {
                    nagState = NagState.PRIZE_AWAITS;
                    break;
                }
                case PRIZE_AWAITS: {
                    nagState = NagState.DONT_NAG;
                    break;
                }
                case REDEEMED: {
                    return;
                }
                default: {
                    assert (false) : "Shouldn't have nag state " + (Object)((Object)nagState);
                    return;
                }
            }
            MiniGame.setNagState(nagState);
            this.enableButtons();
        }
    }

    private void unlock() {
        if (!this.checkValid()) {
            return;
        }
        SFX.newGame();
        PrizeFeature prize = (PrizeFeature)Resources.get((String)this.ni.getPrize());
        MiniGame.setPrize(prize);
        MiniGame.setNagState(NagState.REDEEMED);
        this.getArea(MESSAGE).setText(prize.getSuccessMessage());
        this.setVisible(CANCEL, false);
        this.setVisible(CODE, false);
        this.setVisible(INSTRUCTION, false);
        this.enableButtons();
        this.emailObject.remove();
        this.emailObject = null;
        this.setVisible(OK, false);
        this.setVisible(CONTINUE, true);
        this.done = true;
    }

    private void enableButtons() {
        NagState nagState = MiniGame.getNagState();
        this.setVisible(DONTSHOWAGAIN_ON, nagState == NagState.DONT_NAG);
        this.setVisible(DONTSHOWAGAIN_OFF, nagState == NagState.PRIZE_AWAITS);
        this.setVisible(DONTSHOWAGAIN, nagState != NagState.REDEEMED);
        this.getArea(DONTSHOWAGAIN_OFF).init();
        this.getArea(DONTSHOWAGAIN_ON).init();
        this.getArea(DONTSHOWAGAIN).init();
    }

    protected void doTick() {
        if (!this.isBlocked()) {
            if (!Mouse.isButtonDown((int)0)) {
                this.waitForMouse = false;
            }
            if (!this.done) {
                this.emailField.tick();
                boolean wasEnabled = this.getArea(OK).isEnabled();
                if (wasEnabled != this.valid) {
                    this.setEnabled(OK, this.valid);
                }
            }
        }
    }

    private boolean checkValid() {
        this.valid = this.emailField.getText().equalsIgnoreCase(this.ni.getShortCode());
        return this.valid;
    }

    protected void preRender() {
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }
}

