/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import com.shavenpuppy.jglib.util.CheckOnline;
import java.rmi.Naming;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.puppygames.applet.AppletMessageCheckerRemote;
import net.puppygames.applet.Configuration;
import net.puppygames.applet.Game;
import net.puppygames.applet.MessageReturn;
import net.puppygames.applet.News;
import net.puppygames.applet.PlayerSlot;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.FadeEffect;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.EnterNameDialog;
import net.puppygames.applet.screens.GenericButtonHandler;
import net.puppygames.applet.screens.SlotScreen;
import net.puppygames.gamecommerce.shared.ConfigurationDetails;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;

public class TitleScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private static final boolean TEST_NEW_VERSION_MESSAGE = true;
    private static final boolean TEST_MESSAGE_LONG = true;
    private static final boolean TEST_REGISTRATION_DETAILS = true;
    private static final int FADE_DELAY = 300;
    private static final int FADE_DURATION = 120;
    private static final String ID_SLOT = "slot";
    private static final String ID_VERSION = "version";
    private static final String ID_REGISTRATION = "registration";
    private static TitleScreen instance;
    private transient boolean messagesChecked;
    private transient boolean newsChecked;
    private transient List<News> news;
    private transient News currentNews;
    private transient MessageReturn pendingMessage;
    private transient boolean deregistrationChecked;
    private transient int tick;
    private transient int fade;
    private static final int FADE_NORMAL = 0;
    private static final int FADE_FADING = 1;
    private static final int FADE_FADED = 2;
    private transient FadeEffect fadeEffect;

    public TitleScreen(String name) {
        super(name);
    }

    protected void doRegister() {
        instance = this;
    }

    protected void doDeregister() {
        instance = null;
    }

    public static void instantiate() {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static TitleScreen getInstance() {
        return instance;
    }

    public static void show() {
        TitleScreen.instantiate();
        instance.open();
    }

    protected void doTick() {
        if (this.pendingMessage != null) {
            String msg = this.pendingMessage.getMessage();
            if (msg != null && this.pendingMessage.getTitle() != null) {
                msg = msg.replaceAll("\\$website", Game.getWebsite());
                msg = msg.replaceAll("\\$download", Game.getDownload());
                msg = msg.replaceAll("\\$contact", Game.getContactURL());
                Res.getInfoDialog().doModal(this.pendingMessage.getTitle(), msg, new Runnable(){

                    public void run() {
                    }
                });
            }
            if (this.pendingMessage.getReconfigure() != null) {
                try {
                    Game.setConfiguration((Configuration)this.pendingMessage.getReconfigure());
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            this.pendingMessage = null;
        }
        if (this.news != null && this.news.size() > 0 && this.currentNews == null) {
            this.currentNews = this.news.remove(0);
            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
            Res.getInfoDialog().doModal(String.valueOf(df.format(this.currentNews.getDate().getTime())) + " NEWS", this.currentNews.getMessage(), new Runnable(){

                public void run() {
                    if (TitleScreen.this.currentNews.getURL() != null) {
                        Sys.openURL((String)TitleScreen.this.currentNews.getURL());
                    }
                    TitleScreen.this.currentNews = null;
                }
            });
        }
        switch (this.fade) {
            case 0: {
                ++this.tick;
                if (this.tick <= 300) break;
                this.tick = 0;
                this.fade = 1;
                break;
            }
            case 1: {
                ++this.tick;
                if (this.tick <= 120) break;
                this.tick = 0;
                this.fade = 2;
                break;
            }
        }
    }

    protected void preRender() {
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    protected void onClicked(String id) {
        GenericButtonHandler.onClicked(id);
        if (ID_SLOT.equals(id)) {
            SlotScreen.show();
        }
    }

    protected void onOpen() {
        GenericButtonHandler.onOpen(this);
        try {
            SFX.createSFX();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.doUpdateRegistrationDetails();
        if (Game.isSlotManaged() && Game.getPlayerSlot() == null) {
            EnterNameDialog.show(false, new Runnable(){

                public void run() {
                }
            });
        }
        new Thread(){

            public void run() {
                if (Game.getDontCheckMessages() || !Game.isRemoteCallAllowed() || !CheckOnline.isOnline()) {
                    return;
                }
                if (TitleScreen.this.messagesChecked && TitleScreen.this.newsChecked && (TitleScreen.this.deregistrationChecked || Game.isRegistered())) {
                    return;
                }
                try {
                    AppletMessageCheckerRemote amcr;
                    block13: {
                        amcr = (AppletMessageCheckerRemote)Naming.lookup("//puppygames.net/message_checker");
                        if (!TitleScreen.this.messagesChecked && TitleScreen.this.pendingMessage == null) {
                            TitleScreen.this.messagesChecked = true;
                            TitleScreen.this.pendingMessage = amcr.checkForMessages(Game.getTitle(), Game.getVersion(), Game.getGame().getMessageSequence(), (ConfigurationDetails)Game.getConfiguration());
                        }
                        try {
                            if (TitleScreen.this.newsChecked || TitleScreen.this.news != null) break block13;
                            TitleScreen.this.newsChecked = true;
                            SimpleDateFormat df = new SimpleDateFormat("yyyyMMMdd");
                            String lastCheckedString = Game.getGlobalPreferences().get("lastnewscheck", "");
                            Date lastCheckedDate = null;
                            try {
                                lastCheckedDate = df.parse(lastCheckedString);
                            }
                            catch (Exception e) {
                                lastCheckedDate = new Date();
                            }
                            Calendar dayToCheckFrom = Calendar.getInstance();
                            dayToCheckFrom.setTime(lastCheckedDate);
                            TitleScreen.this.news = amcr.getNews(dayToCheckFrom);
                            dayToCheckFrom.setLenient(true);
                            dayToCheckFrom.add(6, 1);
                            Game.getGlobalPreferences().put("lastnewscheck", df.format(dayToCheckFrom.getTime()));
                        }
                        catch (Throwable e) {
                            e.printStackTrace(System.err);
                        }
                    }
                    try {
                        if (!TitleScreen.this.deregistrationChecked && Game.isRegistered() && Game.getRegistrationDetails() != null) {
                            TitleScreen.this.deregistrationChecked = true;
                            boolean stillRegistered = amcr.checkRegistrationValid(Game.getRegistrationDetails());
                            if (!stillRegistered) {
                                System.out.println("Registration is invalidated.");
                                Game.setRegistrationDetails(null);
                                TitleScreen.updateRegistrationDetails();
                            }
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace(System.err);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(System.err);
                }
            }
        }.start();
    }

    public static void updateRegistrationDetails() {
        TitleScreen.instantiate();
        instance.doUpdateRegistrationDetails();
    }

    public static void updateSlotDetails() {
        TitleScreen.instantiate();
        instance.doUpdateSlotDetails();
    }

    private void doUpdateSlotDetails() {
        if (!Game.isSlotManaged()) {
            return;
        }
        PlayerSlot slot = Game.getPlayerSlot();
        if (slot == null) {
            this.getArea(ID_SLOT).setText(Game.getMessage("lwjglapplets.titlescreen.entername"));
        } else {
            String msg = Game.getMessage("lwjglapplets.titlescreen.welcome");
            msg = msg.replace("[name]", slot.getName().toUpperCase());
            this.getArea(ID_SLOT).setText(msg);
        }
    }

    private void doUpdateRegistrationDetails() {
        this.tick = 0;
        this.fade = 0;
        if (this.fadeEffect != null) {
            this.fadeEffect.remove();
            this.fadeEffect = null;
        }
        this.fadeEffect = new FadeEffect(300, 120){

            protected void onTicked() {
                TitleScreen.this.getArea(TitleScreen.ID_REGISTRATION).setTextAlpha(this.getAlpha());
            }
        };
        this.fadeEffect.spawn(this);
        RegistrationDetails regDetails = Game.getRegistrationDetails();
        if (regDetails == null) {
            this.getArea(ID_REGISTRATION).setText("");
        } else {
            boolean nameOnly = Game.getLocalPreferences().getBoolean("nameOnly", false);
            this.getArea(ID_REGISTRATION).setText(regDetails.toTitleScreen(nameOnly).toUpperCase());
            Game.getLocalPreferences().putBoolean("nameOnly", true);
        }
        if (Game.isRegistered()) {
            this.getArea(ID_VERSION).setText("v" + Game.getVersion());
        } else {
            this.getArea(ID_VERSION).setText("v" + Game.getVersion() + " DEMO");
        }
        this.updateControls();
    }

    protected void updateControls() {
        if (this.getArea("buy") != null) {
            this.getArea("buy").setEnabled(!Game.isRegistered());
        }
    }
}

