/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import java.util.ArrayList;
import java.util.List;
import net.puppygames.applet.Area;
import net.puppygames.applet.Game;
import net.puppygames.applet.PlayerSlot;
import net.puppygames.applet.Res;
import net.puppygames.applet.screens.DialogScreen;
import net.puppygames.applet.screens.EnterNameDialog;
import net.puppygames.applet.screens.SlotEffect;
import net.puppygames.applet.screens.SlotEffectListener;

public class SlotScreen
extends DialogScreen
implements SlotEffectListener {
    private static SlotScreen instance;
    private static final int maxSlots = 6;
    private static final String ID_NEW = "new";
    private static final String ID_DELETE = "delete";
    private static final String ID_RENAME = "rename";
    private static final String ID_SLOT_ORIGIN = "slot_origin";
    private String slotClass;
    private int gap;
    private transient List<SlotEffect> slots;
    private transient Class<? extends PlayerSlot> slotClazz;
    private transient int selectedIndex;
    private transient Area slotOriginArea;

    public SlotScreen(String name) {
        super(name);
    }

    protected void doRegister() {
        assert (instance == null);
        instance = this;
    }

    protected void doDeregister() {
        assert (instance == this);
        instance = null;
    }

    public static void show() {
        if (!instance.isCreated()) {
            instance.create();
        }
        instance.open();
    }

    protected void doCreateScreen() {
        try {
            this.slotClazz = Class.forName(this.slotClass);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.slotOriginArea = this.getArea(ID_SLOT_ORIGIN);
    }

    protected void doOnOpen() {
        this.rebuild();
    }

    private void rebuild() {
        if (this.slots != null) {
            for (SlotEffect se : this.slots) {
                se.remove();
            }
            this.slots = null;
        }
        List<PlayerSlot> playerSlots = PlayerSlot.getSlots();
        this.slots = new ArrayList<SlotEffect>(playerSlots.size());
        int y = this.slotOriginArea.getBounds().getY();
        for (PlayerSlot ps : playerSlots) {
            try {
                SlotEffect se = (SlotEffect)((Object)this.slotClazz.newInstance());
                se.setSlot(ps);
                se.setLocation(this.slotOriginArea.getBounds().getX(), y);
                se.spawn(this);
                se.setSlotEffectListener(this);
                if (ps.equals(Game.getPlayerSlot())) {
                    se.setSelected(true);
                }
                this.slots.add(se);
                y -= this.gap;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        this.selectedIndex = -2;
        int idx = -1;
        for (SlotEffect se : this.slots) {
            ++idx;
            if (se.isSelected()) break;
        }
        this.setSelectedIndex(idx);
    }

    protected void onClicked(String id) {
        if (ID_NEW.equals(id)) {
            EnterNameDialog.show(true, new Runnable(){

                public void run() {
                    if (EnterNameDialog.isOKClicked()) {
                        SlotScreen.this.close();
                    }
                }
            });
        } else if (ID_DELETE.equals(id)) {
            this.deleteSelected();
        } else if (ID_RENAME.equals(id)) {
            this.renameSelected();
        } else if ("cancel".equals(id) && this.selectedIndex != -1) {
            SlotEffect se = this.slots.get(this.selectedIndex);
            Game.setPlayerSlot(se.getSlot());
            this.close();
        }
    }

    protected void deleteSelected() {
        if (this.selectedIndex == -1) {
            return;
        }
        final SlotEffect se = this.slots.get(this.selectedIndex);
        String msg = Game.getMessage("lwjglapplets.slotscreen.delete_message");
        msg = msg.replace("[slot]", se.getSlot().getName().toUpperCase());
        Res.getDeleteYesCancelDialog().doModal(Game.getMessage("lwjglapplets.slotscreen.delete_title"), msg, new Runnable(){

            public void run() {
                int option = Res.getDeleteYesCancelDialog().getOption();
                if (option == 0 || option == 2) {
                    se.getSlot().delete();
                    if (SlotScreen.this.selectedIndex == SlotScreen.this.slots.size() - 1) {
                        SlotScreen slotScreen = SlotScreen.this;
                        slotScreen.selectedIndex = slotScreen.selectedIndex - 1;
                    }
                    if (SlotScreen.this.selectedIndex == -1) {
                        Game.setPlayerSlot(null);
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    } else {
                        PlayerSlot slot = ((SlotEffect)SlotScreen.this.slots.get(SlotScreen.this.selectedIndex)).getSlot();
                        System.out.println("Setting player slot to " + slot.getName());
                        Game.setPlayerSlot(slot);
                    }
                    SlotScreen.this.rebuild();
                }
            }
        });
    }

    protected void renameSelected() {
    }

    protected void doCleanup() {
        this.slots = null;
    }

    public void onSlotEffectChanged(SlotEffect effect) {
        if (effect.isSelected()) {
            this.setSelectedIndex(this.slots.indexOf(effect));
            for (SlotEffect se : this.slots) {
                if (se == effect) continue;
                se.setSelected(false);
            }
        }
    }

    public void onSlotEffectEdited(SlotEffect effect) {
    }

    public void setSelectedIndex(int newIndex) {
        if (this.selectedIndex != newIndex) {
            this.selectedIndex = newIndex;
            this.enableControls();
        }
    }

    protected void enableControls() {
        this.setEnabled(ID_NEW, this.slots.size() < 6);
        this.setEnabled(ID_DELETE, this.selectedIndex != -1 && this.slots.size() > 1);
        this.setEnabled(ID_RENAME, this.selectedIndex != -1);
        this.setEnabled("cancel", this.selectedIndex != -1 || this.selectedIndex == -1 && Game.getPlayerSlot() != null && Game.getPlayerSlot().exists());
    }
}

