/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.resources.MappedColor;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.util.CheckOnline;
import com.shavenpuppy.jglib.util.HexDecoder;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import net.puppygames.applet.Area;
import net.puppygames.applet.Game;
import net.puppygames.applet.MiniGame;
import net.puppygames.applet.NagState;
import net.puppygames.applet.PrizeFeature;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.TickableObject;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.DialogScreen;
import net.puppygames.applet.screens.UnlockBonusScreen;
import net.puppygames.applet.widgets.TextField;
import net.puppygames.gamecommerce.shared.GenericServerRemote;
import net.puppygames.gamecommerce.shared.NewsletterIncentive;
import net.puppygames.gamecommerce.shared.ValidateUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.Rectangle;

public class SignUpScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private static SignUpScreen instance;
    private static final Object cancelLock;
    private static final String EMAIL = "email";
    private static final String SIGNUP = "signup";
    private static final String LATER = "later";
    private static final String MESSAGE = "signup-nag";
    private static final String DONTSHOWAGAIN = "dontShowAgain";
    private static final String DONTSHOWAGAIN_ON = "dontShowAgain_on";
    private static final String DONTSHOWAGAIN_OFF = "dontShowAgain_off";
    private MappedColor topColor;
    private MappedColor bottomColor;
    private MappedColor color;
    private Rectangle emailInsets;
    private String font;
    private transient TextField emailField;
    private transient boolean valid;
    private transient GLFont fontResource;
    private transient DialogScreen waitDialog;
    private transient Thread signUpThread;
    private transient boolean cancelSignUp;
    private transient Runnable thingToDo;
    private transient boolean waitForMouse;
    private transient TickableObject emailObject;
    private transient PrizeFeature prize;

    static {
        cancelLock = new Object();
    }

    public SignUpScreen(String name) {
        super(name);
    }

    protected void doCreateScreen() {
        this.emailField = new TextField(64, this.getArea(EMAIL).getBounds().getWidth()){

            public boolean acceptChar(char c) {
                return Character.isLetterOrDigit(c) || c >= ' ' && c <= '\u007f';
            }

            protected void onChangeFocus() {
                SFX.textEntered();
                SignUpScreen.this.requestFocus(SignUpScreen.this.getArea(SignUpScreen.SIGNUP));
            }

            protected void onEdited() {
                SFX.keyTyped();
                SignUpScreen.this.checkValid();
            }
        };
        this.emailField.setFont(this.fontResource);
        if (this.color != null) {
            this.emailField.setColour((ReadableColor)this.color);
        }
        if (this.topColor != null) {
            this.emailField.setTopColour((ReadableColor)this.topColor);
        }
        if (this.bottomColor != null) {
            this.emailField.setBottomColour((ReadableColor)this.bottomColor);
        }
    }

    protected void onResized() {
        Area emailArea = this.getArea(EMAIL);
        this.emailField.setLocation(emailArea.getBounds().getX() + this.emailInsets.getX(), emailArea.getBounds().getY() + this.emailInsets.getY());
        this.emailField.setWidth(emailArea.getBounds().getWidth() - this.emailInsets.getWidth());
    }

    protected void doRegister() {
        instance = this;
    }

    protected void doDeregister() {
        instance = null;
    }

    public static void show(PrizeFeature prize) {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        SignUpScreen.instance.prize = prize;
        instance.open();
    }

    protected void onOpen() {
        Game.setPauseEnabled(false);
        this.emailField.setEditing(true);
        this.waitForMouse = true;
        this.checkValid();
        this.emailObject = new TickableObject(){

            protected void render() {
                SignUpScreen.this.emailField.render((SimpleRenderer)this);
            }
        };
        this.emailObject.setLayer(100);
        this.emailObject.spawn(this);
        this.getArea(MESSAGE).setText(this.prize.getScreenMessage());
        this.enableButtons();
    }

    protected void onClose() {
        Game.setPauseEnabled(true);
        if (this.emailObject != null) {
            this.emailObject.remove();
            this.emailObject = null;
        }
        MiniGame.showTitleScreen();
    }

    protected void onClicked(String id) {
        if (this.waitForMouse) {
            return;
        }
        if (id.equals(EMAIL)) {
            this.emailField.setEditing(true);
        } else if (id.equals(SIGNUP)) {
            this.signUp();
        } else if (id.equals(LATER)) {
            this.close();
        } else if (id.equals(DONTSHOWAGAIN)) {
            NagState nagState = MiniGame.getNagState();
            switch (nagState) {
                case DONT_NAG: {
                    nagState = NagState.NOT_YET_SHOWN;
                    break;
                }
                case NOT_YET_SHOWN: {
                    nagState = NagState.DONT_NAG;
                    break;
                }
                default: {
                    assert (false) : "Shouldn't have nag state " + (Object)((Object)nagState);
                    return;
                }
            }
            MiniGame.setNagState(nagState);
            this.enableButtons();
        }
    }

    private void enableButtons() {
        boolean dontShowAgain = MiniGame.getNagState() == NagState.DONT_NAG;
        this.setVisible(DONTSHOWAGAIN_ON, dontShowAgain);
        this.setVisible(DONTSHOWAGAIN_OFF, !dontShowAgain);
        this.getArea(DONTSHOWAGAIN_OFF).init();
        this.getArea(DONTSHOWAGAIN_ON).init();
    }

    private static void addParam(String param, String data, StringBuilder sb) throws UnsupportedEncodingException {
        if (sb.length() > 0) {
            sb.append('&');
        }
        sb.append(param);
        sb.append('=');
        sb.append(URLEncoder.encode(data, "utf8"));
    }

    private void signUp() {
        if (!this.checkValid()) {
            return;
        }
        if (!CheckOnline.isOnline()) {
            String msg = Game.getMessage("lwjglapplets.signupscreen.failed_message");
            msg = msg.replace("[title]", Game.getDisplayTitle());
            this.signUpFailed(msg, true);
        } else {
            this.waitDialog = Res.getCancelDialog();
            String msg = Game.getMessage("lwjglapplets.signupscreen.wait_message");
            msg = msg.replace("[title]", Game.getDisplayTitle());
            this.waitDialog.doModal(Game.getMessage("lwjglapplets.signupscreen.wait_title"), msg, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int option = SignUpScreen.this.waitDialog.getOption();
                    if (option != -1) {
                        SignUpScreen.this.waitForMouse = true;
                        Object object = cancelLock;
                        synchronized (object) {
                            SignUpScreen.this.cancelSignUp = true;
                            if (SignUpScreen.this.signUpThread != null) {
                                SignUpScreen.this.signUpThread.interrupt();
                            }
                        }
                    }
                    SignUpScreen.this.waitDialog = null;
                }
            });
            this.signUpThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        server = (GenericServerRemote)Naming.lookup("//puppygames.net/generic");
                        ** GOTO lbl33
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        var3_4 = SignUpScreen.access$5();
                        synchronized (var3_4) {
                            if (!SignUpScreen.access$10(SignUpScreen.this)) {
                                msg = Game.getMessage("lwjglapplets.signupscreen.connect_failed_message");
                                msg = msg.replace("[email]", Game.getSupportEmail());
                                SignUpScreen.access$11(SignUpScreen.this, msg, false);
                            }
                            SignUpScreen.access$6(SignUpScreen.this, false);
                        }
                        var8_10 = SignUpScreen.access$5();
                        synchronized (var8_10) {
                            SignUpScreen.access$9(SignUpScreen.this, null);
                            return;
                        }
                    }
                    {
                        catch (Throwable var7_19) {
                            var8_13 = SignUpScreen.access$5();
                            synchronized (var8_13) {
                                SignUpScreen.access$9(SignUpScreen.this, null);
                                throw var7_19;
                            }
lbl33:
                            // 1 sources

                            command = new StringBuilder(256);
                            SignUpScreen.access$12("cmd", "signup", command);
                            SignUpScreen.access$12("email", SignUpScreen.access$1(SignUpScreen.this).getText(), command);
                            SignUpScreen.access$12("installation", String.valueOf(Game.getInstallation()), command);
                            SignUpScreen.access$12("game", Game.getTitle(), command);
                            SignUpScreen.access$12("version", Game.getVersion(), command);
                            SignUpScreen.access$12("prize", SignUpScreen.access$13(SignUpScreen.this).getName(), command);
                            SignUpScreen.access$12("message", SignUpScreen.access$13(SignUpScreen.this).getEmailMessage(), command);
                            System.out.println("Executing remote command " + command);
                            ret = server.doCommand(command.toString());
                            System.out.println("Remote command result " + ret);
                            result = SignUpScreen.access$14(ret, "result", "FAILED");
                            if (!"SUCCESS".equals(result)) {
                                if ("FAILED".equals(result) == false) throw new Exception("Don't understand server response " + ret);
                                SignUpScreen.access$11(SignUpScreen.this, SignUpScreen.access$14(ret, "reason", Game.getMessage("lwjglapplets.signupscreen.unknown_reasons")), true);
                            }
                            code = SignUpScreen.access$14(ret, "code", "");
                            ni = new NewsletterIncentive(SignUpScreen.access$1(SignUpScreen.this).getText(), Game.getTitle(), Game.getVersion(), Game.getInstallation(), SignUpScreen.access$13(SignUpScreen.this).getName());
                            ni.setCode(HexDecoder.decode((String)code));
                            SignUpScreen.access$15(SignUpScreen.this, ni);
                        }
                        catch (RemoteException e) {
                            e.printStackTrace(System.err);
                            SignUpScreen.access$11(SignUpScreen.this, e.getMessage(), true);
                            var8_11 = SignUpScreen.access$5();
                            synchronized (var8_11) {
                                SignUpScreen.access$9(SignUpScreen.this, null);
                                return;
                            }
                        }
                        catch (Throwable e) {}
                        {
                            e.printStackTrace(System.err);
                            var5_16 = SignUpScreen.access$5();
                            synchronized (var5_16) {
                                if (!SignUpScreen.access$10(SignUpScreen.this)) {
                                    Game.onRegistrationDisaster();
                                    msg = Game.getMessage("lwjglapplets.signupscreen.signup_failed_message");
                                    msg = msg.replace("[email]", Game.getSupportEmail());
                                    SignUpScreen.access$11(SignUpScreen.this, msg, true);
                                    SignUpScreen.access$6(SignUpScreen.this, false);
                                }
                            }
                        }
                        var8_12 = SignUpScreen.access$5();
                        synchronized (var8_12) {
                            SignUpScreen.access$9(SignUpScreen.this, null);
                            return;
                        }
                    }
                    var8_14 = SignUpScreen.access$5();
                    synchronized (var8_14) {
                        SignUpScreen.access$9(SignUpScreen.this, null);
                        return;
                    }
                }
            };
            this.signUpThread.start();
        }
    }

    private void signUpFailed(final String message, final boolean fatal) {
        this.thingToDo = new Runnable(){

            public void run() {
                if (SignUpScreen.this.waitDialog != null && SignUpScreen.this.waitDialog.isOpen()) {
                    SignUpScreen.this.waitDialog.close();
                    SignUpScreen.this.waitDialog = null;
                }
                Res.getInfoDialog().doModal(Game.getMessage("lwjglapplets.signupscreen.failed"), String.valueOf(Game.getMessage("lwjglapplets.signupscreen.general_failure_message")) + "\n\n" + message, new Runnable(){

                    public void run() {
                        Res.getInfoDialog().getOption();
                        if (fatal) {
                            MiniGame.setNagState(NagState.DONT_NAG);
                            MiniGame.showTitleScreen();
                        }
                        SignUpScreen.this.waitForMouse = true;
                    }
                });
            }
        };
    }

    private void signUpSuccess(final NewsletterIncentive ni) {
        this.thingToDo = new Runnable(){

            public void run() {
                block15: {
                    Game.onRemoteCallSuccess();
                    if (SignUpScreen.this.waitDialog != null && SignUpScreen.this.waitDialog.isOpen()) {
                        SignUpScreen.this.waitDialog.close();
                        SignUpScreen.this.waitDialog = null;
                    }
                    FileOutputStream fos = null;
                    BufferedOutputStream bos = null;
                    ObjectOutputStream oos = null;
                    try {
                        try {
                            fos = new FileOutputStream(MiniGame.getIncentiveFile());
                            bos = new BufferedOutputStream(fos);
                            oos = new ObjectOutputStream(bos);
                            oos.writeObject(ni);
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                            try {
                                if (oos != null) {
                                    oos.flush();
                                    oos.close();
                                }
                                break block15;
                            }
                            catch (IOException iOException) {}
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (oos != null) {
                                oos.flush();
                                oos.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (oos != null) {
                            oos.flush();
                            oos.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                MiniGame.setNagState(NagState.PRIZE_AWAITS);
                UnlockBonusScreen.show(ni);
            }
        };
    }

    private static final String getParam(String data, String param, String _default) {
        StringTokenizer st = new StringTokenizer(data, "&", false);
        param = String.valueOf(param) + "=";
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (!t.startsWith(param)) continue;
            try {
                return URLDecoder.decode(t.substring(param.length()), "utf8");
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Failed to decode " + data);
                e.printStackTrace(System.err);
            }
        }
        return _default;
    }

    protected void doTick() {
        if (!this.isBlocked()) {
            if (!Mouse.isButtonDown((int)0)) {
                this.waitForMouse = false;
            }
            this.emailField.tick();
            boolean wasEnabled = this.getArea(SIGNUP).isEnabled();
            if (wasEnabled != this.valid) {
                this.setEnabled(SIGNUP, this.valid);
            }
        }
        if (this.thingToDo != null) {
            this.thingToDo.run();
            this.thingToDo = null;
        }
    }

    private boolean checkValid() {
        this.valid = ValidateUtil.isEmail((String)this.emailField.getText());
        return this.valid;
    }

    protected void preRender() {
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    static /* synthetic */ void access$9(SignUpScreen signUpScreen, Thread thread) {
        signUpScreen.signUpThread = thread;
    }

    static /* synthetic */ boolean access$10(SignUpScreen signUpScreen) {
        return signUpScreen.cancelSignUp;
    }

    static /* synthetic */ void access$11(SignUpScreen signUpScreen, String string, boolean bl) {
        signUpScreen.signUpFailed(string, bl);
    }

    static /* synthetic */ void access$12(String string, String string2, StringBuilder stringBuilder) throws UnsupportedEncodingException {
        SignUpScreen.addParam(string, string2, stringBuilder);
    }

    static /* synthetic */ PrizeFeature access$13(SignUpScreen signUpScreen) {
        return signUpScreen.prize;
    }

    static /* synthetic */ String access$14(String string, String string2, String string3) {
        return SignUpScreen.getParam(string, string2, string3);
    }

    static /* synthetic */ void access$15(SignUpScreen signUpScreen, NewsletterIncentive newsletterIncentive) {
        signUpScreen.signUpSuccess(newsletterIncentive);
    }
}

