/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import com.shavenpuppy.jglib.resources.ColorSequenceResource;
import com.shavenpuppy.jglib.resources.MappedColor;
import com.shavenpuppy.jglib.sprites.Appearance;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.sprites.Sprite;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.Naming;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import net.puppygames.applet.AppletHiscoreServerRemote;
import net.puppygames.applet.Area;
import net.puppygames.applet.Game;
import net.puppygames.applet.GameInputStream;
import net.puppygames.applet.GameOutputStream;
import net.puppygames.applet.HiscoresReturn;
import net.puppygames.applet.MiniGame;
import net.puppygames.applet.Res;
import net.puppygames.applet.RoamingFile;
import net.puppygames.applet.Score;
import net.puppygames.applet.Screen;
import net.puppygames.applet.TickableObject;
import net.puppygames.applet.effects.LabelEffect;
import net.puppygames.applet.effects.ProgressEffect;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.GenericButtonHandler;
import net.puppygames.applet.widgets.TextField;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableRectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiscoresScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private static final String REMOTE_ON = "remote_on";
    private static final String REMOTE_OFF = "remote_off";
    private static final String REGISTERED_COORDS = "registered_coords";
    private static final String RANK_COORDS = "rank_coords";
    private static final String NAME_COORDS = "name_coords";
    private static final String SCORE_COORDS = "score_coords";
    private static HiscoresScreen instance;
    private static final ArrayList<Row> rows;
    private static List<Score> allScores;
    private int yPos;
    private int yGap;
    private int scoresPerPage = 10;
    private MappedColor progressBackgroundColor = new MappedColor(Color.BLUE);
    private MappedColor progressBarColor = new MappedColor(Color.WHITE);
    private String rankFont;
    private String nameFont;
    private String scoreFont;
    private MappedColor rankColor;
    private MappedColor nameColor;
    private MappedColor scoreColor = new MappedColor(Color.WHITE);
    private transient Appearance registeredAppearanceResource;
    private transient GLFont rankFontResource;
    private transient GLFont nameFontResource;
    private transient GLFont scoreFontResource;
    private transient boolean remoteHiscores;
    private transient TickableObject hiscoresObject;
    private transient ReadableRectangle registeredCoords;
    private transient ReadableRectangle rankCoords;
    private transient ReadableRectangle nameCoords;
    private transient ReadableRectangle scoreCoords;
    private transient Score scoreToSubmit;
    private transient boolean doSubmit;
    private transient int page;
    private static final int PHASE_NORMAL = 0;
    private static final int PHASE_EDIT = 1;
    private static final int PHASE_SUBMIT = 2;
    private static final int PHASE_DOWNLOAD = 3;
    private static final String NEXT = "next";
    private static final String PREV = "prev";
    private int phase;
    private ProgressEffect progress;
    private int colorTick;
    private int tick;
    private static final int DELAY = 60;
    private static final ColorSequenceResource COLORSEQUENCE;
    private Row editingRow;

    static {
        rows = new ArrayList(100);
        COLORSEQUENCE = new ColorSequenceResource(new ColorSequenceResource.SequenceEntry[]{new ColorSequenceResource.SequenceEntry(Color.RED, 4, 4), new ColorSequenceResource.SequenceEntry(Color.ORANGE, 4, 4), new ColorSequenceResource.SequenceEntry(Color.YELLOW, 4, 4), new ColorSequenceResource.SequenceEntry(Color.GREEN, 4, 4), new ColorSequenceResource.SequenceEntry(Color.CYAN, 4, 4), new ColorSequenceResource.SequenceEntry(Color.BLUE, 4, 4), new ColorSequenceResource.SequenceEntry(Color.PURPLE, 4, 4)}, 1);
    }

    public HiscoresScreen(String name) {
        super(name);
    }

    protected void doRegister() {
        super.doRegister();
        instance = this;
    }

    protected void doDeregister() {
        super.doDeregister();
        instance = null;
    }

    protected void enableButtons() {
        if (this.page == 0) {
            this.setEnabled(PREV, false);
        } else {
            this.setEnabled(PREV, this.phase == 0);
        }
        if (this.page < this.getNumPages() - 1) {
            this.setEnabled(NEXT, this.phase == 0);
        } else {
            this.setEnabled(NEXT, false);
        }
        this.setEnabled("buy", this.phase != 1);
        this.setEnabled("credits", this.phase != 1);
        this.setEnabled("exit", this.phase != 1);
        this.setEnabled("help", this.phase != 1);
        this.setEnabled("hiscores", this.phase != 1);
        this.setEnabled("moregames", this.phase != 1);
        this.setEnabled("options", this.phase != 1);
        this.setEnabled("play", this.phase != 1);
        this.setEnabled("close", true);
        this.setEnabled(REMOTE_ON, this.phase != 1);
        this.setEnabled(REMOTE_OFF, this.phase != 1);
        this.setVisible(REMOTE_ON, MiniGame.getSubmitRemoteHiscores() && this.remoteHiscores);
        this.setVisible(REMOTE_OFF, MiniGame.getSubmitRemoteHiscores() && !this.remoteHiscores);
    }

    @Override
    protected void onClicked(String id) {
        GenericButtonHandler.onClicked(id);
        if (PREV.equals(id)) {
            if (this.phase == 1) {
                return;
            }
            GenericButtonHandler.onClicked(id);
            this.setPage(Math.max(0, this.page - 1));
        } else if (NEXT.equals(id)) {
            if (this.phase == 1) {
                return;
            }
            GenericButtonHandler.onClicked(id);
            this.setPage(Math.min(this.getNumPages() - 1, this.page + 1));
        } else if (REMOTE_ON.equals(id)) {
            if (this.phase == 1) {
                return;
            }
            GenericButtonHandler.onClicked(id);
            this.setShowRemote(false);
        } else if (REMOTE_OFF.equals(id)) {
            if (this.phase == 1) {
                return;
            }
            GenericButtonHandler.onClicked(id);
            this.setShowRemote(true);
        }
    }

    private void setShowRemote(boolean flag) {
        if (this.remoteHiscores != flag) {
            this.remoteHiscores = flag;
            this.loadHiscores();
        }
        this.enableButtons();
    }

    private void loadHiscores() {
        if (this.remoteHiscores) {
            this.loadRemoteScores();
        } else {
            this.loadLocalScores();
        }
    }

    private void loadRemoteScores() {
        this.phase = 3;
        this.progress = new ProgressEffect(Game.getMessage("lwjglapplets.hiscoresscreen.downloadprogress"), (ReadableColor)this.progressBackgroundColor, (ReadableColor)this.progressBarColor);
        this.progress.spawn(this);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block17: {
                    try {
                        try {
                            AppletHiscoreServerRemote server = (AppletHiscoreServerRemote)Naming.lookup("//puppygames.net/applet_hiscore_server");
                            List scores = server.getHiscores(Game.getTitle());
                            Game.onRemoteCallSuccess();
                            HiscoresScreen.this.setScoreList(scores);
                        }
                        catch (Exception e) {
                            Res.getErrorDialog().doModal(Game.getMessage("lwjglapplets.hiscoresscreen.problems"), String.valueOf(Game.getMessage("lwjglapplets.hiscoresscreen.unavailable")) + " (" + e + ")");
                            HiscoresScreen.this.phase = 0;
                            HiscoresScreen hiscoresScreen = HiscoresScreen.this;
                            synchronized (hiscoresScreen) {
                                HiscoresScreen.this.tick = 0;
                                if (HiscoresScreen.this.progress != null) {
                                    HiscoresScreen.this.progress.setFinished(true);
                                    HiscoresScreen.this.progress = null;
                                }
                            }
                            HiscoresScreen.this.enableButtons();
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        HiscoresScreen.this.phase = 0;
                        HiscoresScreen hiscoresScreen = HiscoresScreen.this;
                        synchronized (hiscoresScreen) {
                            HiscoresScreen.this.tick = 0;
                            if (HiscoresScreen.this.progress != null) {
                                HiscoresScreen.this.progress.setFinished(true);
                                HiscoresScreen.this.progress = null;
                            }
                        }
                        HiscoresScreen.this.enableButtons();
                        throw throwable;
                    }
                    HiscoresScreen.this.phase = 0;
                    HiscoresScreen hiscoresScreen = HiscoresScreen.this;
                    synchronized (hiscoresScreen) {
                        HiscoresScreen.this.tick = 0;
                        if (HiscoresScreen.this.progress != null) {
                            HiscoresScreen.this.progress.setFinished(true);
                            HiscoresScreen.this.progress = null;
                        }
                    }
                    HiscoresScreen.this.enableButtons();
                }
            }
        }.start();
    }

    private void loadLocalScores() {
        block13: {
            GameInputStream gis = null;
            ObjectInputStream ois = null;
            try {
                try {
                    RoamingFile hiscoresFile = new RoamingFile(this.getHiscoreFileName());
                    if (hiscoresFile.exists()) {
                        gis = new GameInputStream(this.getHiscoreFileName());
                        ois = new ObjectInputStream(gis);
                        this.setScoreList((ArrayList)ois.readObject());
                        break block13;
                    }
                    this.setScoreList(new ArrayList<Score>(0));
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    this.setScoreList(new ArrayList<Score>(0));
                    if (gis == null) break block13;
                    try {
                        gis.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (gis != null) {
                    try {
                        gis.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private String getHiscoreFileName() {
        return String.valueOf(Game.getRoamingDirectoryPrefix()) + "hiscores.dat";
    }

    public void setPage(int newPage) {
        this.page = newPage;
        this.enableButtons();
    }

    protected final int getNumPages() {
        return (rows.size() - 1) / this.scoresPerPage + 1;
    }

    @Override
    protected void doTick() {
        if (this.editingRow != null) {
            COLORSEQUENCE.getColor(this.colorTick++, this.editingRow.color);
        }
        int i = 0;
        while (i < rows.size()) {
            Row row = rows.get(i);
            row.tick();
            ++i;
        }
    }

    @Override
    protected void doCleanup() {
        if (this.hiscoresObject != null) {
            this.hiscoresObject.remove();
            this.hiscoresObject = null;
        }
        for (Row row : rows) {
            row.remove();
        }
        rows.clear();
    }

    public static void show(Score score) {
        HiscoresScreen.instance.doSubmit = score != null && score.getPoints() > 0;
        HiscoresScreen.instance.scoreToSubmit = score;
        instance.open();
    }

    @Override
    protected void onClose() {
        Game.setPauseEnabled(true);
    }

    @Override
    protected synchronized void onOpen() {
        this.remoteHiscores = false;
        this.enableButtons();
        GenericButtonHandler.onOpen(this);
        this.tick = 0;
        this.colorTick = 0;
        Game.setPauseEnabled(false);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.loadHiscores();
        this.hiscoresObject = new TickableObject(){

            public void tick() {
                int i = 0;
                while (i < rows.size()) {
                    Row row = (Row)rows.get(i);
                    if (i >= HiscoresScreen.this.page * HiscoresScreen.this.scoresPerPage && i < HiscoresScreen.this.page * HiscoresScreen.this.scoresPerPage + HiscoresScreen.this.scoresPerPage) {
                        if (row.registeredSprite != null) {
                            row.registeredSprite.setVisible(row.score.isRegistered());
                        }
                    } else if (row.registeredSprite != null) {
                        row.registeredSprite.setVisible(false);
                    }
                    ++i;
                }
            }

            protected void render() {
                this.glRender(new GLRenderable(){

                    public void render() {
                        GL11.glEnable((int)3553);
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
                    }
                });
                int i = 0;
                while (i < rows.size()) {
                    Row row = (Row)rows.get(i);
                    if (i >= HiscoresScreen.this.page * HiscoresScreen.this.scoresPerPage && i < HiscoresScreen.this.page * HiscoresScreen.this.scoresPerPage + HiscoresScreen.this.scoresPerPage) {
                        row.render((SimpleRenderer)this);
                    }
                    ++i;
                }
            }
        };
        this.hiscoresObject.setLayer(100);
        this.hiscoresObject.spawn(this);
    }

    private synchronized void setScoreList(List<Score> scores) {
        allScores = scores;
        for (Row row : rows) {
            row.remove();
        }
        rows.clear();
        int rank = 0;
        int page = 0;
        int editingPage = 0;
        int pos = 0;
        boolean done = false;
        this.phase = 0;
        for (Score s : allScores) {
            Row row;
            if (this.doSubmit && this.scoreToSubmit != null && this.scoreToSubmit.compareTo(s) == -1 && !done) {
                this.scoreToSubmit.setRank(rank++);
                row = new Row(pos, this.scoreToSubmit);
                row.field.setEditing(true);
                this.setKeyboardNavigationEnabled(false);
                rows.add(row);
                editingPage = page++;
                done = true;
                if (++pos == this.scoresPerPage) {
                    pos = 0;
                }
                this.phase = 1;
            }
            s.setRank(rank++);
            row = new Row(pos, s);
            rows.add(row);
            if (++pos != this.scoresPerPage) continue;
            pos = 0;
            ++page;
        }
        if (this.doSubmit && this.scoreToSubmit != null && !done && rank < 100) {
            this.scoreToSubmit.setRank(rank++);
            Row row = new Row(pos, this.scoreToSubmit);
            row.field.setEditing(true);
            this.setKeyboardNavigationEnabled(false);
            rows.add(row);
            editingPage = page;
            this.phase = 1;
        }
        this.setPage(editingPage);
    }

    private void submitRemoteScore(final Score score) {
        this.phase = 2;
        this.progress = new ProgressEffect(Game.getMessage("lwjglapplets.hiscoresscreen.submitting"), (ReadableColor)this.progressBackgroundColor, (ReadableColor)this.progressBarColor);
        this.progress.spawn(instance);
        this.enableButtons();
        new Thread(){

            public void run() {
                try {
                    try {
                        AppletHiscoreServerRemote server = (AppletHiscoreServerRemote)Naming.lookup("//puppygames.net/applet_hiscore_server");
                        HiscoresScreen.this.doSubmit = false;
                        HiscoresReturn ret = server.submit2(score);
                        if (HiscoresScreen.this.remoteHiscores) {
                            HiscoresScreen.this.setScoreList(ret.getScores());
                        }
                        if (ret.getMessage() != null) {
                            StringTokenizer st = new StringTokenizer(ret.getMessage(), "\n", false);
                            LinkedList<String> tokens = new LinkedList<String>();
                            while (st.hasMoreTokens()) {
                                tokens.add(st.nextToken());
                            }
                            int h = tokens.size() * Res.getBigFont().getHeight();
                            int y = (Game.getHeight() - h) / 2 + (tokens.size() - 1) * Res.getBigFont().getHeight();
                            int delay = 0;
                            Iterator i = tokens.iterator();
                            while (i.hasNext()) {
                                LabelEffect le = new LabelEffect(Res.getBigFont(), (String)i.next(), ReadableColor.WHITE, ReadableColor.CYAN, 240, 120);
                                le.setLocation(Game.getWidth() / 2, y);
                                y -= Res.getBigFont().getHeight();
                                le.setDelay(delay);
                                delay += 30;
                                le.setSound(SFX.getTextEnteredBuffer());
                                le.spawn(instance);
                            }
                        }
                        Game.onRemoteCallSuccess();
                    }
                    catch (SQLException e) {
                        e.printStackTrace(System.err);
                        Game.onRemoteCallSuccess();
                        Res.getErrorDialog().doModal(Game.getMessage("lwjglapplets.hiscoresscreen.problems"), e.getMessage());
                        HiscoresScreen.this.phase = 0;
                        HiscoresScreen.this.progress.setFinished(true);
                        HiscoresScreen.this.progress = null;
                        HiscoresScreen.this.tick = 0;
                        HiscoresScreen.this.enableButtons();
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        Res.getErrorDialog().doModal("PROBLEMS", e.getMessage());
                        HiscoresScreen.this.phase = 0;
                        HiscoresScreen.this.progress.setFinished(true);
                        HiscoresScreen.this.progress = null;
                        HiscoresScreen.this.tick = 0;
                        HiscoresScreen.this.enableButtons();
                    }
                }
                finally {
                    HiscoresScreen.this.phase = 0;
                    HiscoresScreen.this.progress.setFinished(true);
                    HiscoresScreen.this.progress = null;
                    HiscoresScreen.this.tick = 0;
                    HiscoresScreen.this.enableButtons();
                }
            }
        }.start();
    }

    private void submitLocalScore(Score score) {
        this.doSubmit = false;
        allScores.add(score);
        Collections.sort(allScores);
        GameOutputStream gos = null;
        ObjectOutputStream oos = null;
        try {
            try {
                gos = new GameOutputStream(this.getHiscoreFileName());
                oos = new ObjectOutputStream(gos);
                oos.writeObject(allScores);
                oos.flush();
                gos.flush();
                this.phase = 0;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                Res.getErrorDialog().doModal(Game.getMessage("lwjglapplets.hiscoresscreen.problems"), String.valueOf(Game.getMessage("lwjglapplets.hiscoresscreen.problemsaving")) + " (" + e + ")");
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (gos != null) {
                    try {
                        gos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.enableButtons();
            }
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception exception) {}
            }
            if (gos != null) {
                try {
                    gos.close();
                }
                catch (Exception exception) {}
            }
            this.enableButtons();
        }
    }

    @Override
    protected void onResized() {
        Area registeredArea = this.getArea(REGISTERED_COORDS);
        if (registeredArea != null) {
            this.registeredCoords = registeredArea.getBounds();
        }
        this.rankCoords = this.getArea(RANK_COORDS).getBounds();
        this.nameCoords = this.getArea(NAME_COORDS).getBounds();
        this.scoreCoords = this.getArea(SCORE_COORDS).getBounds();
        for (Row row : rows) {
            row.onResized();
        }
    }

    class Row {
        int pos;
        String rank;
        String points;
        GLTextArea rankLabel;
        GLTextArea pointsLabel;
        Score score;
        TextField field;
        final Color color = new Color(Color.WHITE);
        Sprite registeredSprite;

        Row(int pos, Score score) {
            this.score = score;
            this.pos = pos;
            this.rank = String.valueOf(score.getRank() + 1);
            this.points = String.valueOf(score.getPoints());
            if (HiscoresScreen.this.registeredAppearanceResource != null) {
                this.registeredSprite = HiscoresScreen.this.allocateSprite((Serializable)((Object)HiscoresScreen.this));
                if (this.registeredSprite != null) {
                    this.registeredSprite.setVisible(score.isRegistered());
                    this.registeredSprite.setAppearance(HiscoresScreen.this.registeredAppearanceResource);
                    this.registeredSprite.setLayer(4);
                }
            }
            this.rankLabel = new GLTextArea();
            this.rankLabel.setHorizontalAlignment(TextLayout.RIGHT);
            this.rankLabel.setVerticalAlignment(GLTextArea.TOP);
            this.rankLabel.setFont(HiscoresScreen.this.rankFontResource);
            this.rankLabel.setText(this.rank);
            this.rankLabel.setColour((ReadableColor)HiscoresScreen.this.rankColor);
            this.pointsLabel = new GLTextArea();
            this.pointsLabel.setHorizontalAlignment(TextLayout.RIGHT);
            this.pointsLabel.setVerticalAlignment(GLTextArea.TOP);
            this.pointsLabel.setFont(HiscoresScreen.this.scoreFontResource);
            this.pointsLabel.setText(this.points);
            this.pointsLabel.setColour((ReadableColor)HiscoresScreen.this.scoreColor);
            this.field = new TextField(24, HiscoresScreen.this.nameCoords.getWidth()){

                protected void onEdited() {
                    SFX.keyTyped();
                }

                protected void onChangeFocus() {
                    SFX.textEntered();
                    HiscoresScreen.this.setKeyboardNavigationEnabled(true);
                    Row.this.score.setName(Row.this.field.getText().trim());
                    HiscoresScreen.this.submitLocalScore(Row.this.score);
                    if (MiniGame.getSubmitRemoteHiscores()) {
                        HiscoresScreen.this.submitRemoteScore(Row.this.score);
                    }
                }
            };
            this.field.setAllCaps(true);
            this.field.setText(score.getName().toUpperCase());
            this.field.setFont(HiscoresScreen.this.nameFontResource);
            this.field.setColour((ReadableColor)HiscoresScreen.this.nameColor);
            this.onResized();
        }

        void onResized() {
            int rowYPos = HiscoresScreen.this.rankCoords.getY() + HiscoresScreen.this.yPos - this.pos * HiscoresScreen.this.yGap;
            if (this.registeredSprite != null && HiscoresScreen.this.registeredCoords != null) {
                this.registeredSprite.setLocation((float)HiscoresScreen.this.registeredCoords.getX(), (float)(HiscoresScreen.this.registeredCoords.getY() + rowYPos), 0.0f);
            }
            this.rankLabel.setBounds(HiscoresScreen.this.rankCoords.getX(), rowYPos - Res.getSmallFont().getDescent(), HiscoresScreen.this.rankCoords.getWidth(), Res.getSmallFont().getHeight());
            this.pointsLabel.setBounds(HiscoresScreen.this.scoreCoords.getX(), rowYPos - Res.getSmallFont().getDescent(), HiscoresScreen.this.scoreCoords.getWidth(), Res.getSmallFont().getHeight());
            this.field.setLocation(HiscoresScreen.this.nameCoords.getX(), HiscoresScreen.this.nameCoords.getY() + HiscoresScreen.this.yPos - this.pos * HiscoresScreen.this.yGap);
            this.field.setWidth(HiscoresScreen.this.nameCoords.getWidth());
        }

        void render(SimpleRenderer renderer) {
            renderer.glRender(new GLRenderable(){

                public void render() {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)1.0f, (float)-1.0f, (float)0.0f);
                }
            });
            renderer.glColor4f(0.0f, 0.0f, 0.0f, 0.5f);
            this.rankLabel.render(renderer);
            this.pointsLabel.render(renderer);
            this.field.render(renderer);
            renderer.glRender(new GLRenderable(){

                public void render() {
                    GL11.glPopMatrix();
                }
            });
            ColorUtil.setGLColorPre((ReadableColor)this.color, (SimpleRenderer)renderer);
        }

        void tick() {
            this.field.tick();
        }

        void remove() {
            if (this.registeredSprite != null) {
                this.registeredSprite.deallocate();
                this.registeredSprite = null;
            }
        }
    }
}

