/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.util.ArrayList;
import java.util.List;
import net.puppygames.applet.Anchor;
import net.puppygames.applet.Bounded;
import net.puppygames.applet.effects.EffectFeature;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import org.w3c.dom.Element;

public abstract class SimpleBaseEffectFeature
extends EffectFeature {
    protected Color startColor;
    protected Color endColor;
    protected int duration;
    protected int fadeDuration;
    private int x;
    private int y;
    private int w;
    private int h;
    private List<Anchor> anchors;

    public SimpleBaseEffectFeature() {
    }

    public SimpleBaseEffectFeature(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List anchorElements = XMLUtil.getChildren((Element)element, (String)"anchor");
        if (anchorElements.size() > 0) {
            this.anchors = new ArrayList<Anchor>(anchorElements.size());
            for (Element anchorChild : anchorElements) {
                Anchor anchor = (Anchor)loader.load(anchorChild);
                this.anchors.add(anchor);
            }
        }
    }

    public final int getX() {
        if (this.anchors == null) {
            return this.x;
        }
        BoundedThing bt = new BoundedThing();
        for (Anchor a : this.anchors) {
            a.apply(bt);
        }
        return bt.getBounds().getX();
    }

    public final int getY() {
        if (this.anchors == null) {
            return this.y;
        }
        BoundedThing bt = new BoundedThing();
        for (Anchor a : this.anchors) {
            a.apply(bt);
        }
        return bt.getBounds().getY();
    }

    public final int getWidth() {
        if (this.anchors == null) {
            return this.w;
        }
        BoundedThing bt = new BoundedThing();
        for (Anchor a : this.anchors) {
            a.apply(bt);
        }
        return bt.getBounds().getWidth();
    }

    public final int getHeight() {
        if (this.anchors == null) {
            return this.h;
        }
        BoundedThing bt = new BoundedThing();
        for (Anchor a : this.anchors) {
            a.apply(bt);
        }
        return bt.getBounds().getHeight();
    }

    private class BoundedThing
    implements Bounded {
        Rectangle r;

        private BoundedThing() {
            this.r = new Rectangle(SimpleBaseEffectFeature.this.x, SimpleBaseEffectFeature.this.y, 0, 0);
        }

        public ReadableRectangle getBounds() {
            return this.r;
        }

        public void setBounds(int x, int y, int w, int h) {
            this.r.setBounds(x, y, w, h);
        }
    }
}

