/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.sprites.Appearance;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import java.io.Serializable;
import java.util.ArrayList;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Tickable;
import net.puppygames.applet.effects.Emitter;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadablePoint;

public class Particle
implements Tickable {
    private final Color color = new Color();
    public static final ParticlePool POOL = new ParticlePool();
    private static int maxParticles = 1024;
    private static int maxPixels = -1;
    private static int totalPixels;
    private static int numParticles;
    private static int falloffCount;
    private Emitter parent;
    private String tag;
    boolean fromPool;
    boolean pooled;
    float x;
    float y;
    float angle;
    float velocity;
    float acceleration;
    float ax;
    float ay;
    float vx;
    float vy;
    int tick;
    int duration;
    int fadeDuration;
    ReadableColor startColor;
    ReadableColor endColor;
    boolean fading;
    boolean finished;
    float scale = 1.0f;
    float endScale = 1.0f;
    float startScale = 1.0f;
    Sprite sprite;
    Appearance appearance;
    Emitter emitter;
    boolean floorSet;
    boolean ceilingSet;
    boolean leftWallSet;
    boolean rightWallSet;
    float rotation;
    boolean relativeRotation;
    float floor;
    float ceiling;
    float leftWall;
    float rightWall;
    int layer = 1;
    int subLayer = 0;
    int size = 0;
    float yOffset;
    boolean doYOffset;
    boolean forced;

    private Particle() {
    }

    private void init(Emitter parent, float x, float y, float yOffset, float angle, float velocity, float acceleration, int duration, int fadeDuration, ReadableColor startColor, ReadableColor endColor) {
        this.parent = parent;
        this.tag = parent.getTag();
        this.x = x;
        this.y = y;
        this.yOffset = yOffset;
        this.angle = angle;
        this.velocity = velocity;
        this.acceleration = acceleration;
        this.duration = duration;
        this.fadeDuration = fadeDuration;
        this.startColor = startColor;
        this.endColor = endColor;
        this.ax = 0.0f;
        this.ay = 0.0f;
        this.vx = 0.0f;
        this.vy = 0.0f;
        this.tick = 0;
        this.fading = false;
        this.finished = false;
        this.startScale = 1.0f;
        this.endScale = 1.0f;
        this.scale = 1.0f;
        this.sprite = null;
        this.appearance = null;
        this.emitter = null;
        this.floorSet = false;
        this.ceilingSet = false;
        this.leftWallSet = false;
        this.rightWallSet = false;
        this.floor = 0.0f;
        this.ceiling = 0.0f;
        this.leftWall = 0.0f;
        this.rightWall = 0.0f;
        this.layer = 1;
        this.subLayer = 0;
        this.rotation = 0.0f;
        this.relativeRotation = false;
        this.size = 0;
        this.doYOffset = false;
        this.forced = false;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public void setRelativeRotation(boolean relativeRotation) {
        this.relativeRotation = relativeRotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public void setAppearance(Appearance appearance) {
        this.appearance = appearance;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public void setAx(float ax) {
        this.ax = ax;
    }

    public void setAy(float ay) {
        this.ay = ay;
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
        emitter.setLocation(this.x, this.y);
        emitter.setYOffset(this.yOffset);
        emitter.setOffset(this.parent.getOffset());
    }

    public void spawn(Screen screen) {
        if (this.emitter != null) {
            this.emitter.setLocation(this.x, this.y);
            this.emitter.setYOffset(this.yOffset);
        }
        if (!this.forced) {
            if (numParticles > maxParticles) {
                return;
            }
            if ((float)numParticles > (float)maxParticles * 0.75f) {
                if (++falloffCount < 3) {
                    return;
                }
                falloffCount = 0;
            } else if ((float)numParticles > (float)maxParticles * 0.66f) {
                if (++falloffCount < 2) {
                    return;
                }
                falloffCount = 0;
            }
            if (maxPixels != -1) {
                if (totalPixels > maxPixels) {
                    return;
                }
                if ((float)totalPixels > (float)maxPixels * 0.75f) {
                    if (++falloffCount < 3) {
                        return;
                    }
                    falloffCount = 0;
                } else if ((float)totalPixels > (float)maxPixels * 0.66f) {
                    if (++falloffCount < 2) {
                        return;
                    }
                    falloffCount = 0;
                }
            }
        }
        this.sprite = screen.allocateSprite((Serializable)((Object)screen));
        if (this.sprite != null) {
            if (this.appearance != null) {
                this.sprite.setAppearance(this.appearance);
            } else {
                this.sprite.setImage(Res.getParticleImage());
            }
            this.sprite.setVisible(this.parent.isVisible());
            screen.addTickable(this);
            this.sprite.setLayer(this.layer);
            this.sprite.setSubLayer(this.subLayer);
            this.sprite.setLocation(this.x, this.y, 0.0f);
            this.sprite.setOffset(0.0f, this.yOffset, 0.0f);
            ++numParticles;
        }
    }

    public void remove() {
        if (this.sprite != null) {
            this.sprite.deallocate();
            this.sprite = null;
            --numParticles;
        }
        if (this.emitter != null) {
            this.emitter.remove();
            this.emitter = null;
        }
        Particle.POOL.release(this);
    }

    public static int getNumParticles() {
        return numParticles;
    }

    public static int getTotalPixels() {
        return totalPixels;
    }

    public void tick() {
        ++this.tick;
        float dx = this.velocity * (float)Math.cos(Math.toRadians(this.angle));
        float dy = this.velocity * (float)Math.sin(Math.toRadians(this.angle));
        this.velocity += this.acceleration;
        if (this.velocity <= 0.0f) {
            this.velocity = 0.0f;
            this.acceleration = 0.0f;
        }
        this.vx += this.ax;
        this.vy += this.ay;
        this.x += dx + this.vx;
        if (this.doYOffset) {
            this.yOffset += dy + this.vy;
        } else {
            this.y += dy + this.vy;
        }
        if (this.leftWallSet && this.x < this.leftWall) {
            this.vx = -this.vx;
            dx = -dx;
            this.angle = (float)Math.atan2(dy + this.vy, dx + this.vx);
            this.x = this.leftWall + this.leftWall - this.x;
        } else if (this.rightWallSet && this.x > this.rightWall) {
            this.vx = -this.vx;
            dx = -dx;
            this.angle = (float)Math.atan2(dy + this.vy, dx + this.vx);
            this.x = this.rightWall - (this.x - this.rightWall);
        }
        if (this.doYOffset) {
            if (this.floorSet && this.yOffset + this.y < this.floor) {
                this.vy = -this.vy;
                dy = -dy;
                this.angle = (float)Math.atan2(dy + this.vy, dx + this.vx);
                this.yOffset = this.floor + this.floor - this.yOffset;
            } else if (this.ceilingSet && this.yOffset + this.y > this.ceiling) {
                this.vy = -this.vy;
                dy = -dy;
                this.angle = (float)Math.atan2(dy + this.vy, dx + this.vx);
                this.yOffset = this.ceiling - (this.yOffset - this.ceiling);
            }
        } else if (this.floorSet && this.y < this.floor) {
            this.vy = -this.vy;
            dy = -dy;
            this.angle = (float)Math.atan2(dy + this.vy, dx + this.vx);
            this.y = this.floor + this.floor - this.y;
        } else if (this.ceilingSet && this.y > this.ceiling) {
            this.vy = -this.vy;
            dy = -dy;
            this.angle = (float)Math.atan2(dy + this.vy, dx + this.vx);
            this.y = this.ceiling - (this.y - this.ceiling);
        }
        if (this.emitter != null) {
            this.emitter.setLocation(this.x, this.y);
            this.emitter.setYOffset(this.yOffset);
        }
        if (this.fading) {
            float ratio = (float)this.tick / (float)this.fadeDuration;
            this.color.setColor(this.endColor);
            this.color.setAlpha(255 - (int)((float)this.endColor.getAlpha() * ratio));
            this.sprite.setScale(FPMath.fpValue((float)LinearInterpolator.instance.interpolate(this.scale, this.endScale, ratio)));
            if (this.tick == this.fadeDuration) {
                this.finished = true;
                this.tick = 0;
            }
        } else {
            float ratio = (float)this.tick / (float)this.duration;
            ColorInterpolator.interpolate((ReadableColor)this.startColor, (ReadableColor)this.endColor, (float)ratio, (Interpolator)LinearInterpolator.instance, (Color)this.color);
            this.sprite.setScale(FPMath.fpValue((float)LinearInterpolator.instance.interpolate(this.startScale, this.scale, ratio)));
            if (this.tick >= this.duration) {
                this.fading = true;
                this.tick = 0;
            }
        }
        this.sprite.setColors((ReadableColor)this.color);
        this.sprite.setAngle(FPMath.fpYaklyDegrees((double)Math.toRadians(this.relativeRotation ? this.angle + this.rotation : this.rotation)));
    }

    public void update() {
        ReadablePoint offset = this.parent.getOffset();
        int xx = (int)this.x;
        int yy = (int)this.y;
        if (offset != null) {
            xx += offset.getX();
            yy += offset.getY();
        }
        if (this.doYOffset) {
            this.sprite.setLocation((float)xx, (float)yy, 0.0f);
            this.sprite.setOffset(0.0f, this.yOffset, 0.0f);
        } else {
            this.sprite.setLocation((float)xx, (float)yy, 0.0f);
        }
        this.sprite.setVisible(this.parent.isVisible());
    }

    public void setDoYOffset(boolean doYOffset) {
        this.doYOffset = doYOffset;
    }

    public boolean isActive() {
        return this.sprite != null && !this.finished;
    }

    public void setCeiling(float ceiling) {
        this.ceiling = ceiling;
        this.ceilingSet = true;
        if (this.emitter != null) {
            this.emitter.setCeiling(ceiling);
        }
    }

    public void setFloor(float floor) {
        this.floor = floor;
        this.floorSet = true;
        if (this.emitter != null) {
            this.emitter.setFloor(floor);
        }
    }

    public void setLeftWall(float leftWall) {
        this.leftWall = leftWall;
        this.leftWallSet = true;
        if (this.emitter != null) {
            this.emitter.setLeftWall(leftWall);
        }
    }

    public void setRightWall(float rightWall) {
        this.rightWall = rightWall;
        this.rightWallSet = true;
        if (this.emitter != null) {
            this.emitter.setRightWall(rightWall);
        }
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setEndScale(float endScale) {
        this.endScale = endScale;
    }

    public void setStartScale(float startScale) {
        this.startScale = startScale;
    }

    public static void setMaxParticles(int maxParticles) {
        Particle.maxParticles = maxParticles;
    }

    public static void setMaxPixels(int maxPixels) {
        Particle.maxPixels = maxPixels;
    }

    public static int getMaxParticles() {
        return maxParticles;
    }

    public static int getMaxPixels() {
        return maxPixels;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setSubLayer(int subLayer) {
        this.subLayer = subLayer;
    }

    /* synthetic */ Particle(Particle particle) {
        this();
    }

    static class ParticlePool {
        private final ArrayList<Particle> pool = new ArrayList(1024);

        ParticlePool() {
        }

        Particle obtain(Emitter parent, float x, float y, float yOffset, float angle, float velocity, float acceleration, int duration, int fadeDuration, ReadableColor startColor, ReadableColor endColor) {
            Particle ret;
            if (this.pool.size() == 0) {
                ret = new Particle(null);
                ret.fromPool = true;
            } else {
                ret = this.pool.remove(this.pool.size() - 1);
                assert (ret.fromPool) : "Node not from pool found in pool!";
                assert (ret.pooled) : "Node wasn't pooled but we found it in the pool!";
                ret.pooled = false;
            }
            ret.init(parent, x, y, yOffset, angle, velocity, acceleration, duration, fadeDuration, startColor, endColor);
            return ret;
        }

        private void release(Particle particle) {
            assert (particle.fromPool) : "Node not from pool attempt to place in pool!";
            assert (!particle.pooled) : "Node should already be in the pool!";
            particle.pooled = true;
            this.pool.add(particle);
        }
    }
}

