/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import net.puppygames.applet.effects.Effect;

public abstract class FadeEffect
extends Effect {
    private final int duration;
    private final int fadeDuration;
    private int tick;
    private boolean fading;
    private int alpha = 255;

    public FadeEffect(int duration, int fadeDuration) {
        this.duration = duration;
        this.fadeDuration = fadeDuration;
    }

    public void reset() {
        this.fading = false;
        this.tick = 0;
        this.alpha = 255;
    }

    public void finish() {
        if (!this.fading) {
            this.fading = true;
            this.tick = 0;
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    protected final void doTick() {
        ++this.tick;
        if (this.fading) {
            this.alpha = (int)LinearInterpolator.instance.interpolate(255.0f, 0.0f, (float)this.tick / (float)this.fadeDuration);
        } else if (this.tick >= this.duration) {
            this.fading = true;
            this.tick = 0;
        }
        this.onTicked();
    }

    protected void onTicked() {
    }

    public boolean isEffectActive() {
        return !this.fading || this.tick < this.fadeDuration;
    }

    protected final void render() {
    }
}

