/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.Data;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.Range;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sprites.Appearance;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.Particle;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadablePoint;

public class EmitterFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final int MARGIN = 48;
    @Data
    private String tag;
    private Range duration;
    private boolean infinite;
    private Range particlesPerTick;
    private int maxParticles;
    private String appearance;
    private int layer;
    private int subLayer;
    private String next;
    private Range velocity;
    private Range acceleration;
    private Range radius;
    private Range startScale;
    private Range scale;
    private Range endScale;
    private Range gravityX;
    private Range gravityY;
    private Range particleDuration;
    private Range fadeDuration;
    private Range startHue;
    private Range startSaturation;
    private Range startBrightness;
    private Range endHue;
    private Range endSaturation;
    private Range endBrightness;
    private Range angle;
    private String sound;
    private float startPitch;
    private float endPitch;
    private float startVolume;
    private float endVolume;
    private EmitterFeature chain;
    private EmitterFeature slave;
    private float x;
    private float y;
    private float yOffset;
    private Range delay;
    private Range delayAfter;
    private boolean rotate;
    private boolean relativeRotate;
    private int interpolation;
    private Range emitterScale;
    private boolean dontAttenuate;
    private boolean doYOffset;
    private transient EmitterFeature nextFeature;
    private transient Appearance appearanceResource;
    private transient ALBuffer soundResource;

    public EmitterFeature() {
    }

    public EmitterFeature(String name) {
        super(name);
    }

    public Emitter spawn(Screen screen) {
        EmitterInstance ret = new EmitterInstance(null, screen);
        ret.spawn(screen);
        return ret;
    }

    private Emitter spawn(EmitterInstance parent, Screen screen) {
        EmitterInstance ret = new EmitterInstance(parent, screen);
        ret.spawn(screen);
        return ret;
    }

    public Range getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(Range acceleration) {
        this.acceleration = acceleration;
    }

    public Range getAngle() {
        return this.angle;
    }

    public void setAngle(Range angle) {
        this.angle = angle;
    }

    public String getAppearance() {
        return this.appearance;
    }

    public void setAppearance(String appearance) {
        this.appearance = appearance;
    }

    public EmitterFeature getChain() {
        return this.chain;
    }

    public void setChain(EmitterFeature chain) {
        this.chain = chain;
    }

    public Range getDuration() {
        return this.duration;
    }

    public void setDuration(Range duration) {
        this.duration = duration;
    }

    public Range getEndBrightness() {
        return this.endBrightness;
    }

    public void setEndBrightness(Range endBrightness) {
        this.endBrightness = endBrightness;
    }

    public Range getEndHue() {
        return this.endHue;
    }

    public void setEndHue(Range endHue) {
        this.endHue = endHue;
    }

    public float getEndPitch() {
        return this.endPitch;
    }

    public void setEndPitch(float endPitch) {
        this.endPitch = endPitch;
    }

    public Range getEndSaturation() {
        return this.endSaturation;
    }

    public void setEndSaturation(Range endSaturation) {
        this.endSaturation = endSaturation;
    }

    public Range getEndScale() {
        return this.endScale;
    }

    public void setEndScale(Range endScale) {
        this.endScale = endScale;
    }

    public float getEndVolume() {
        return this.endVolume;
    }

    public void setEndVolume(float endVolume) {
        this.endVolume = endVolume;
    }

    public Range getFadeDuration() {
        return this.fadeDuration;
    }

    public void setFadeDuration(Range fadeDuration) {
        this.fadeDuration = fadeDuration;
    }

    public Range getGravityX() {
        return this.gravityX;
    }

    public void setGravityX(Range gravityX) {
        this.gravityX = gravityX;
    }

    public Range getGravityY() {
        return this.gravityY;
    }

    public void setGravityY(Range gravityY) {
        this.gravityY = gravityY;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public void setInfinite(boolean infinite) {
        this.infinite = infinite;
    }

    public Range getParticleDuration() {
        return this.particleDuration;
    }

    public void setParticleDuration(Range particleDuration) {
        this.particleDuration = particleDuration;
    }

    public Range getParticlesPerTick() {
        return this.particlesPerTick;
    }

    public void setParticlesPerTick(Range particlesPerTick) {
        this.particlesPerTick = particlesPerTick;
    }

    public Range getRadius() {
        return this.radius;
    }

    public void setRadius(Range radius) {
        this.radius = radius;
    }

    public Range getScale() {
        return this.scale;
    }

    public void setScale(Range scale) {
        this.scale = scale;
    }

    public void setStartScale(Range startScale) {
        this.startScale = startScale;
    }

    public Range getStartScale() {
        return this.startScale;
    }

    public EmitterFeature getSlave() {
        return this.slave;
    }

    public void setSlave(EmitterFeature slave) {
        this.slave = slave;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public Range getStartBrightness() {
        return this.startBrightness;
    }

    public void setStartBrightness(Range startBrightness) {
        this.startBrightness = startBrightness;
    }

    public Range getStartHue() {
        return this.startHue;
    }

    public void setStartHue(Range startHue) {
        this.startHue = startHue;
    }

    public float getStartPitch() {
        return this.startPitch;
    }

    public void setStartPitch(float startPitch) {
        this.startPitch = startPitch;
    }

    public Range getStartSaturation() {
        return this.startSaturation;
    }

    public void setStartSaturation(Range startSaturation) {
        this.startSaturation = startSaturation;
    }

    public float getStartVolume() {
        return this.startVolume;
    }

    public void setStartVolume(float startVolume) {
        this.startVolume = startVolume;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public int getLayer() {
        return this.layer;
    }

    public Range getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Range velocity) {
        this.velocity = velocity;
    }

    public void setDelay(Range delay) {
        this.delay = delay;
    }

    public Range getDelay() {
        return this.delay;
    }

    public Range getDelayAfter() {
        return this.delayAfter;
    }

    public void setDelayAfter(Range delayAfter) {
        this.delayAfter = delayAfter;
    }

    public boolean isRelativeRotate() {
        return this.relativeRotate;
    }

    public boolean getRotate() {
        return this.rotate;
    }

    public void setRotate(boolean rotate) {
        this.rotate = rotate;
    }

    public void setRelativeRotate(boolean relativeRotate) {
        this.relativeRotate = relativeRotate;
    }

    public void setInterpolation(int interpolation) {
        this.interpolation = interpolation;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    public Range getEmitterScale() {
        return this.emitterScale;
    }

    public void setEmitterScale(Range emitterScale) {
        this.emitterScale = emitterScale;
    }

    public void setDontAttenuate(boolean dontAttenuate) {
        this.dontAttenuate = dontAttenuate;
    }

    public boolean isDontAttenuate() {
        return this.dontAttenuate;
    }

    public boolean isDoYOffset() {
        return this.doYOffset;
    }

    public void setDoYOffset(boolean doYOffset) {
        this.doYOffset = doYOffset;
    }

    public int getSubLayer() {
        return this.subLayer;
    }

    public void setSubLayer(int subLayer) {
        this.subLayer = subLayer;
    }

    public int getMaxParticles() {
        return this.maxParticles;
    }

    public void setMaxParticles(int maxParticles) {
        this.maxParticles = maxParticles;
    }

    public class EmitterInstance
    extends Emitter {
        private boolean delayed;
        private int tick;
        private int actualDuration;
        private int actualDelay;
        private float ix;
        private float iy;
        private float iyo;
        private final Screen screen;
        private final EmitterInstance parent;
        private EmitterInstance chainInstance;
        private boolean finished;
        private boolean done;
        private SoundEffect soundEffect;
        private boolean soundWasLooped;
        private float oldx;
        private float oldy;
        private float oldYoffset;
        private boolean doInterpolate;
        private boolean delayingAfter;
        private float instanceScale;
        private int numParticles;

        private EmitterInstance(EmitterInstance parent, Screen screen) {
            this.screen = screen;
            this.parent = parent;
            if (parent != null) {
                this.setLocation(parent.ix + EmitterFeature.this.x, parent.iy + EmitterFeature.this.y);
                this.setYOffset(parent.iyo + EmitterFeature.this.yOffset);
            } else {
                this.setLocation(EmitterFeature.this.x, EmitterFeature.this.y);
                this.setYOffset(EmitterFeature.this.yOffset);
            }
        }

        protected void doSpawnEffect() {
            this.initEmitter();
        }

        private EmitterFeature getFeature() {
            return EmitterFeature.this;
        }

        public void setYOffset(float yOffset) {
            this.iyo = yOffset;
            if (this.chainInstance != null) {
                this.chainInstance.setYOffset(yOffset + this.chainInstance.getFeature().yOffset);
            }
        }

        protected void playSound(ALBuffer sound) {
        }

        public String getTag() {
            return EmitterFeature.this.tag;
        }

        private void initEmitter() {
            if (EmitterFeature.this.delay == null) {
                this.actualDelay = 0;
                if (!(EmitterFeature.this.soundResource == null || this.soundEffect != null && this.soundWasLooped)) {
                    this.soundEffect = this.getAttenuator() != null && !EmitterFeature.this.dontAttenuate ? Game.allocateSound(EmitterFeature.this.soundResource, this.getAttenuator().getVolume(this.ix, this.iy), 1.0f, this) : Game.allocateSound(EmitterFeature.this.soundResource, 1.0f, 1.0f, this);
                    this.soundWasLooped = EmitterFeature.this.soundResource.isLooped();
                }
            } else {
                this.actualDelay = (int)EmitterFeature.this.delay.getValue();
                this.delayed = this.actualDelay > 0;
            }
            this.actualDuration = EmitterFeature.this.duration == null ? 0 : (int)EmitterFeature.this.duration.getValue();
            if (EmitterFeature.this.nextFeature != null) {
                if (this.chainInstance != null) {
                    this.chainInstance.remove();
                    this.chainInstance = null;
                }
                this.chainInstance = (EmitterInstance)EmitterFeature.this.nextFeature.spawn(this, this.screen);
            }
            if (EmitterFeature.this.chain != null) {
                if (this.chainInstance != null) {
                    this.chainInstance.remove();
                    this.chainInstance = null;
                }
                this.chainInstance = (EmitterInstance)EmitterFeature.this.chain.spawn(this, this.screen);
            }
            this.instanceScale = EmitterFeature.this.emitterScale == null ? 1.0f : EmitterFeature.this.emitterScale.getValue();
            this.doInterpolate = false;
            this.numParticles = 0;
        }

        public void setLocation(float x, float y) {
            this.ix = x;
            this.iy = y;
            if (this.chainInstance != null) {
                this.chainInstance.setLocation(x + this.chainInstance.getFeature().x, y + this.chainInstance.getFeature().y);
            }
        }

        public void setOffset(ReadablePoint offset) {
            super.setOffset(offset);
            if (this.chainInstance != null) {
                this.chainInstance.setOffset(offset);
            }
        }

        public void setGain(float gain) {
            this.gain = gain;
            if (this.soundEffect != null) {
                if (this.getAttenuator() != null && !EmitterFeature.this.dontAttenuate) {
                    this.soundEffect.setGain(EmitterFeature.this.soundResource.getGain() * gain * Game.getSFXVolume() * this.getAttenuator().getVolume(this.ix, this.iy + this.iyo), (Object)this);
                } else {
                    this.soundEffect.setGain(EmitterFeature.this.soundResource.getGain() * gain * Game.getSFXVolume(), (Object)this);
                }
            }
        }

        protected void doUpdate() {
            if (this.soundEffect == null || EmitterFeature.this.soundResource == null) {
                return;
            }
            if (this.getAttenuator() != null && !EmitterFeature.this.dontAttenuate) {
                this.soundEffect.setGain(EmitterFeature.this.soundResource.getGain() * this.gain * Game.getSFXVolume() * this.getAttenuator().getVolume(this.ix, this.iy + this.iyo), (Object)this);
            }
        }

        protected void doTick() {
            if (this.finished) {
                return;
            }
            ++this.tick;
            float xx = this.ix;
            float yy = this.iy;
            float oyy = this.iyo;
            if (this.delayed) {
                if (this.tick <= this.actualDelay) {
                    return;
                }
                this.delayed = false;
                this.tick = 0;
                if (this.delayingAfter) {
                    this.delayingAfter = false;
                    this.initEmitter();
                } else if (EmitterFeature.this.soundResource != null) {
                    if (this.soundEffect != null && this.soundWasLooped) {
                        this.soundEffect.setLooped(false, (Object)this);
                        this.soundEffect = null;
                    }
                    this.soundEffect = this.getAttenuator() != null && !EmitterFeature.this.dontAttenuate ? Game.allocateSound(EmitterFeature.this.soundResource, this.getAttenuator().getVolume(xx, yy + oyy), 1.0f, this) : Game.allocateSound(EmitterFeature.this.soundResource, 1.0f, 1.0f, this);
                    this.soundWasLooped = EmitterFeature.this.soundResource.isLooped();
                }
            }
            if (EmitterFeature.this.getInterpolation() == 0 || !this.doInterpolate) {
                this.emit(xx, yy, oyy);
                this.doInterpolate = true;
            } else {
                double dx = xx - this.oldx;
                double dy = yy - this.oldy;
                double doy = oyy - this.oldYoffset;
                double dist = Math.sqrt(dx * dx + dy * dy + doy * doy);
                int steps = (int)(dist / (double)EmitterFeature.this.getInterpolation() + 0.5);
                int i = 1;
                while (i <= steps && (EmitterFeature.this.maxParticles == 0 || this.numParticles < EmitterFeature.this.maxParticles)) {
                    float ratio = (float)i / (float)steps;
                    float xxx = LinearInterpolator.instance.interpolate(this.oldx, xx, ratio);
                    float yyy = LinearInterpolator.instance.interpolate(this.oldy, yy, ratio);
                    float oyyy = LinearInterpolator.instance.interpolate(this.oldYoffset, oyy, ratio);
                    this.emit(xxx, yyy, oyyy);
                    ++i;
                }
            }
            this.oldx = xx;
            this.oldy = yy;
            this.oldYoffset = this.iyo;
        }

        private void emit(float xx, float yy, float oyy) {
            if (this.isVisible()) {
                float offsetYpos;
                float offsetXpos;
                int n = EmitterFeature.this.particlesPerTick == null ? 0 : (int)(EmitterFeature.this.particlesPerTick.getValue() + 0.5f);
                ReadablePoint offset = this.getOffset();
                if (offset != null) {
                    offsetXpos = (float)offset.getX() + xx;
                    offsetYpos = (float)offset.getY() + yy + oyy;
                } else {
                    offsetXpos = xx;
                    offsetYpos = yy + oyy;
                }
                if (offsetXpos < -48.0f || offsetYpos < -48.0f || offsetXpos > (float)(this.screen.getWidth() + 48) || offsetYpos > (float)(this.screen.getHeight() + 48)) {
                    this.numParticles += n;
                } else {
                    int i = 0;
                    while (i < n && (EmitterFeature.this.maxParticles == 0 || this.numParticles < EmitterFeature.this.maxParticles)) {
                        Color endColor;
                        Color startColor;
                        ++this.numParticles;
                        if (EmitterFeature.this.startHue == null) {
                            startColor = new Color(ReadableColor.WHITE);
                        } else {
                            startColor = new Color();
                            startColor.fromHSB(EmitterFeature.this.startHue.getValue(), EmitterFeature.this.startSaturation == null ? 1.0f : EmitterFeature.this.startSaturation.getValue(), EmitterFeature.this.startBrightness == null ? 1.0f : EmitterFeature.this.startBrightness.getValue());
                        }
                        if (EmitterFeature.this.endHue == null) {
                            endColor = startColor;
                        } else {
                            endColor = new Color();
                            endColor.fromHSB(EmitterFeature.this.endHue.getValue(), EmitterFeature.this.endSaturation == null ? 1.0f : EmitterFeature.this.endSaturation.getValue(), EmitterFeature.this.endBrightness == null ? 1.0f : EmitterFeature.this.endBrightness.getValue());
                        }
                        float xxx = xx;
                        float yyy = yy;
                        float oyyy = oyy;
                        if (EmitterFeature.this.radius != null) {
                            float r = EmitterFeature.this.radius.getValue() * this.instanceScale;
                            double randomRadiusAngle = Math.random() * 2.0 * Math.PI;
                            xxx = (float)((double)xxx + (double)r * Math.cos(randomRadiusAngle));
                            if (EmitterFeature.this.doYOffset) {
                                yyy = yy;
                                oyyy = (float)((double)oyyy + (double)r * Math.sin(randomRadiusAngle));
                            } else {
                                yyy = (float)((double)yyy + (double)r * Math.sin(randomRadiusAngle));
                            }
                        }
                        Particle p = Particle.POOL.obtain(this, xxx, yyy, oyyy, EmitterFeature.this.angle == null ? (float)Math.random() * 360.0f : EmitterFeature.this.angle.getValue() + this.angle, EmitterFeature.this.velocity == null ? 0.0f : EmitterFeature.this.velocity.getValue() * this.instanceScale, EmitterFeature.this.acceleration == null ? 0.0f : EmitterFeature.this.acceleration.getValue() * this.instanceScale, (int)EmitterFeature.this.particleDuration.getValue(), (int)EmitterFeature.this.fadeDuration.getValue(), (ReadableColor)startColor, (ReadableColor)endColor);
                        p.setAx(EmitterFeature.this.gravityX == null ? 0.0f : EmitterFeature.this.gravityX.getValue() * this.instanceScale);
                        p.setAy(EmitterFeature.this.gravityY == null ? 0.0f : EmitterFeature.this.gravityY.getValue() * this.instanceScale);
                        p.setAppearance(EmitterFeature.this.appearanceResource);
                        p.setLayer(EmitterFeature.this.layer);
                        p.setSubLayer(EmitterFeature.this.subLayer);
                        p.setDoYOffset(EmitterFeature.this.doYOffset);
                        p.setStartScale(EmitterFeature.this.startScale == null ? this.instanceScale : EmitterFeature.this.startScale.getValue() * this.instanceScale);
                        p.setEndScale(EmitterFeature.this.endScale == null ? this.instanceScale : EmitterFeature.this.endScale.getValue() * this.instanceScale);
                        if (EmitterFeature.this.scale != null) {
                            p.setScale(EmitterFeature.this.scale.getValue() * this.instanceScale);
                        } else {
                            p.setScale(this.instanceScale);
                        }
                        if (this.ceilingSet) {
                            p.setCeiling(this.ceiling);
                        }
                        if (this.floorSet) {
                            p.setFloor(this.floor);
                        }
                        if (this.leftWallSet) {
                            p.setLeftWall(this.leftWall);
                        }
                        if (this.rightWallSet) {
                            p.setRightWall(this.rightWall);
                        }
                        if (EmitterFeature.this.rotate) {
                            p.setRotation(p.getAngle());
                        }
                        p.setRelativeRotation(EmitterFeature.this.relativeRotate);
                        if (EmitterFeature.this.slave != null) {
                            p.setForced(true);
                        }
                        p.spawn(this.screen);
                        if (EmitterFeature.this.slave != null && this.isVisible()) {
                            Emitter slaveEmitter = EmitterFeature.this.slave.spawn(this.screen);
                            slaveEmitter.setOffset(this.getOffset());
                            p.setEmitter(slaveEmitter);
                            slaveEmitter.update();
                        }
                        ++i;
                    }
                }
            }
            if (EmitterFeature.this.infinite) {
                if (this.actualDuration > 0 && this.tick >= this.actualDuration) {
                    this.tick = 0;
                    if (EmitterFeature.this.delayAfter != null) {
                        this.actualDelay = (int)EmitterFeature.this.delayAfter.getValue();
                        this.delayingAfter = this.delayed = this.actualDelay > 0;
                    } else {
                        this.initEmitter();
                    }
                }
            } else {
                if (this.tick >= this.actualDuration) {
                    this.finish();
                } else if (this.soundEffect != null) {
                    float ratio = (float)this.tick / (float)(this.actualDuration + 1);
                    if (EmitterFeature.this.startVolume != EmitterFeature.this.endVolume) {
                        this.soundEffect.setGain(LinearInterpolator.instance.interpolate(EmitterFeature.this.startVolume, EmitterFeature.this.endVolume, ratio), Game.class);
                    }
                    if (EmitterFeature.this.startPitch != EmitterFeature.this.endPitch) {
                        this.soundEffect.setPitch(LinearInterpolator.instance.interpolate(EmitterFeature.this.startPitch, EmitterFeature.this.endPitch, ratio), Game.class);
                    }
                }
                if (EmitterFeature.this.maxParticles > 0 && this.numParticles >= EmitterFeature.this.maxParticles) {
                    this.finish();
                }
            }
            this.oldx = xx;
            this.oldy = yy;
            this.oldYoffset = this.iyo;
        }

        protected void doRemove() {
            this.done = true;
            if (this.soundEffect != null) {
                this.soundEffect.setLooped(false, (Object)this);
            }
            this.soundEffect = null;
            if (this.chainInstance != null) {
                this.chainInstance.finish();
                this.chainInstance = null;
            }
        }

        public void finish() {
            if (this.finished) {
                return;
            }
            this.finished = true;
            if (this.soundEffect == null) {
                this.remove();
            } else {
                this.soundEffect.setLooped(false, (Object)this);
            }
        }

        public boolean isEffectActive() {
            return !this.done;
        }
    }
}

