/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.interpolators.SineInterpolator;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadablePoint;

public class BlastEffect
extends Effect {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_LAYER = 99;
    private static final int STEP = 8;
    private static final short[] STRIP_INDICES = new short[92];
    private int duration;
    private float finalRadius;
    private float width;
    private float radius;
    private int tick;
    private float x;
    private float y;
    private GLBaseTexture texture;
    private int fadeDuration;
    private boolean fading;
    private boolean fadeWhenExpanding;

    static {
        int i = 0;
        while (i < STRIP_INDICES.length) {
            BlastEffect.STRIP_INDICES[i] = (short)i;
            ++i;
        }
        BlastEffect.STRIP_INDICES[BlastEffect.STRIP_INDICES.length - 2] = 0;
        BlastEffect.STRIP_INDICES[BlastEffect.STRIP_INDICES.length - 1] = 1;
    }

    public BlastEffect(float x, float y, int duration, int fadeDuration, float radius, float width, GLBaseTexture texture) {
        this.x = x;
        this.y = y;
        this.duration = duration;
        this.fadeDuration = fadeDuration;
        this.finalRadius = radius;
        this.width = width;
        this.texture = texture;
    }

    public int getDefaultLayer() {
        return 99;
    }

    protected void doTick() {
        ++this.tick;
        if (!this.fading) {
            this.radius = SineInterpolator.instance.interpolate(0.0f, this.finalRadius, (float)this.tick / (float)this.duration);
            if (this.tick >= this.duration && !this.fadeWhenExpanding) {
                this.tick = 0;
                this.fading = true;
            }
        }
    }

    protected void render() {
        float innerRadius;
        float alpha;
        this.glRender(new GLRenderable(){

            public void render() {
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3042);
                GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
                GL11.glBlendFunc((int)770, (int)1);
                BlastEffect.this.texture.render();
            }
        });
        float xx = this.x;
        float yy = this.y;
        ReadablePoint offset = this.getOffset();
        if (offset != null) {
            xx += (float)offset.getX();
            yy += (float)offset.getY();
        }
        if (this.fading) {
            alpha = LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)this.tick / (float)this.fadeDuration);
            innerRadius = SineInterpolator.instance.interpolate(Math.max(0.0f, this.finalRadius - this.width), this.finalRadius, (float)this.tick / (float)this.fadeDuration);
        } else {
            alpha = this.fadeWhenExpanding ? LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)this.tick / (float)this.fadeDuration) : 1.0f;
            innerRadius = SineInterpolator.instance.interpolate(0.0f, Math.max(0.0f, this.finalRadius - this.width), (float)this.tick / (float)this.duration);
        }
        int i = 0;
        while (i <= 360) {
            this.glColor4f(1.0f, 1.0f, 1.0f, 0.0f);
            this.glTexCoord2f(i, 1.0f);
            this.glVertex2f(xx + (float)Math.cos(Math.toRadians(i)) * innerRadius, yy + (float)Math.sin(Math.toRadians(i)) * innerRadius);
            this.glColor4f(1.0f, 1.0f, 1.0f, alpha);
            this.glTexCoord2f(i, 0.0f);
            this.glVertex2f(xx + (float)Math.cos(Math.toRadians(i)) * this.radius, yy + (float)Math.sin(Math.toRadians(i)) * this.radius);
            i += 8;
        }
        this.glRender(5, STRIP_INDICES);
    }

    public boolean isEffectActive() {
        return this.fadeWhenExpanding ? this.tick < this.duration : !this.fading || this.tick < this.fadeDuration;
    }

    public float getRadius() {
        return this.radius;
    }

    public boolean isFading() {
        return this.fading;
    }

    public void setFadeWhenExpanding(boolean fadeWhenExpanding) {
        this.fadeWhenExpanding = fadeWhenExpanding;
    }
}

