/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import net.puppygames.applet.effects.Effect;

public abstract class AdjusterEffect
extends Effect {
    private final int rate;
    private int current;
    private int target;
    private boolean finished;

    public AdjusterEffect(int rate, int initial, int target) {
        this.rate = rate;
        this.current = initial;
        this.target = target;
    }

    public void setTarget(int target) {
        this.target = target;
    }

    public int getTarget() {
        return this.target;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getCurrent() {
        return this.current;
    }

    protected void render() {
    }

    protected final void doTick() {
        if (this.current < this.target) {
            this.current = Math.min(this.current + this.rate, this.target);
        } else if (this.current > this.target) {
            this.current = Math.max(this.current - this.rate, this.target);
        }
        this.onTicked();
    }

    protected abstract void onTicked();

    public void finish() {
        this.current = this.target;
        this.remove();
    }

    protected void doRemove() {
        this.finished = true;
    }

    public boolean isEffectActive() {
        return !this.finished;
    }
}

