/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import java.io.File;
import net.puppygames.applet.Game;
import net.puppygames.steam.Steam;

public class RoamingFile {
    private final String path;

    public RoamingFile(String path) {
        this.path = path;
    }

    public boolean exists() {
        if (Game.isUsingSteamCloud()) {
            return Steam.getRemoteStorage().fileExists(this.path);
        }
        return new File(this.path).exists();
    }

    public boolean delete() {
        if (Game.isUsingSteamCloud()) {
            return Steam.getRemoteStorage().fileDelete(this.path);
        }
        return new File(this.path).delete();
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoamingFile other = (RoamingFile)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RoamingFile [");
        if (this.path != null) {
            builder.append("path=");
            builder.append(this.path);
        }
        builder.append("]");
        return builder.toString();
    }
}

