/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.resources.TextResource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.puppygames.applet.Game;
import net.puppygames.applet.GameInputStream;
import net.puppygames.applet.GameOutputStream;
import net.puppygames.applet.GameState;
import net.puppygames.applet.NagState;
import net.puppygames.applet.PrizeFeature;
import net.puppygames.applet.RoamingFile;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.EffectFeature;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.CreditsScreen;
import net.puppygames.applet.screens.DialogScreen;
import net.puppygames.applet.screens.HiscoresScreen;
import net.puppygames.applet.screens.InstructionsScreen;
import net.puppygames.applet.screens.NagScreen;
import net.puppygames.applet.screens.RegisterScreen;
import net.puppygames.applet.screens.SignUpScreen;
import net.puppygames.applet.screens.TitleScreen;
import net.puppygames.applet.screens.UnlockBonusScreen;
import net.puppygames.gamecommerce.shared.NewsletterIncentive;
import org.lwjgl.Sys;

public abstract class MiniGame
extends Game {
    private static final boolean TESTSIGNUP = true;
    private static final boolean IGNORESIGNUP = false;
    private static final String RESTORE_GAME_DIALOG_FEATURE = "restore_game.dialog";
    private static final String SAVE_GAME_EFFECT_FEATURE = "save_game.effect";
    private static int playedThisSession;
    private static boolean shownInstructions;
    private static int playedTicks;
    private static boolean preventBuy;
    private static boolean doBuy;
    private static GameState gameState;
    private static boolean allowSave;
    private static DialogScreen restoreGameDialog;
    private static Screen topScreen;
    private static String scoreGroup;
    private static PrizeFeature prize;
    private boolean dontUseRemoteHiscores;
    private transient boolean submitRemoteHiscores;

    static {
        allowSave = true;
    }

    public static void beginNewGame() {
        System.out.println("Begin new game");
        if (!Game.isRegistered()) {
            if (!shownInstructions && MiniGame.maybeShowHelp()) {
                return;
            }
            int played = MiniGame.getLocalPreferences().getInt("played" + Game.getVersion(), 0);
            played ^= 0xAF6AD755;
            played = played >> 16 & 0xFFFF | played << 16;
            if ((played ^= 0xCCCCCABE) == 463037908) {
                played = 0;
            }
            int tix = MiniGame.getLocalPreferences().getInt("tix", 0);
            System.out.println("You have played " + Game.getTitle() + " " + played + " times for " + tix / 60 + " minutes");
            System.out.println("Max games " + Game.getConfiguration().getMaxGames() + " / max time " + Game.getConfiguration().getMaxTime() / 60 + " / max level " + Game.getConfiguration().getMaxLevel());
            if (MiniGame.isDemoExpired() && (Game.getConfiguration().isCrippled() || playedThisSession > 0)) {
                NagScreen.show("Your demo has expired!", true);
                return;
            }
            ++played;
            played ^= 0xCCCCCABE;
            played = played >> 16 & 0xFFFF | played << 16;
            MiniGame.getLocalPreferences().putInt("played" + Game.getVersion(), played ^= 0xAF6AD755);
            MiniGame.flushPrefs();
            Game.getGameInfo().onNewGame();
            ++playedThisSession;
        }
        SFX.newGame();
        MiniGame.getGame().onBeginNewGame();
    }

    public static MiniGame getGame() {
        return (MiniGame)Game.getGame();
    }

    public static void buy(boolean doExit) {
        if (!doBuy) {
            doBuy = true;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (Game.isRegistered() || preventBuy) {
                        return;
                    }
                    Game.getLocalPreferences().putBoolean("showregister", true);
                    try {
                        String page;
                        if (Resources.exists((String)"buy_url")) {
                            TextResource tr = (TextResource)Resources.get((String)"buy_url");
                            page = tr.getText();
                        } else {
                            page = Game.getBuyURL() != null && !"".equals(Game.getBuyURL()) ? Game.getBuyURL() : (!System.getProperty("buy_url", "!").equals("!") ? System.getProperty("buy_url") : "http://" + Game.getWebsite() + "/purchase/buy.php?game=" + URLEncoder.encode(Game.getTitle(), "utf-8") + "&configuration=" + URLEncoder.encode(Game.configuration.encode(), "utf-8") + "@installation@");
                        }
                        String replacement = "&installation=" + URLEncoder.encode(String.valueOf(Game.installation), "utf-8");
                        int idx = page.indexOf("@installation@");
                        if (idx != -1) {
                            StringBuilder sb = new StringBuilder(page);
                            sb.replace(idx, idx + 14, replacement);
                            page = sb.toString();
                        }
                        if (!Sys.openURL((String)page)) {
                            throw new Exception("Failed to open URL " + page);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        Game.alert("Please open your web browser on the page http://" + Game.getWebsite());
                    }
                }
            });
        }
        if (doExit) {
            Game.exit();
        }
    }

    public static void clearBuy() {
        preventBuy = true;
    }

    public static void endGame() {
        MiniGame.getGame().updateLog();
        MiniGame.getGame().doEndGame();
    }

    public static void gameOver() {
        SFX.gameOver();
        MiniGame.getGame().doGameOver();
    }

    public static boolean isDemoExpired() {
        return MiniGame.getGame().doIsDemoExpired();
    }

    public static boolean isRestoreAvailable() {
        return new RoamingFile(MiniGame.getGame().getRestoreFile()).exists();
    }

    public static boolean maybeShowHelp() {
        return MiniGame.getGame().doMaybeShowHelp();
    }

    public static void onTicked() {
        ++playedTicks;
    }

    public static void restoreGame() {
        MiniGame.getGame().onRestoreGame();
    }

    public static void saveGame() {
        MiniGame.getGame().doSaveGame();
    }

    public static void showCredits() {
        MiniGame.getGame().doShowCredits();
    }

    public static void showHelp() {
        shownInstructions = true;
        MiniGame.getGame().doShowHelp();
    }

    public static void showHiscores() {
        MiniGame.getGame().doShowHiscores();
    }

    public static void showMoreGames() {
        new Thread(){

            public void run() {
                try {
                    String page;
                    MiniGame.getLocalPreferences().putBoolean("showregister", true);
                    if (Resources.exists((String)"moregames_url")) {
                        TextResource tr = (TextResource)Resources.get((String)"moregames_url");
                        page = tr.getText();
                    } else {
                        page = MiniGame.getMoreGamesURL() != null && !"".equals(MiniGame.getMoreGamesURL()) ? MiniGame.getMoreGamesURL() : (!System.getProperty("moregames_url", "!").equals("!") ? System.getProperty("moregames_url") : "http://" + Game.getWebsite());
                    }
                    if (!Sys.openURL((String)page)) {
                        throw new Exception("Failed to open URL " + page);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    Game.alert("Please open your web browser on the page http://" + Game.getWebsite());
                }
            }
        }.start();
    }

    public static void showOptions() {
        MiniGame.getGame().doShowOptions();
    }

    public static void showRegisterScreen() {
        MiniGame.getGame().doShowRegisterScreen();
    }

    public static void showTitleScreen() {
        MiniGame.getGame().doShowTitleScreen();
    }

    protected void updateLog() {
        int tix = MiniGame.getLocalPreferences().getInt("tix", 0);
        int newTix = playedTicks / MiniGame.getFrameRate();
        playedTicks = 0;
        MiniGame.getGameInfo().addTime(newTix);
        MiniGame.getLocalPreferences().putInt("tix", tix += newTix);
        MiniGame.flushPrefs();
    }

    public MiniGame(String name) {
        super(name);
    }

    protected void doEndGame() {
        MiniGame.showTitleScreen();
    }

    protected abstract void doGameOver();

    protected boolean doIsDemoExpired() {
        if (MiniGame.isRegistered()) {
            return false;
        }
        int played = MiniGame.getLocalPreferences().getInt("played" + MiniGame.getVersion(), 0);
        played ^= 0xAF6AD755;
        played = played >> 16 & 0xFFFF | played << 16;
        if ((played ^= 0xCCCCCABE) == 463037908) {
            played = 0;
        }
        int tix = MiniGame.getLocalPreferences().getInt("tix", 0);
        return played < 0 || (played > configuration.getMaxGames() && configuration.getMaxGames() > 0 || configuration.getMaxGames() == 0) && (tix > configuration.getMaxTime() && configuration.getMaxTime() > 0 || configuration.getMaxTime() == 0);
    }

    protected boolean doMaybeShowHelp() {
        MiniGame.showHelp();
        return true;
    }

    protected void doShowCredits() {
        CreditsScreen.show();
    }

    protected void doShowHelp() {
        InstructionsScreen.show();
    }

    protected void doShowHiscores() {
        HiscoresScreen.show(null);
    }

    protected void doShowOptions() {
    }

    protected void doShowRegisterScreen() {
        RegisterScreen.show();
    }

    protected void doShowTitleScreen() {
        TitleScreen.show();
    }

    protected void onBeginNewGame() {
        if (MiniGame.isRestoreAvailable()) {
            MiniGame.restoreGame();
        } else {
            MiniGame.cleanGame();
        }
    }

    protected void onExit() {
        if (MiniGame.getGame() != null && !preventBuy) {
            MiniGame.buy(false);
        }
    }

    protected void doRestoreGame() {
        allowSave = true;
        String file = this.getRestoreFile();
        GameInputStream gis = null;
        ObjectInputStream ois = null;
        boolean exceptionOccurred = false;
        try {
            try {
                gis = new GameInputStream(file);
                ois = new ObjectInputStream(gis);
                this.setGameState((GameState)ois.readObject());
                long tox = MiniGame.getPlayerSlot() != null ? MiniGame.getPlayerSlot().getPreferences().getLong(this.getSaveGameRegistryMagicLocation(), 0L) : MiniGame.getRoamingPreferences().getLong(this.getSaveGameRegistryMagicLocation(), 0L);
                if (tox != gameState.getMagic()) {
                    throw new Exception("Invalid game state");
                }
                Resources.dequeue();
                gameState.reinit();
            }
            catch (Exception e) {
                exceptionOccurred = true;
                e.printStackTrace(System.err);
                this.onRestoreGameFailed(e);
                if (gis != null) {
                    try {
                        gis.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (MiniGame.getPlayerSlot() != null) {
                    MiniGame.getPlayerSlot().getPreferences().putLong("tox", new Random().nextLong());
                } else {
                    MiniGame.getRoamingPreferences().putLong("tox", new Random().nextLong());
                }
                MiniGame.flushPrefs();
                if (exceptionOccurred) {
                    if (MiniGame.isUsingSteamCloud()) {
                        if (!new RoamingFile(file).delete()) {
                            System.err.println("Failed to delete save file");
                        }
                    } else {
                        File newFile = new File(String.valueOf(file) + ".broken");
                        if (!new File(file).renameTo(newFile)) {
                            System.err.println("Failed to rename " + file + " to " + newFile);
                            if (!new RoamingFile(file).delete()) {
                                System.err.println("Failed to delete save file");
                            }
                        }
                    }
                } else if (!new RoamingFile(file).delete()) {
                    System.err.println("Failed to delete save file");
                }
            }
        }
        finally {
            if (gis != null) {
                try {
                    gis.close();
                }
                catch (Exception newFile) {}
            }
            if (MiniGame.getPlayerSlot() != null) {
                MiniGame.getPlayerSlot().getPreferences().putLong("tox", new Random().nextLong());
            } else {
                MiniGame.getRoamingPreferences().putLong("tox", new Random().nextLong());
            }
            MiniGame.flushPrefs();
            if (exceptionOccurred) {
                if (MiniGame.isUsingSteamCloud()) {
                    if (!new RoamingFile(file).delete()) {
                        System.err.println("Failed to delete save file");
                    }
                } else {
                    File newFile = new File(String.valueOf(file) + ".broken");
                    if (!new File(file).renameTo(newFile)) {
                        System.err.println("Failed to rename " + file + " to " + newFile);
                        if (!new RoamingFile(file).delete()) {
                            System.err.println("Failed to delete save file");
                        }
                    }
                }
            } else if (!new RoamingFile(file).delete()) {
                System.err.println("Failed to delete save file");
            }
        }
    }

    protected void setGameState(GameState newGameState) {
        gameState = newGameState;
    }

    protected abstract GameState createGameState();

    private static PrizeFeature choosePrize() {
        ArrayList<PrizeFeature> prizes = new ArrayList<PrizeFeature>(PrizeFeature.getPrizes());
        Collections.shuffle(prizes);
        for (PrizeFeature pf : prizes) {
            if (!pf.isValid()) continue;
            return pf;
        }
        return null;
    }

    public static NagState getNagState() {
        return NagState.valueOf(MiniGame.getRoamingPreferences().get("nagstate", NagState.NOT_YET_SHOWN.name()));
    }

    public static void setNagState(NagState newNagState) {
        MiniGame.getRoamingPreferences().put("nagstate", newNagState.name());
        MiniGame.flushPrefs();
    }

    protected void onPreRegisteredStartup() {
        NagState nagState = MiniGame.getNagState();
        switch (nagState) {
            case NOT_YET_SHOWN: {
                PrizeFeature prize = MiniGame.choosePrize();
                if (prize != null) {
                    SignUpScreen.show(prize);
                    break;
                }
                MiniGame.showTitleScreen();
                break;
            }
            case PRIZE_AWAITS: {
                FileInputStream fis = null;
                BufferedInputStream bis = null;
                ObjectInputStream ois = null;
                try {
                    try {
                        fis = new FileInputStream(MiniGame.getIncentiveFile());
                        bis = new BufferedInputStream(fis);
                        ois = new ObjectInputStream(bis);
                        NewsletterIncentive ni = (NewsletterIncentive)ois.readObject();
                        if (!ni.validate()) {
                            throw new Exception("Existing incentive file is invalid.");
                        }
                        UnlockBonusScreen.show(ni);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        MiniGame.showTitleScreen();
                        if (fis == null) break;
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (fis == null) break;
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
                break;
            }
            case DONT_NAG: 
            case REDEEMED: {
                MiniGame.showTitleScreen();
                break;
            }
            default: {
                assert (false) : "Unknown nag state " + (Object)((Object)nagState);
                break;
            }
        }
    }

    public static File getIncentiveFile() {
        return new File(String.valueOf(MiniGame.getRoamingDirectoryPrefix()) + "incentive.dat");
    }

    public static void setPrize(PrizeFeature prize) {
        MiniGame.prize = prize;
    }

    public static PrizeFeature getPrize() {
        return prize;
    }

    protected void onRestoreGame() {
        if (!MiniGame.isRestoreAvailable()) {
            return;
        }
        topScreen = Screen.getTopScreen();
        if (topScreen == null) {
            return;
        }
        try {
            restoreGameDialog = (DialogScreen)Resources.get((String)RESTORE_GAME_DIALOG_FEATURE);
            restoreGameDialog.doModal(MiniGame.getMessage("lwjglapplets.minigame.restoregame.title"), MiniGame.getMessage("lwjglapplets.minigame.restoregame.message"), new Runnable(){

                public void run() {
                    topScreen.setEnabled(true);
                    switch (restoreGameDialog.getOption()) {
                        case 2: {
                            MiniGame.this.doRestoreGame();
                            break;
                        }
                        case 3: {
                            MiniGame.cleanGame();
                            break;
                        }
                    }
                    restoreGameDialog = null;
                }
            });
            topScreen.setEnabled(false);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.onRestoreGameFailed(e);
        }
    }

    protected void onRestoreGameFailed(Exception e) {
    }

    protected String getSaveGameRegistryMagicLocation() {
        return "tox";
    }

    protected void doSaveGame() {
        if (!allowSave) {
            return;
        }
        String file = this.getRestoreFile();
        try {
            GameOutputStream gos = new GameOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(gos);
            gameState.setMagic(new Random().nextLong());
            if (MiniGame.getPlayerSlot() != null) {
                MiniGame.getPlayerSlot().getPreferences().putLong(this.getSaveGameRegistryMagicLocation(), gameState.getMagic());
            } else {
                MiniGame.getRoamingPreferences().putLong(this.getSaveGameRegistryMagicLocation(), gameState.getMagic());
            }
            oos.writeObject(gameState);
            oos.flush();
            gos.close();
            allowSave = false;
            this.onGameSaved();
            MiniGame.flushPrefs();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        TitleScreen.show();
    }

    protected void onGameSaved() {
        ((EffectFeature)Resources.get((String)SAVE_GAME_EFFECT_FEATURE)).spawn(TitleScreen.getInstance());
    }

    public static void cleanGame() {
        RoamingFile file = new RoamingFile(MiniGame.getGame().getRestoreFile());
        if (file.exists() && !file.delete()) {
            System.err.println("Failed to delete save file " + file);
        }
        allowSave = true;
        MiniGame.getGame().onCleanGame();
    }

    protected void onCleanGame() {
        this.setGameState(this.createGameState());
        gameState.init();
    }

    protected String getRestoreFile() {
        if (MiniGame.getPlayerSlot() != null) {
            return String.valueOf(MiniGame.getPlayerDirectoryPrefix()) + "restore.dat";
        }
        return String.valueOf(MiniGame.getRoamingDirectoryPrefix()) + "restore.dat";
    }

    public static String getScoreGroup() {
        return scoreGroup;
    }

    public static void setScoreGroup(String scoreGroup) {
        MiniGame.scoreGroup = scoreGroup;
    }

    protected void onInit() {
        MiniGame.getGame().submitRemoteHiscores = MiniGame.getRoamingPreferences().getBoolean("submitremotehiscores", !MiniGame.getGame().dontUseRemoteHiscores);
    }

    protected void onRegisteredStartup() {
        MiniGame.showTitleScreen();
    }

    protected void onUnregisteredStartup() {
        MiniGame.showRegisterScreen();
    }

    public static boolean getDontUseRemoteHiscores() {
        return MiniGame.getGame().dontUseRemoteHiscores;
    }

    public static boolean getSubmitRemoteHiscores() {
        return !MiniGame.getGame().dontUseRemoteHiscores && MiniGame.getGame().submitRemoteHiscores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSubmitRemoteHiscores(boolean set) {
        MiniGame.getGame().submitRemoteHiscores = set;
        Preferences preferences = MiniGame.getRoamingPreferences();
        synchronized (preferences) {
            MiniGame.getRoamingPreferences().putBoolean("submitremotehiscores", !MiniGame.getGame().dontUseRemoteHiscores && MiniGame.getGame().submitRemoteHiscores);
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Preferences preferences = MiniGame.getRoamingPreferences();
                    synchronized (preferences) {
                        MiniGame.getRoamingPreferences().flush();
                    }
                }
                catch (BackingStoreException e) {
                    e.printStackTrace(System.err);
                }
            }
        }.start();
    }

    public static /* bridge */ /* synthetic */ Game getGame() {
        return MiniGame.getGame();
    }
}

