/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.puppygames.applet.Game;
import net.puppygames.applet.GameInputStream;
import net.puppygames.steam.Steam;
import net.puppygames.steam.SteamException;
import org.lwjgl.BufferUtils;

public class GameOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 262144;
    private final String file;
    private final boolean append;
    private final boolean usingSteam;
    private final ByteArrayOutputStream baos;
    private final OutputStream fos;
    private final OutputStream os;
    private boolean flushed;
    private boolean closed;

    public GameOutputStream(String file) throws IOException {
        this(file, false);
    }

    public GameOutputStream(String file, boolean append) throws IOException {
        this.file = file;
        this.append = append;
        this.usingSteam = Game.isUsingSteamCloud();
        if (this.usingSteam) {
            this.baos = new ByteArrayOutputStream(262144);
            this.fos = null;
            this.os = this.baos;
            if (append) {
                this.readExisting();
            }
        } else {
            this.baos = null;
            this.os = this.fos = new BufferedOutputStream(new FileOutputStream(file));
        }
    }

    private void readExisting() throws IOException {
        int ret;
        if (!Steam.getRemoteStorage().fileExists(this.file)) {
            return;
        }
        GameInputStream gis = new GameInputStream(this.file);
        byte[] buf = new byte[262144];
        do {
            if ((ret = gis.read(buf, 0, 262144)) == -1) continue;
            this.baos.write(buf, 0, ret);
        } while (ret != -1);
        gis.close();
    }

    public void write(int b) throws IOException {
        this.os.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.os.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    public void flush() throws IOException {
        if (!this.usingSteam) {
            this.os.flush();
        }
        this.flushed = true;
    }

    private void doSteamFlush() throws IOException {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)this.baos.size());
        byteBuffer.put(this.baos.toByteArray());
        byteBuffer.flip();
        try {
            Steam.getRemoteStorage().fileWrite(this.file, byteBuffer);
            System.out.println("Wrote " + this.file + " to Steam cloud");
        }
        catch (SteamException e) {
            throw new IOException(e);
        }
        this.baos.reset();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (!this.flushed) {
                this.flush();
            }
            if (this.usingSteam) {
                this.doSteamFlush();
            }
        }
        finally {
            this.os.close();
        }
    }
}

