/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.puppygames.applet.Game;
import net.puppygames.steam.Steam;
import org.lwjgl.BufferUtils;

public class GameInputStream
extends InputStream {
    private final String file;
    private final boolean usingSteam;
    private final InputStream fis;
    private final ByteArrayInputStream bais;
    private final InputStream is;

    public GameInputStream(String file) throws IOException {
        this.file = file;
        this.usingSteam = Game.isUsingSteamCloud();
        if (!this.usingSteam) {
            this.fis = new BufferedInputStream(new FileInputStream(file));
            this.bais = null;
            this.is = this.fis;
        } else {
            this.fis = null;
            this.bais = new ByteArrayInputStream(this.readSteamFile());
            this.is = this.bais;
        }
    }

    private byte[] readSteamFile() throws IOException {
        if (!Steam.getRemoteStorage().fileExists(this.file)) {
            throw new FileNotFoundException("Can't file Steam file " + this.file);
        }
        int size = Steam.getRemoteStorage().getFileSize(this.file);
        System.out.println("Steam says file " + this.file + " is " + size + " bytes");
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)size);
        Steam.getRemoteStorage().fileRead(this.file, byteBuffer);
        byte[] ret = new byte[byteBuffer.limit()];
        byteBuffer.get(ret);
        System.out.println("Successfully read Steam cloud file " + this.file);
        return ret;
    }

    public int read() throws IOException {
        return this.is.read();
    }

    public int read(byte[] b) throws IOException {
        return this.is.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.is.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public void close() throws IOException {
        this.is.close();
    }
}

