/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.util.Util;
import net.puppygames.gamecommerce.shared.ConfigurationDetails;

public class Configuration
implements ConfigurationDetails {
    private static final long serialVersionUID = 2L;
    private static final int[] MAX_GAMES;
    private static final int[] MAX_TIME;
    private static final int[] MAX_LEVEL;
    private int maxGames = -1;
    private int maxTime = -1;
    private int maxLevel = -1;
    private int crippled = -1;
    private int fullscreen = -1;

    static {
        int[] nArray = new int[5];
        nArray[1] = 10;
        nArray[2] = 15;
        nArray[3] = 20;
        nArray[4] = 25;
        MAX_GAMES = nArray;
        int[] nArray2 = new int[5];
        nArray2[1] = 800;
        nArray2[2] = 1600;
        nArray2[3] = 2400;
        nArray2[4] = 3000;
        MAX_TIME = nArray2;
        int[] nArray3 = new int[5];
        nArray3[1] = 10;
        nArray3[2] = 15;
        nArray3[3] = 20;
        nArray3[4] = 25;
        MAX_LEVEL = nArray3;
    }

    public String encode() {
        StringBuilder sb = new StringBuilder(5);
        if (this.maxGames == -1) {
            throw new IllegalStateException("maxGames not set");
        }
        if (this.maxTime == -1) {
            throw new IllegalStateException("maxTime not set");
        }
        if (this.maxGames < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(this.maxGames));
        if (this.maxTime < 1600) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(this.maxTime / 100));
        sb.append(Integer.toHexString(this.crippled));
        if (this.maxLevel < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(this.maxLevel));
        sb.append(Integer.toHexString(this.fullscreen));
        return sb.toString();
    }

    public ConfigurationDetails decode(String encoded) throws Exception {
        this.maxGames = Integer.parseInt(encoded.substring(0, 2), 16);
        this.maxTime = Integer.parseInt(encoded.substring(2, 4), 16) * 100;
        if (encoded.length() > 4) {
            this.crippled = Integer.parseInt(encoded.substring(4, 5), 16);
            if (encoded.length() > 5) {
                this.maxLevel = Integer.parseInt(encoded.substring(5, 7), 16);
                this.fullscreen = encoded.length() > 7 ? Integer.parseInt(encoded.substring(7, 8), 16) : Util.random((int)0, (int)1);
            } else {
                this.maxLevel = MAX_LEVEL[1];
            }
        } else {
            this.crippled = 1;
        }
        if (this.maxGames == 0 && this.maxTime == 0) {
            if (Util.random((int)0, (int)1) == 0) {
                this.maxGames = MAX_GAMES[1];
            } else {
                this.maxTime = MAX_TIME[1];
            }
        }
        return this;
    }

    public void init() {
        Util.setSeed((long)System.currentTimeMillis());
        if (this.maxGames == -1) {
            this.maxGames = MAX_GAMES[Util.random((int)0, (int)(MAX_GAMES.length - 1))];
        }
        if (this.maxTime == -1) {
            this.maxTime = MAX_TIME[Util.random((int)0, (int)(MAX_TIME.length - 1))];
        }
        if (this.maxGames == 0 && this.maxTime == 0) {
            if (Util.random((int)0, (int)1) == 0) {
                this.maxGames = MAX_GAMES[1];
            } else {
                this.maxTime = MAX_TIME[1];
            }
        }
        if (this.crippled == -1) {
            this.crippled = Util.random((int)0, (int)1);
        }
        if (this.fullscreen == -1) {
            this.fullscreen = Util.random((int)0, (int)1);
        }
        if (this.maxLevel == -1) {
            this.maxLevel = MAX_LEVEL[Util.random((int)0, (int)(MAX_LEVEL.length - 1))];
        }
    }

    public int getMaxGames() {
        return this.maxGames;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public boolean isCrippled() {
        return this.crippled == 1;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public boolean isFullscreen() {
        return this.fullscreen == 1;
    }
}

