/*
 * Decompiled with CFR 0.152.
 */
package puppytron.powerups;

import puppytron.GameScreen;
import puppytron.Res;
import puppytron.entities.Bullet;
import puppytron.powerups.ExoticPowerup;

public class ThreeWayPowerup
extends ExoticPowerup {
    private static final long serialVersionUID = 1L;

    public ThreeWayPowerup() {
        super("3-WAY");
    }

    protected void doSpawn() {
        this.sprite.setAppearance(Res.getThreeWayPowerupAppearance());
    }

    protected void collect() {
        super.collect();
        GameScreen.getPlayer().setThreeWay();
    }

    public void onCollisionWithBullet(Bullet bullet) {
        bullet.ignore(this);
        double originalAngle = Math.atan2(bullet.getVY(), bullet.getVX());
        Bullet left = bullet.getFeature().spawn(GameScreen.getInstance());
        double fortyFiveDegrees = 0.39269908169872414;
        left.init(this.getX(), this.getY(), this.getX() + (float)(Math.cos(originalAngle - fortyFiveDegrees) * 128.0), this.getY() + (float)(Math.sin(originalAngle - fortyFiveDegrees) * 128.0));
        Bullet right = bullet.getFeature().spawn(GameScreen.getInstance());
        right.init(this.getX(), this.getY(), this.getX() + (float)(Math.cos(originalAngle + fortyFiveDegrees) * 128.0), this.getY() + (float)(Math.sin(originalAngle + fortyFiveDegrees) * 128.0));
    }
}

