/*
 * Decompiled with CFR 0.152.
 */
package puppytron.movements;

import com.shavenpuppy.jglib.util.Util;
import net.puppygames.applet.Game;
import puppytron.Moveable;
import puppytron.Movement;
import puppytron.features.MovementFeature;

public class PerimeterMovementFeature
extends MovementFeature {
    private static final long serialVersionUID = 1L;
    private static final int INSET = 8;
    private int turn;
    private boolean diagonal;

    public Movement spawn(Moveable gidrah) {
        return new PerimeterMovementInstance(gidrah);
    }

    public int getArmour() {
        return 0;
    }

    public int getHitPoints() {
        return 2;
    }

    public int getScore() {
        return 15;
    }

    public String getSpawnType() {
        return "random";
    }

    public int getDifficulty() {
        return 0;
    }

    protected class PerimeterMovementInstance
    extends MovementFeature.MovementInstance {
        private int direction;

        protected PerimeterMovementInstance(Moveable gidrah) {
            super(gidrah);
            this.direction = Util.random((int)0, (int)3);
        }

        private void setDirection() {
            if (PerimeterMovementFeature.this.diagonal) {
                switch (this.direction) {
                    case 0: {
                        this.gidrah.setVelocity(PerimeterMovementFeature.this.getSpeed(), PerimeterMovementFeature.this.getSpeed());
                        this.gidrah.setFacing(1);
                        break;
                    }
                    case 1: {
                        this.gidrah.setVelocity(-PerimeterMovementFeature.this.getSpeed(), PerimeterMovementFeature.this.getSpeed());
                        this.gidrah.setFacing(-1);
                        break;
                    }
                    case 2: {
                        this.gidrah.setVelocity(-PerimeterMovementFeature.this.getSpeed(), -PerimeterMovementFeature.this.getSpeed());
                        this.gidrah.setFacing(-1);
                        break;
                    }
                    case 3: {
                        this.gidrah.setVelocity(PerimeterMovementFeature.this.getSpeed(), -PerimeterMovementFeature.this.getSpeed());
                        this.gidrah.setFacing(1);
                    }
                }
            } else {
                switch (this.direction) {
                    case 0: {
                        this.gidrah.setVelocity(PerimeterMovementFeature.this.getSpeed(), 0.0f);
                        this.gidrah.setFacing(1);
                        break;
                    }
                    case 1: {
                        this.gidrah.setVelocity(0.0f, -PerimeterMovementFeature.this.getSpeed());
                        break;
                    }
                    case 2: {
                        this.gidrah.setVelocity(-PerimeterMovementFeature.this.getSpeed(), 0.0f);
                        this.gidrah.setFacing(-1);
                        break;
                    }
                    case 3: {
                        this.gidrah.setVelocity(0.0f, PerimeterMovementFeature.this.getSpeed());
                    }
                }
            }
        }

        public void tick(Moveable moveableGidrah) {
            if (moveableGidrah.getX() + moveableGidrah.getVX() < moveableGidrah.getRadius() + 8.0f || moveableGidrah.getY() + moveableGidrah.getVY() < moveableGidrah.getRadius() + 8.0f || moveableGidrah.getX() + moveableGidrah.getVX() > (float)Game.getScale() - moveableGidrah.getRadius() - 8.0f || moveableGidrah.getY() + moveableGidrah.getVY() > (float)Game.getScale() - moveableGidrah.getRadius() - 8.0f || moveableGidrah.getVX() == 0.0f && moveableGidrah.getVY() == 0.0f) {
                this.direction = (this.direction + PerimeterMovementFeature.this.turn) % 4;
                this.setDirection();
            }
        }
    }
}

