/*
 * Decompiled with CFR 0.152.
 */
package puppytron.features;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sprites.Appearance;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.Util;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Effect;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.EmitterFeature;
import net.puppygames.applet.effects.LabelEffect;
import net.puppygames.applet.widgets.PowerDisplay;
import net.puppygames.applet.widgets.PowerDisplayFeature;
import org.lwjgl.util.Color;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadablePoint;
import org.w3c.dom.Element;
import puppytron.Brain;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Gidrah;
import puppytron.Movement;
import puppytron.Puppytron;
import puppytron.Res;
import puppytron.brains.MinelayerBrainFeature;
import puppytron.brains.ShooterBrainFeature;
import puppytron.brains.SpawnerBrainFeature;
import puppytron.effects.SpawnEffect;
import puppytron.entities.AttackDrone;
import puppytron.entities.Bomb;
import puppytron.entities.Bullet;
import puppytron.entities.DefenceDrone;
import puppytron.entities.DroneBullet;
import puppytron.entities.EnemyBullet;
import puppytron.entities.Mine;
import puppytron.entities.Player;
import puppytron.entities.Powerup;
import puppytron.entities.SmartBombShock;
import puppytron.features.BrainFeature;
import puppytron.features.MovementFeature;
import puppytron.movements.PerimeterMovementFeature;
import puppytron.movements.ScuttleMovementFeature;
import puppytron.movements.XYMovementFeature;

public class GidrahFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final List<GidrahFeature> TYPES = new ArrayList<GidrahFeature>(64);
    private static final List<GidrahFeature> EXOTIC = new ArrayList<GidrahFeature>(64);
    private static final List<GidrahFeature> BOSS = new ArrayList<GidrahFeature>(4);
    private static final List<GidrahFeature> ASSAULT = new ArrayList<GidrahFeature>(64);
    private static final float SAFE_DISTANCE = 80.0f;
    private static final int INSET = 10;
    private static final int BOSS_INSET = 60;
    private static final int MIN_FREEZE_TIME = 1800;
    private static final int MAX_FREEZE_TIME = 6400;
    private static final int SHORT_FREEZE_DURATION = 20;
    private static final ReadableColor[] SPAWN_COLOR = new ReadableColor[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.CYAN, Color.BLUE, Color.PURPLE};
    private static final int PHASE_SPAWN = 0;
    private static final int PHASE_WAIT = 1;
    private static final int PHASE_ALIVE = 2;
    private static final int SPAWNWAIT_DURATION = 30;
    private static final int BOSS_SPAWN_DURATION = 300;
    private static int numGidrahs = 0;
    private static int difficultyAdjustment = 0;
    private static int exoticCount;
    private float radius;
    private int level;
    private int armour;
    private int hitPoints;
    private String animation;
    private int score;
    private EmitterFeature spawnEmitter;
    private EmitterFeature deathEmitter;
    private String spawnType;
    private int difficulty;
    private BrainFeature brain;
    private MovementFeature movement;
    private boolean boss;
    private boolean bomber;
    private String spawnSound;
    private String soundEffect;
    private String powerDisplay;
    private Point powerOffset;
    private String deathSound;
    private transient Appearance animationAppearance;
    private transient ALBuffer soundEffectResource;
    private transient ALBuffer spawnSoundResource;
    private transient ALBuffer deathSoundResource;
    private transient PowerDisplayFeature powerDisplayFeature;

    public GidrahFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    public final Gidrah spawn(Screen screen) {
        GidrahInstance ret = new GidrahInstance(this);
        ret.spawn(screen);
        return ret;
    }

    protected void doRegister() {
        if (this.boss) {
            BOSS.add(this);
        } else if (this.brain instanceof SpawnerBrainFeature || this.brain instanceof MinelayerBrainFeature || this.movement instanceof ScuttleMovementFeature || this.movement instanceof PerimeterMovementFeature) {
            EXOTIC.add(this);
        } else {
            TYPES.add(this);
        }
        if (!this.boss && (this.movement instanceof XYMovementFeature || this.movement instanceof ScuttleMovementFeature) && this.brain instanceof ShooterBrainFeature) {
            ASSAULT.add(this);
            Collections.sort(ASSAULT, new Comparator<GidrahFeature>(){

                @Override
                public int compare(GidrahFeature g0, GidrahFeature g1) {
                    if (g0.level > g1.level) {
                        return 1;
                    }
                    if (g0.level < g1.level) {
                        return -1;
                    }
                    if (g0.score > g1.score) {
                        return 1;
                    }
                    if (g0.score == g1.score) {
                        return 0;
                    }
                    return -1;
                }
            });
        }
    }

    protected void doDeregister() {
        if (this.boss) {
            BOSS.remove((Object)this);
        } else if (this.brain instanceof SpawnerBrainFeature || this.brain instanceof MinelayerBrainFeature || this.movement instanceof ScuttleMovementFeature || this.movement instanceof PerimeterMovementFeature) {
            EXOTIC.remove((Object)this);
        } else {
            TYPES.remove((Object)this);
        }
        if (!this.boss && (this.movement instanceof XYMovementFeature || this.movement instanceof ScuttleMovementFeature) && this.brain instanceof ShooterBrainFeature) {
            ASSAULT.remove((Object)this);
        }
    }

    public static void resetNumGidrahs() {
        numGidrahs = 0;
        difficultyAdjustment = 0;
    }

    public static int getNumGidrahs() {
        return numGidrahs;
    }

    public static void createGidrah() {
        if (++exoticCount > GameScreen.getLevel() || exoticCount >= 3 && difficultyAdjustment == 0) {
            exoticCount = 0;
            GidrahFeature.createExoticGidrah();
        } else {
            int time = GameScreen.getLevel() - 1;
            Player player = GameScreen.getPlayer();
            int shields = player.getShields();
            int extras = (player.isThreeWay() ? 2 : 0) + (player.isBouncy() ? 2 : 0) + (player.isInvulnerable() ? 2 : 0);
            int multiplier = player.getBulletPower() + player.getMultiplier() + (shields > 5 ? shields - 5 : 0) - 2;
            int minBot = Math.min(TYPES.size() - 1, Math.max(0, extras + time + difficultyAdjustment - TYPES.size()));
            int maxBot = Math.min(TYPES.size() - 1, Math.max(minBot, extras + multiplier + time + difficultyAdjustment));
            int bot = Util.random((int)minBot, (int)maxBot);
            GidrahFeature gf = TYPES.get(bot);
            difficultyAdjustment = Math.min(0, difficultyAdjustment + minBot + player.getMultiplier() + (shields > 5 ? shields - 5 : 0) - gf.difficulty);
            gf.spawn(GameScreen.getInstance());
        }
    }

    public static void createAssault(int type, int number) {
        type = Math.min(ASSAULT.size() - 1, type);
        GidrahFeature gf = ASSAULT.get(type);
        int i = 0;
        while (i < number) {
            gf.spawn(GameScreen.getInstance());
            ++i;
        }
    }

    public static void createBosses() {
        int level = GameScreen.getLevel() - 1;
        int numBosses = 1 + level / (10 * BOSS.size());
        int boss = level / 10 % BOSS.size();
        int i = 0;
        while (i < numBosses) {
            GidrahFeature gf = BOSS.get(boss++);
            boss %= BOSS.size();
            gf.spawn(GameScreen.getInstance());
            ++i;
        }
    }

    private static void createExoticGidrah() {
        int time = GameScreen.getLevel() - 1;
        int shields = GameScreen.getPlayer().getShields();
        int multiplier = GameScreen.getPlayer().getBulletPower() + GameScreen.getPlayer().getMultiplier() + (shields > 5 ? shields - 5 : 0) - 1;
        if (multiplier + time < 10) {
            GidrahFeature.createGidrah();
            return;
        }
        int minBot = Math.min(EXOTIC.size() - 1, Math.max(0, time - EXOTIC.size()));
        int maxBot = Math.min(EXOTIC.size() - 1, Math.max(minBot, multiplier + time - 10));
        int bot = Util.random((int)minBot, (int)maxBot);
        GidrahFeature gf = EXOTIC.get(bot);
        difficultyAdjustment = Math.min(0, minBot + multiplier + difficultyAdjustment - gf.difficulty);
        gf.spawn(GameScreen.getInstance());
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        if (this.boss) {
            this.score = 1000;
            this.hitPoints = 100;
        } else {
            int bhp = this.brain == null ? 1 : this.brain.getHitPoints();
            int mhp = this.movement == null ? 4 : this.movement.getHitPoints();
            this.hitPoints = (bhp + mhp) * (this.level + 1);
            int ba = this.brain == null ? 0 : this.brain.getArmour();
            int ma = this.movement == null ? 0 : this.movement.getArmour();
            this.armour = ba + ma + this.level;
            float hpScore = this.hitPoints < 2 ? 1.0f : (this.hitPoints < 4 ? 1.5f : (this.hitPoints < 6 ? 2.0f : (this.hitPoints < 12 ? 2.5f : (this.hitPoints < 20 ? 3.0f : (this.hitPoints < 30 ? 3.5f : (this.hitPoints < 40 ? 4.0f : (this.hitPoints < 50 ? 4.5f : 5.0f)))))));
            int bd = this.brain == null ? -1 : this.brain.getDifficulty();
            int md = this.movement == null ? -1 : this.movement.getDifficulty();
            this.difficulty = Math.max(0, bd + md + this.level + (this.bomber ? 2 : 0));
            int bs = this.brain == null ? 10 : this.brain.getScore();
            int ms = this.movement == null ? 0 : this.movement.getScore();
            this.score = ((int)((float)(bs + ms) * hpScore) / 50 * 50 + 50) * (this.difficulty + 1);
        }
        assert (this.hitPoints > 0);
        assert (this.score > 0);
        this.spawnType = this.movement == null ? "random" : this.movement.getSpawnType();
    }

    public static void resetDifficulty() {
        difficultyAdjustment = 0;
    }

    protected static class GidrahInstance
    extends Entity
    implements Gidrah {
        private static final long serialVersionUID = 1L;
        private transient GidrahFeature gidrahFeature;
        private String gidrahFeatureName;
        private int phase;
        private int tick;
        private int wounds;
        private int facing = 1;
        private int flashTick;
        private transient Brain brainInstance;
        private transient Movement movementInstance;
        private transient Effect spawnEffect;
        private transient SoundEffect soundEffectInstance;
        private Sprite freezeSprite;
        private int freezeTimer;
        private transient PowerDisplay powerDisplayInstance;

        protected GidrahInstance(GidrahFeature gidrahFeature) {
            this.gidrahFeature = gidrahFeature;
        }

        private boolean isBoss() {
            return this.gidrahFeature.boss;
        }

        public void freeze() {
            if (this.isBoss() || this.phase != 2) {
                return;
            }
            if (this.freezeTimer == 0) {
                this.freezeSprite = GameScreen.getInstance().allocateSprite(this);
                ReadablePoint offset = GameScreen.getSpriteOffset();
                this.freezeSprite.setLocation((float)((int)this.getX() + offset.getX()), (float)((int)this.getY() + offset.getY()), 0.0f);
                this.freezeSprite.setAppearance(Res.getIceAppearance());
                this.freezeSprite.setLayer(4);
            }
            this.freezeTimer += Util.random((int)1800, (int)6400);
            if (this.freezeSprite != null) {
                this.freezeSprite.setAlpha(255);
            }
            this.vx = 0.0f;
            this.vy = 0.0f;
        }

        public void shortFreeze() {
            if (this.isBoss() || this.phase != 2 || this.freezeTimer != 0) {
                return;
            }
            this.freezeTimer = 20;
            this.vx = 0.0f;
            this.vy = 0.0f;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            this.gidrahFeatureName = this.gidrahFeature.getName();
            stream.defaultWriteObject();
        }

        public void setFacing(int facing) {
            this.facing = facing;
        }

        public boolean canCollide() {
            return this.isActive() && (this.phase == 1 || this.phase == 2);
        }

        protected boolean autoRemove() {
            return !this.isBoss();
        }

        public final float getRadius() {
            return this.gidrahFeature.radius;
        }

        public void onCollision(Entity entity) {
            entity.onCollisionWithGidrah(this);
        }

        public void onCollisionWithBullet(Bullet bullet) {
            this.damage(bullet.getDamage());
        }

        public void onCollisionWithAttackDrone(AttackDrone drone) {
            if (!this.isBoss() && this.isDangerous()) {
                this.kill(true);
            }
        }

        public void onCollisionWithDroneBullet(DroneBullet bullet) {
            this.damage(GameScreen.getPlayer().getBulletPower());
        }

        public void onCollisionWithDefenceDrone(DefenceDrone drone) {
            if (!this.isBoss() && this.isDangerous()) {
                this.kill(true);
            }
        }

        public void onCollisionWithPlayer(Player player) {
            if (!this.isBoss() && this.isDangerous()) {
                this.kill(false);
            }
        }

        public void onCollisionWithShockwave(SmartBombShock shock) {
            if (!this.isBoss()) {
                this.kill(true);
            }
        }

        private void damage(int amount) {
            boolean dead;
            boolean award = true;
            if (amount < 0) {
                amount = -amount;
                award = this.isBoss();
            }
            if (!this.isBoss()) {
                int arm = this.gidrahFeature.armour + (this.freezeTimer > 0 ? 1 : 0);
                if ((amount = Math.max(0, amount - arm)) <= 0) {
                    int n = amount = Util.random((int)0, (int)(arm + 1)) > arm ? 1 : 0;
                }
                if (amount == 0) {
                    Emitter emitter = Res.getDeflectEmitter().spawn((Screen)GameScreen.getInstance());
                    emitter.setLocation(this.x, this.y);
                    return;
                }
            }
            this.wounds += amount;
            if (this.isBoss()) {
                int maxWounds = GameScreen.getLevel() * 5;
                this.powerDisplayInstance.setUsed(11 - 10 * this.wounds / maxWounds);
                dead = this.wounds > maxWounds;
            } else {
                boolean bl = dead = this.wounds >= this.gidrahFeature.hitPoints;
            }
            if (dead) {
                this.kill(award);
            } else {
                this.flash = true;
                this.flashTick = 4;
                Emitter emitter = Res.getRicochetEmitter().spawn((Screen)GameScreen.getInstance());
                emitter.setLocation(this.x, this.y);
            }
        }

        public boolean isDangerous() {
            return this.phase == 2;
        }

        public void kill(boolean award) {
            block15: {
                int amount;
                block17: {
                    block16: {
                        this.remove();
                        if (!award) break block15;
                        if (!this.isBoss()) break block16;
                        amount = GameScreen.getLevel() * this.gidrahFeature.score;
                        switch (Puppytron.getGameState().getLevel()) {
                            case 9: {
                                Puppytron.getGameState().awardMedal("ieiunitas");
                                break;
                            }
                            case 19: {
                                Puppytron.getGameState().awardMedal("letum");
                                break;
                            }
                            case 29: {
                                Puppytron.getGameState().awardMedal("lues");
                                break;
                            }
                            case 39: {
                                Puppytron.getGameState().awardMedal("bellum");
                                break;
                            }
                            case 49: {
                                if (Puppytron.getGameState().getNumGidrahs() == 0) {
                                    Puppytron.getGameState().awardMedal("double_dose");
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block17;
                    }
                    amount = GameScreen.getPlayer().getMultiplier() * this.gidrahFeature.score;
                }
                Puppytron.addScore(amount);
                LabelEffect le = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), String.valueOf(amount), ReadableColor.YELLOW, ReadableColor.RED, 50, 25);
                le.setVelocity(0.0f, 1.0f);
                le.setAcceleration(0.0f, -0.013f);
                le.setLocation((float)((int)this.x), (float)((int)this.y));
                le.setVisible(true);
                le.spawn((Screen)GameScreen.getInstance());
                if (Puppytron.isPowerupDue() && !this.isBoss()) {
                    Powerup gp = Powerup.createPowerup();
                    gp.setLocation(this.x, this.y);
                    gp.spawn(GameScreen.getInstance());
                }
            }
            if (this.freezeTimer > 0) {
                Emitter emitter = Res.getIceEmitter().spawn((Screen)GameScreen.getInstance());
                emitter.setLocation(this.x, this.y);
            } else if (this.gidrahFeature.deathEmitter != null) {
                Emitter emitter = this.gidrahFeature.deathEmitter.spawn((Screen)GameScreen.getInstance());
                emitter.setLocation(this.x, this.y);
            } else if (this.gidrahFeature.deathSoundResource != null) {
                Game.allocateSound((ALBuffer)this.gidrahFeature.deathSoundResource);
            } else {
                Game.allocateSound((ALBuffer)Res.getEnemyDeath());
            }
        }

        protected void doTick() {
            if (this.freezeTimer > 0) {
                --this.freezeTimer;
                if (this.freezeTimer == 0) {
                    if (this.freezeSprite != null) {
                        this.freezeSprite.deallocate();
                        this.freezeSprite = null;
                    }
                } else if (this.freezeTimer < 60 && this.freezeSprite != null) {
                    this.freezeSprite.setAlpha(255 * this.freezeTimer / 60);
                }
                this.updateFlash();
                return;
            }
            ++this.tick;
            switch (this.phase) {
                case 0: {
                    if (this.isBoss()) {
                        if (this.tick != 300) break;
                        this.phase = 2;
                        this.tick = 0;
                        if (this.gidrahFeature.soundEffectResource == null) break;
                        this.soundEffectInstance = Game.allocateSound((ALBuffer)this.gidrahFeature.soundEffectResource);
                        break;
                    }
                    if (this.spawnEffect == null || !this.spawnEffect.isActive()) {
                        this.tick = 0;
                        this.spawnEffect = null;
                        this.phase = 1;
                        if (this.gidrahFeature.spawnSoundResource != null && (this.isBoss() || Util.random((int)0, (int)4) == 0)) {
                            Puppytron.speak(this.gidrahFeature.spawnSoundResource);
                        }
                    } else {
                        if (this.spawnEffect == null) break;
                        ((SpawnEffect)this.spawnEffect).setLocation(this.x, this.y);
                        break;
                    }
                }
                case 1: {
                    if (this.tick >= 30) {
                        this.tick = 0;
                        this.phase = 2;
                        this.visible = true;
                        if (this.gidrahFeature.soundEffectResource != null) {
                            this.soundEffectInstance = Game.allocateSound((ALBuffer)this.gidrahFeature.soundEffectResource);
                        }
                        if (this.powerDisplayInstance != null) {
                            this.powerDisplayInstance.setVisible(true);
                        }
                    } else {
                        this.visible = (this.tick & 4) == 0;
                        break;
                    }
                }
                case 2: {
                    int oldFacing = this.facing;
                    if (this.brainInstance != null) {
                        this.brainInstance.tick(this);
                    }
                    if (this.movementInstance != null) {
                        this.movementInstance.tick(this);
                    }
                    if (oldFacing == this.facing) break;
                    this.sprite.setMirrored(this.facing == -1);
                }
            }
            this.updateFlash();
        }

        public void update() {
            super.update();
            if (this.isBoss() && this.powerDisplayInstance != null) {
                ReadablePoint spriteOffset = GameScreen.getSpriteOffset();
                this.powerDisplayInstance.setLocation((float)((int)this.x + this.gidrahFeature.powerOffset.getX() + spriteOffset.getX()), (float)((int)(this.y - this.getRadius() + (float)this.gidrahFeature.powerOffset.getX() + (float)spriteOffset.getY())));
            }
        }

        private void updateFlash() {
            if (this.flashTick > 0) {
                --this.flashTick;
                this.flash = this.flashTick > 0;
            }
        }

        public void shoot(float tx, float ty, int accuracy) {
            if (this.gidrahFeature.bomber) {
                this.bomb(tx, ty, false);
            } else {
                int aim = Util.random((int)0, (int)100);
                if (aim >= accuracy + GameScreen.getLevel()) {
                    tx += (float)Util.random((int)(accuracy - aim), (int)(aim - accuracy));
                    ty += (float)Util.random((int)(accuracy - aim), (int)(aim - accuracy));
                }
                EnemyBullet eb = new EnemyBullet(this.x, this.y, tx, ty);
                eb.spawn(GameScreen.getInstance());
            }
        }

        public void bomb(float tx, float ty, boolean big) {
            Bomb b = new Bomb(this.x, this.y, tx, ty, big ? 90.0f : 45.0f, big ? 60 : 30);
            b.spawn(GameScreen.getInstance());
        }

        public int getLevel() {
            return this.gidrahFeature.level;
        }

        public void layMine() {
            Mine mine = new Mine(this.gidrahFeature.level, this.x, this.y);
            mine.spawn(GameScreen.getInstance());
        }

        protected void doRemove() {
            numGidrahs = numGidrahs - 1;
            if (this.soundEffectInstance != null) {
                this.soundEffectInstance.stop(Game.class);
                this.soundEffectInstance = null;
            }
            if (this.freezeSprite != null) {
                this.freezeSprite.deallocate();
                this.freezeSprite = null;
            }
            if (this.powerDisplayInstance != null) {
                this.powerDisplayInstance.cleanup();
                this.powerDisplayInstance = null;
            }
        }

        protected void doRespawn() {
            try {
                this.gidrahFeature = (GidrahFeature)Resources.get((String)this.gidrahFeatureName);
                this.gidrahFeatureName = null;
                numGidrahs = numGidrahs + 1;
                if (this.isBoss()) {
                    this.powerDisplayInstance = this.gidrahFeature.powerDisplayFeature.spawn((Screen)GameScreen.getInstance());
                    this.powerDisplayInstance.setUsed(10);
                    this.powerDisplayInstance.setVisible(false);
                }
                if (this.gidrahFeature.brain != null) {
                    this.brainInstance = this.gidrahFeature.brain.spawn(this);
                }
                if (this.gidrahFeature.movement != null) {
                    this.movementInstance = this.gidrahFeature.movement.spawn(this);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.remove();
            }
        }

        protected void doSpawn() {
            numGidrahs = numGidrahs + 1;
            if (this.isBoss()) {
                this.x = Game.getScale() / 2;
                this.y = (float)Game.getScale() + this.getRadius();
                this.vy = -0.5f;
                this.powerDisplayInstance = this.gidrahFeature.powerDisplayFeature.spawn((Screen)GameScreen.getInstance());
                this.powerDisplayInstance.setUsed(10);
            } else {
                float dy;
                float dx;
                float distance = 0.0f;
                int count = 0;
                do {
                    this.setSpawnLocation();
                } while ((distance = (float)Math.sqrt((dx = this.x - GameScreen.getPlayer().getX()) * dx + (dy = this.y - GameScreen.getPlayer().getY()) * dy)) < 80.0f && count++ < 8);
                if (this.gidrahFeature.spawnEmitter != null) {
                    this.spawnEffect = this.gidrahFeature.spawnEmitter.spawn((Screen)GameScreen.getInstance());
                    ((Emitter)this.spawnEffect).setLocation(this.x, this.y);
                } else {
                    int d = Math.min(SPAWN_COLOR.length - 1, this.gidrahFeature.difficulty);
                    this.spawnEffect = new SpawnEffect((int)this.x, (int)this.y, SPAWN_COLOR[d], 30 + this.gidrahFeature.difficulty * 10);
                    this.spawnEffect.spawn((Screen)GameScreen.getInstance());
                }
                this.visible = false;
            }
            this.sprite.setAppearance(this.gidrahFeature.animationAppearance);
            if (this.gidrahFeature.brain != null) {
                this.brainInstance = this.gidrahFeature.brain.spawn(this);
            }
            if (this.gidrahFeature.movement != null) {
                this.movementInstance = this.gidrahFeature.movement.spawn(this);
            }
        }

        private void setSpawnLocation() {
            int inset;
            int n = inset = this.isBoss() ? 60 : 10;
            if (this.gidrahFeature.spawnType != null && this.gidrahFeature.spawnType.charAt(0) == 'e') {
                int edge = Util.random((int)0, (int)3);
                switch (edge) {
                    case 0: {
                        this.x = Util.random((int)0, (int)((Game.getScale() - 32 - inset * 2) / 16)) * 16 + 16 + inset;
                        this.y = 26.0f;
                        break;
                    }
                    case 1: {
                        this.x = Util.random((int)0, (int)((Game.getScale() - 32 - inset * 2) / 16)) * 16 + 16 + inset;
                        this.y = Game.getScale() - 16 - inset;
                        break;
                    }
                    case 2: {
                        this.x = 26.0f;
                        this.y = Util.random((int)0, (int)((Game.getScale() - 32 - inset * 2) / 16)) * 16 + 16 + inset;
                        break;
                    }
                    case 3: {
                        this.x = Game.getScale() - 16 - inset;
                        this.y = Util.random((int)0, (int)((Game.getScale() - 32 - inset * 2) / 16)) * 16 + 16 + inset;
                    }
                }
            } else {
                this.x = Util.random((int)0, (int)((Game.getScale() - 32 - inset * 2) / 16 * 16)) + 16 + inset;
                this.y = Util.random((int)0, (int)((Game.getScale() - 32 - inset * 2) / 16)) * 16 + 16 + inset;
            }
        }

        public Movement getMovement() {
            return this.movementInstance;
        }

        public void setMovement(Movement newMovement) {
            this.movementInstance = newMovement;
        }
    }
}

