/*
 * Decompiled with CFR 0.152.
 */
package puppytron.features;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.Appearance;
import com.shavenpuppy.jglib.util.FPMath;
import java.io.IOException;
import java.io.ObjectOutputStream;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.EmitterFeature;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Gidrah;
import puppytron.Res;
import puppytron.entities.Bullet;

public class BulletFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final int MAX_POWER = 10;
    private static final BulletFeature[] BULLET_TYPES = new BulletFeature[10];
    private static int maxPower;
    private String appearance;
    private EmitterFeature trail;
    private String sound;
    private float velocity;
    private float radius;
    private int power;
    private int damage;
    private transient Appearance appearanceResource;
    private transient ALBuffer soundResource;

    public BulletFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    public Bullet spawn(Screen screen) {
        BulletInstance ret = new BulletInstance(this);
        ret.spawn(screen);
        return ret;
    }

    public static BulletFeature getGun(int power) {
        if (power < 0) {
            return null;
        }
        if (power >= BULLET_TYPES.length) {
            return BULLET_TYPES[BULLET_TYPES.length - 1];
        }
        return BULLET_TYPES[power];
    }

    public static BulletFeature getSuperGun() {
        return BULLET_TYPES[maxPower];
    }

    protected void doRegister() {
        super.doRegister();
        BulletFeature.BULLET_TYPES[this.power] = this;
        maxPower = Math.max(maxPower, this.power);
    }

    protected void doDeregister() {
        super.doDeregister();
        BulletFeature.BULLET_TYPES[this.power] = null;
    }

    public static int getMaxBulletPower() {
        return 10;
    }

    private static class BulletInstance
    extends Bullet {
        private static final long serialVersionUID = 1L;
        private transient BulletFeature bulletFeature;
        private String bulletFeatureName;
        private transient Emitter trailEmitter;
        private int bounces;
        private int lastBounceTick;
        private Entity lastBounce;
        private Entity ignore;

        public BulletInstance(BulletFeature bulletFeature) {
            this.bulletFeature = bulletFeature;
        }

        public void ignore(Entity entity) {
            this.ignore = entity;
        }

        public BulletFeature getFeature() {
            return this.bulletFeature;
        }

        public void init(float newX, float newY, float tx, float ty) {
            double dx = tx - newX;
            double dy = ty - newY;
            double angle = Math.atan2(dy, dx);
            double ddx = Math.cos(angle);
            double ddy = Math.sin(angle);
            this.vx = (float)(ddx * (double)this.bulletFeature.velocity);
            this.vy = (float)(ddy * (double)this.bulletFeature.velocity);
            this.x = newX + this.vx * 3.0f;
            this.y = newY + this.vy * 3.0f;
            this.setDirection();
        }

        private void setDirection() {
            double angle = Math.atan2(this.vy, this.vx);
            this.sprite.setAngle(FPMath.fpYaklyDegrees((double)angle));
        }

        protected void doTick() {
            this.x += this.vx;
            this.y += this.vy;
            if (GameScreen.getPlayer().isBouncy() && this.bounces < 1) {
                if (this.x < 0.0f) {
                    this.vx = -this.vx;
                    ++this.bounces;
                    this.setDirection();
                } else if (this.x >= (float)Game.getScale()) {
                    this.vx = -this.vx;
                    ++this.bounces;
                    this.setDirection();
                }
                if (this.y < 0.0f) {
                    this.vy = -this.vy;
                    ++this.bounces;
                    this.setDirection();
                } else if (this.y >= (float)Game.getScale()) {
                    this.vy = -this.vy;
                    ++this.bounces;
                    this.setDirection();
                }
            }
            this.sprite.setLocation((float)((int)this.x), (float)((int)this.y), 0.0f);
            if (this.trailEmitter != null) {
                this.trailEmitter.setLocation(this.x, this.y);
            }
        }

        protected void doSpawn() {
            this.sprite.setAppearance(this.bulletFeature.appearanceResource);
            if (this.bulletFeature.soundResource != null) {
                Game.allocateSound((ALBuffer)this.bulletFeature.soundResource);
            }
            if (this.bulletFeature.trail != null) {
                this.trailEmitter = this.bulletFeature.trail.spawn((Screen)GameScreen.getInstance());
            }
        }

        protected void doRespawn() {
            try {
                this.bulletFeature = (BulletFeature)Resources.get((String)this.bulletFeatureName);
                this.bulletFeatureName = null;
                if (this.bulletFeature.trail != null) {
                    this.trailEmitter = this.bulletFeature.trail.spawn((Screen)GameScreen.getInstance());
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.remove();
            }
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            this.bulletFeatureName = this.bulletFeature.getName();
            stream.defaultWriteObject();
        }

        protected void doRemove() {
            if (this.trailEmitter != null) {
                this.trailEmitter.remove();
                this.trailEmitter = null;
            }
        }

        public boolean canCollide() {
            return true;
        }

        public void onCollision(Entity entity) {
            if (entity == this.ignore) {
                return;
            }
            entity.onCollisionWithBullet(this);
        }

        public void onCollisionWithGidrah(Gidrah gidrah) {
            this.remove();
        }

        public float getRadius() {
            return this.bulletFeature.radius;
        }

        public int getDamage() {
            if (GameScreen.getPlayer().isBouncy()) {
                return Math.max(1, this.bulletFeature.damage - 1);
            }
            return this.bulletFeature.damage;
        }

        public void bounce(Entity target) {
            if (this.lastBounce == target) {
                ++this.lastBounceTick;
                if (this.lastBounceTick <= 8) {
                    this.remove();
                    return;
                }
            } else {
                this.lastBounceTick = 0;
                this.lastBounce = target;
            }
            Emitter emitter = Res.getRicochetEmitter().spawn((Screen)GameScreen.getInstance());
            emitter.setLocation(this.x, this.y);
            double ddx = target.getX() - this.getX();
            double ddy = target.getY() - this.getY();
            double angleOfCollision = Math.atan2(ddy, ddx);
            double diff = Math.atan2(this.vy, this.vx) - angleOfCollision;
            double reflection = angleOfCollision + Math.PI - diff;
            float tx = (float)Math.cos(reflection) * 128.0f + this.getX();
            float ty = (float)Math.sin(reflection) * 128.0f + this.getY();
            this.init(this.getX(), this.getY(), tx, ty);
        }
    }
}

