/*
 * Decompiled with CFR 0.152.
 */
package puppytron.entities;

import com.shavenpuppy.jglib.openal.ALBuffer;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.BlastEffect;
import net.puppygames.applet.effects.StrobeEffect;
import org.lwjgl.util.ReadableColor;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Res;

public class SmartBombShock
extends Entity {
    private static final long serialVersionUID = 1L;
    private transient BlastEffect effect;
    private static final int DURATION = 40;
    private static final float FINALRADIUS = 400.0f;
    private static final float WIDTH = 400.0f;

    public SmartBombShock(float x, float y) {
        this.x = x;
        this.y = y;
    }

    protected void doSpawn() {
        this.effect = new BlastEffect(this.x, this.y, 40, 0, 400.0f, 400.0f, Res.getSmartBombTexture());
        this.effect.spawn((Screen)GameScreen.getInstance());
        Game.allocateSound((ALBuffer)Res.getSmartBombBuffer());
        StrobeEffect se = new StrobeEffect(ReadableColor.WHITE, 60);
        se.spawn((Screen)GameScreen.getInstance());
    }

    protected void doRespawn() {
        this.remove();
    }

    protected void doTick() {
        if (!this.effect.isActive()) {
            this.remove();
        }
    }

    public boolean canCollide() {
        return true;
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithShockwave(this);
    }

    public float getRadius() {
        return this.effect.getRadius();
    }
}

