/*
 * Decompiled with CFR 0.152.
 */
package puppytron.entities;

import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Puppytron;
import puppytron.Res;
import puppytron.entities.Bullet;
import puppytron.entities.Mine;
import puppytron.entities.Player;
import puppytron.entities.Powerup;
import puppytron.entities.SmartBombShock;

public class Saucer
extends Entity {
    private static final long serialVersionUID = 1L;
    private static final float SPEED = 1.0f;
    private static final float SPEED_PER_LEVEL = 0.05f;
    private static final int INSET = 64;
    private static final int SAFETY_MARGIN = 16;
    private static final int MAX_TURNS = 2;
    private static final int MIN_TURN_TIME = 50;
    private static final int TURN_PROBABILITY = 120;
    private boolean challenge;
    private int turns;
    private int tick;
    private transient SoundEffect sound;
    private transient Emitter trail;
    private static int spawned = 0;
    private static int shot = 0;
    private static int removed = 0;

    public static void resetChallenge() {
        spawned = 0;
        shot = 0;
        removed = 0;
    }

    public static int getNumberShot() {
        return shot;
    }

    public static int getNumberSpawned() {
        return spawned;
    }

    public static int getNumberRemoved() {
        return removed;
    }

    public static void reinit(int newSpawned, int newShot, int newRemoved) {
        spawned = newSpawned;
        shot = newShot;
        removed = newRemoved;
    }

    public void setChallenge(boolean challenge) {
        this.challenge = challenge;
    }

    protected void doSpawn() {
        if (this.challenge) {
            ++spawned;
        }
        int edge = Util.random((int)0, (int)3);
        switch (edge) {
            case 0: {
                this.x = Util.random((int)0, (int)(Game.getScale() - 128)) + 64;
                this.y = Game.getScale();
                this.vx = 0.0f;
                this.vy = -1.0f - this.calcSpeed();
                this.sprite.setAngle(FPMath.HALF + FPMath.QUARTER);
                break;
            }
            case 1: {
                this.x = Util.random((int)0, (int)(Game.getScale() - 128)) + 64;
                this.y = 0.0f;
                this.vx = 0.0f;
                this.vy = 1.0f + this.calcSpeed();
                this.sprite.setAngle(FPMath.QUARTER);
                break;
            }
            case 2: {
                this.x = Game.getScale();
                this.y = Util.random((int)0, (int)(Game.getScale() - 128)) + 64;
                this.vx = -1.0f - this.calcSpeed();
                this.vy = 0.0f;
                this.sprite.setAngle(FPMath.HALF);
                break;
            }
            case 3: {
                this.x = 0.0f;
                this.y = Util.random((int)0, (int)(Game.getScale() - 128)) + 64;
                this.vx = 1.0f + this.calcSpeed();
                this.vy = 0.0f;
                this.sprite.setAngle(0);
            }
        }
        this.sprite.setAppearance(Res.getSaucerAppearance());
        this.sound = Game.allocateSound((ALBuffer)Res.getSaucerSound());
        if (!this.challenge) {
            this.trail = Res.getSaucerTrailEmitter().spawn((Screen)GameScreen.getInstance());
            this.trail.setLocation(this.getX(), this.getY());
        }
    }

    private float calcSpeed() {
        float speed = 0.05f * (float)GameScreen.getLevel();
        if (Puppytron.isUsingMouse()) {
            speed *= 2.0f;
        }
        return speed;
    }

    protected void doRespawn() {
    }

    private void turn() {
        ++this.turns;
        this.tick = 0;
        int dir = Util.random((int)0, (int)3);
        float speed = this.calcSpeed();
        switch (dir) {
            case 0: {
                this.vx = 0.0f;
                this.vy = -1.0f - speed;
                this.sprite.setAngle(FPMath.HALF + FPMath.QUARTER);
                break;
            }
            case 1: {
                this.vx = 0.0f;
                this.vy = 1.0f + speed;
                this.sprite.setAngle(FPMath.QUARTER);
                break;
            }
            case 2: {
                this.vx = -1.0f - speed;
                this.vy = 0.0f;
                this.sprite.setAngle(FPMath.HALF);
                break;
            }
            case 3: {
                this.vx = 1.0f + speed;
                this.vy = 0.0f;
                this.sprite.setAngle(0);
            }
        }
    }

    protected void doRemove() {
        if (this.sound != null) {
            this.sound.stop(Game.class);
            this.sound = null;
        }
        if (this.trail != null) {
            this.trail.remove();
            this.trail = null;
        }
        if (this.challenge) {
            ++removed;
            this.challenge = false;
        }
    }

    public boolean canCollide() {
        return this.x >= 16.0f && this.y >= 16.0f && this.x <= (float)(Game.getScale() - 16) && this.y <= (float)(Game.getScale() - 16);
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithSaucer(this);
    }

    private void kill(boolean drop) {
        if (drop) {
            Powerup p = Powerup.createExoticPowerup();
            p.setLocation(this.x, this.y);
            p.spawn(GameScreen.getInstance());
        }
        Emitter emitter = Res.getSaucerEmitter().spawn((Screen)GameScreen.getInstance());
        emitter.setLocation(this.x, this.y);
        this.remove();
    }

    public void onCollisionWithPlayer(Player player) {
        this.kill(false);
    }

    public void onCollisionWithMine(Mine mine) {
        if (this.challenge) {
            return;
        }
        this.kill(false);
    }

    public void onCollisionWithBullet(Bullet bullet) {
        if (this.challenge) {
            ++shot;
        }
        this.kill(!this.challenge);
    }

    public void onCollisionWithShockwave(SmartBombShock shock) {
        if (this.challenge) {
            return;
        }
        this.kill(true);
    }

    public float getRadius() {
        return 11.0f;
    }

    protected void doTick() {
        if (this.trail != null) {
            this.trail.setLocation(this.getX(), this.getY());
        }
        ++this.tick;
        int turnProbability = 120 - (GameScreen.getPlayer().isThreeWay() ? 30 : 0);
        if (Puppytron.isUsingMouse()) {
            turnProbability -= 30;
        }
        if (this.tick > 50 && this.turns < 2 && Util.random((int)0, (int)turnProbability) == 0) {
            this.turn();
        }
    }
}

