/*
 * Decompiled with CFR 0.152.
 */
package puppytron.entities;

import com.shavenpuppy.jglib.sprites.Sprite;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import org.lwjgl.util.ReadablePoint;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Gidrah;
import puppytron.Res;
import puppytron.entities.Bomb;

public class DroneBullet
extends Entity {
    private static final long serialVersionUID = 1L;
    private static final float BULLET_SPEED = 2.0f;
    private transient Emitter emitter;
    private Sprite background;
    private int damage;

    public DroneBullet(float x, float y, float tx, float ty, int damage) {
        this.x = x;
        this.y = y;
        this.damage = damage;
        float dist = (float)Math.sqrt((x - tx) * (x - tx) + (y - ty) * (y - ty));
        this.vx = 2.0f * (tx - x) / dist;
        this.vy = 2.0f * (ty - y) / dist;
    }

    public int getDamage() {
        return this.damage;
    }

    protected void doSpawn() {
        this.sprite.setAppearance(Res.getDroneBullet());
        this.sprite.setLayer(2);
        this.emitter = Res.getDroneBulletEmitter().spawn((Screen)GameScreen.getInstance());
        this.emitter.setLocation(this.x, this.y);
        this.background = GameScreen.getInstance().allocateSprite(this);
        this.background.setAppearance(Res.getEnemyBulletBackground());
    }

    protected void doRespawn() {
        this.emitter = Res.getDroneBulletEmitter().spawn((Screen)GameScreen.getInstance());
        this.emitter.setLocation(this.x, this.y);
    }

    protected void doRemove() {
        if (this.emitter != null) {
            this.emitter.remove();
            this.emitter = null;
        }
        if (this.background != null) {
            this.background.deallocate();
            this.background = null;
        }
    }

    public boolean canCollide() {
        return true;
    }

    public float getRadius() {
        return 1.5f;
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithDroneBullet(this);
    }

    public void onCollisionWithGidrah(Gidrah gidrah) {
        this.remove();
    }

    public void onCollisionWithBomb(Bomb bomb) {
        this.remove();
    }

    protected void doTick() {
        float newX = this.x + this.vx;
        float newY = this.y + this.vy;
        this.emitter.setLocation(newX, newY);
    }

    public void update() {
        super.update();
        ReadablePoint spriteOffset = GameScreen.getSpriteOffset();
        this.background.setLocation(this.x + (float)spriteOffset.getX(), this.y + (float)spriteOffset.getY(), 0.0f);
    }
}

