/*
 * Decompiled with CFR 0.152.
 */
package puppytron.entities;

import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Gidrah;
import puppytron.Res;
import puppytron.entities.Bomb;
import puppytron.entities.DroneBullet;
import puppytron.entities.EnemyBullet;
import puppytron.entities.Mine;

public class DefenceDrone
extends Entity {
    private static final long serialVersionUID = 1L;
    private static final int MAX_WOUNDS = 10;
    private static final int SHOOT_INTERVAL = 28;
    private static final int SHOOT_INTERVAL_MULTIPLIER = 2;
    private static int numDrones = 0;
    private int wounds;
    private int tick;

    public DefenceDrone() {
        this.x = GameScreen.getPlayer().getX();
        this.y = GameScreen.getPlayer().getY();
    }

    protected void doSpawn() {
        ++numDrones;
        this.sprite.setAppearance(Res.getDefenceDroneAppearance());
    }

    public boolean canCollide() {
        return true;
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithDefenceDrone(this);
    }

    private void damage(int amount) {
        this.wounds += amount;
        if (this.wounds > 10) {
            this.kill();
        }
        Emitter emitter = Res.getDeflectEmitter().spawn((Screen)GameScreen.getInstance());
        emitter.setLocation(this.x, this.y);
    }

    private void kill() {
        this.remove();
        Emitter emitter = Res.getPowerupRicochetEmitterFeature().spawn((Screen)GameScreen.getInstance());
        emitter.setLocation(this.x, this.y);
    }

    public void onCollisionWithEnemyBullet(EnemyBullet enemyBullet) {
        this.damage(1);
    }

    public void onCollisionWithGidrah(Gidrah gidrah) {
        if (gidrah.isDangerous()) {
            this.damage(gidrah.getLevel() + 1);
        }
    }

    public void onCollisionWithMine(Mine mine) {
        this.damage(mine.getLevel() + 1);
    }

    public void onCollisionWithBomb(Bomb bomb) {
        this.damage(10);
    }

    public float getRadius() {
        return 11.0f;
    }

    protected void doTick() {
        ++this.tick;
        if (this.tick > 28 + GameScreen.getPlayer().getRepeatRate() * 2) {
            this.tick = 0;
            this.shoot();
        }
    }

    private void shoot() {
        if (GameScreen.getPlayer() == null) {
            return;
        }
        DroneBullet b = new DroneBullet(this.getX(), this.getY(), GameScreen.getPlayer().getX(), GameScreen.getPlayer().getY(), GameScreen.getPlayer().getBulletPower());
        b.spawn(GameScreen.getInstance());
    }

    protected void doRemove() {
        --numDrones;
    }

    protected void doRespawn() {
        ++numDrones;
    }
}

