/*
 * Decompiled with CFR 0.152.
 */
package puppytron.effects;

import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class SpawnEffect
extends Effect {
    private static final Color cachedColor = new Color();
    private static final int SIZE = 4;
    private static final GLRenderable SETUP = new GLRenderable(){

        public void render() {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDisable((int)3553);
        }
    };
    private static final short[] INDICES;
    private float x;
    private float y;
    private ReadableColor startColor;
    private ReadableColor endColor;
    private int tick;
    private int duration;

    static {
        short[] sArray = new short[10];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[3] = 3;
        sArray[4] = 4;
        sArray[5] = 5;
        sArray[6] = 6;
        sArray[7] = 7;
        sArray[9] = 1;
        INDICES = sArray;
    }

    public SpawnEffect(int x, int y, ReadableColor color, int duration) {
        this.x = x;
        this.y = y;
        this.startColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
        this.endColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
        this.duration = duration;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    protected void doTick() {
        ++this.tick;
    }

    protected void render() {
        float ratio = (float)this.tick / (float)this.duration;
        ColorInterpolator.interpolate((ReadableColor)this.startColor, (ReadableColor)this.endColor, (float)ratio, (Interpolator)LinearInterpolator.instance, (Color)cachedColor);
        int dt = this.duration - this.tick << 2;
        int ox = this.getOffset().getX();
        int oy = this.getOffset().getY();
        byte redByte = cachedColor.getRedByte();
        byte greenByte = cachedColor.getGreenByte();
        byte blueByte = cachedColor.getBlueByte();
        this.glRender(SETUP);
        this.glColor4ub(redByte, greenByte, blueByte, (byte)0);
        this.glVertex2f(this.x - (float)dt - 4.0f + (float)ox, this.y - (float)dt - 4.0f + (float)oy);
        this.glColor4ub(redByte, greenByte, blueByte, (byte)-1);
        this.glVertex2f(this.x - (float)dt + (float)ox, this.y - (float)dt + (float)oy);
        this.glColor4ub(redByte, greenByte, blueByte, (byte)0);
        this.glVertex2f(this.x + (float)dt + 4.0f + (float)ox, this.y - (float)dt - 4.0f + (float)oy);
        this.glColor4ub(redByte, greenByte, blueByte, (byte)-1);
        this.glVertex2f(this.x + (float)dt + (float)ox, this.y - (float)dt + (float)oy);
        this.glColor4ub(redByte, greenByte, blueByte, (byte)0);
        this.glVertex2f(this.x + (float)dt + 4.0f + (float)ox, this.y + (float)dt + 4.0f + (float)oy);
        this.glColor4ub(redByte, greenByte, blueByte, (byte)-1);
        this.glVertex2f(this.x + (float)dt + (float)ox, this.y + (float)dt + (float)oy);
        this.glColor4ub(redByte, greenByte, blueByte, (byte)0);
        this.glVertex2f(this.x - (float)dt - 4.0f + (float)ox, this.y + (float)dt + 4.0f + (float)oy);
        this.glColor4ub(redByte, greenByte, blueByte, (byte)-1);
        this.glVertex2f(this.x - (float)dt + (float)ox, this.y + (float)dt + (float)oy);
        this.glRender(5, INDICES);
    }

    public int getDefaultLayer() {
        return 5;
    }

    public boolean isEffectActive() {
        return this.tick < this.duration;
    }
}

