/*
 * Decompiled with CFR 0.152.
 */
package puppytron.brains;

import com.shavenpuppy.jglib.util.Util;
import puppytron.Brain;
import puppytron.GameScreen;
import puppytron.Gidrah;
import puppytron.Movement;
import puppytron.features.BrainFeature;

public class BossBrainFeature
extends BrainFeature {
    private static final long serialVersionUID = 1L;
    private int timer;
    private int salvoInterval;
    private int salvoDuration;
    private int spreadShots;
    private int spreadDelay;
    private int bombDelay;
    private boolean randomAim;
    private boolean bomb;
    private static final int PHASE_MOVE = 0;
    private static final int PHASE_AIM = 1;
    private static final int PHASE_SPREAD = 2;
    private static final int PHASE_BOMB = 3;

    public Brain spawn(Gidrah gidrah) {
        return new BossBrainInstance(gidrah);
    }

    public int getScore() {
        return 0;
    }

    public int getHitPoints() {
        return 0;
    }

    public int getArmour() {
        return 0;
    }

    public int getDifficulty() {
        return 0;
    }

    private class BossBrainInstance
    extends BrainFeature.BrainInstance {
        int tick;
        int phase;
        Movement oldMovement;

        protected BossBrainInstance(Gidrah gidrah) {
            super(BossBrainFeature.this, gidrah);
        }

        public void tick(Gidrah moveableGidrah) {
            switch (this.phase) {
                case 0: {
                    this.move();
                    break;
                }
                case 1: {
                    this.aim();
                    break;
                }
                case 2: {
                    this.spread();
                    break;
                }
                case 3: {
                    this.bomb();
                }
            }
        }

        void move() {
            ++this.tick;
            if (this.tick > BossBrainFeature.this.timer) {
                this.phase = Util.random((int)1, (int)3);
                this.tick = 0;
                this.oldMovement = this.gidrah.getMovement();
                this.gidrah.setMovement(null);
                this.gidrah.setVelocity(0.0f, 0.0f);
            }
        }

        void aim() {
            ++this.tick;
            if (this.tick > BossBrainFeature.this.salvoDuration) {
                this.reset();
            } else if (this.tick % BossBrainFeature.this.salvoInterval == 0) {
                if (BossBrainFeature.this.bomb) {
                    this.gidrah.bomb(GameScreen.getPlayer().getX(), GameScreen.getPlayer().getY(), false);
                } else {
                    this.gidrah.shoot(GameScreen.getPlayer().getX(), GameScreen.getPlayer().getY(), BossBrainFeature.this.randomAim ? 0 : 100);
                }
            }
        }

        void reset() {
            this.phase = 0;
            this.tick = 0;
            this.gidrah.setMovement(this.oldMovement);
            this.gidrah.setEvent(2);
        }

        void spread() {
            ++this.tick;
            int offset = Util.random((int)0, (int)BossBrainFeature.this.spreadShots);
            if (this.tick >= BossBrainFeature.this.spreadDelay) {
                int i = 0;
                while (i < BossBrainFeature.this.spreadShots) {
                    float tx = this.gidrah.getX() + (float)Math.cos(Math.PI * 2 * (double)(i + offset) / (double)BossBrainFeature.this.spreadShots) * 100.0f;
                    float ty = this.gidrah.getY() + (float)Math.sin(Math.PI * 2 * (double)(i + offset) / (double)BossBrainFeature.this.spreadShots) * 100.0f;
                    this.gidrah.shoot(tx, ty, BossBrainFeature.this.randomAim ? 0 : 100);
                    ++i;
                }
                this.reset();
            }
        }

        void bomb() {
            ++this.tick;
            if (this.tick >= BossBrainFeature.this.bombDelay) {
                this.gidrah.bomb(GameScreen.getPlayer().getX(), GameScreen.getPlayer().getY(), true);
                this.reset();
            }
        }
    }
}

